#!/usr/bin/python
# -*- coding: utf-8 -*-
# 必要なライブラリ
import pandas as pd
pd.set_option('display.max_columns', 99999)
pd.set_option('display.max_rows', 500)
import pandas as pd
from pandas import Series, DataFrame
import datetime
from datetime import timedelta

import cgi
import sqlite3
import sys
import json

data = sys.stdin.read()
params = json.loads(data)


df = pd.read_csv('testdata_2.csv', dtype = 'object')
# 属性カラムを判断し左からattr1, attr2, .. と命名 ※ 必須項目以外について、存在しない場合の処理はお任せします。
attr_columns = df.columns.drop(['origin_area', 'origin_area_lat', 'origin_area_lng', 'destination_area', 'destination_area_lat', 'destination_area_lng', 'year', 'month', 'date', 'hour', 'holiday', 'value'])
attrs = [] # attr1, attr2, ...→この後の処理に使用 
attrs_name = [] #  csv内のもとの名前→HTML内のフィルターの題名や、属性分析の属性選択リストに使用
for i, column in enumerate(attr_columns):
    df.rename(columns={column: f'attr{i+1}'}, inplace=True)
    attrs.append(f'attr{i+1}')
    attrs_name.append(column)
# 型指定（attr情報はobjectのまま）
df['origin_area'] = df['origin_area'].astype(str)
df['destination_area'] = df['destination_area'].astype(str)
df['year'] = df['year'].astype(int)
df['month'] = df['month'].astype(int)
df['date'] = df['date'].astype(int)
df['hour'] = df['hour'].astype(int)

result = {}
result["area_list"] = list(set([*df.groupby("origin_area").groups]) & set([*df.groupby("destination_area").groups]))
#result["destination_area_list"] = [*df.groupby("destination_area").groups]
result["year_list"] = [*df.groupby("year").groups]
result["month_list"] = [*df.groupby("month").groups]
result["date_list"] = [*df.groupby("date").groups]
result["hour_list"] = [*df.groupby("hour").groups]
result["holiday_list"] = [*df.groupby("holiday").groups]
result["week_list"] = ['Mon', 'Tue', 'Wed','Thu' ,'Fri','Sat','Sun']

for i in range(5):
    if f'attr{i+1}' in df.columns:
        result[f'attr{i+1}_list'] = [*df.groupby(f'attr{i+1}').groups]
    else:
        result[f'attr{i+1}_list'] = ['すべて']
result["attrs_name"] = attrs_name

result["init_year"] = df.at[df.index[0],'year'].astype(str)
result["init_month"] = df.at[df.index[0],'month'].astype(str)

print("Content-type: application/json")
print("\n\n")
print(json.dumps(result))

print('\n')