#!/usr/bin/python
# -*- coding: utf-8 -*-
# 必要なライブラリ
import pandas as pd
pd.set_option('display.max_columns', 99999)
pd.set_option('display.max_rows', 500)
import pandas as pd
from pandas import Series, DataFrame
import datetime
from datetime import timedelta
import worldmesh
from geojson import LineString,Point, Feature, FeatureCollection, dump

import cgi
import sqlite3
import sys
import json

import pyproj

# アーチ作成関数
import pyproj
grs80 = pyproj.Geod(ellps='GRS80')
def arch_points(df):
    # 重なると見づらいので方向別で始点終点をずらす ※ 125mメッシュ単位の移動を想定したズレになっています。1kmメッシュ単位の移動の場合もう少しズレを大きくする必要があります。
    # エリア間の移動の場合、エリア間の平均的な距離からズレを決めてもいいかもしれません。
    # 左側通行の原則
    # イメージ
    # ↗↙
    # ↖↘
    # ↑↓
    # →
    # ←
    # ズレの大きさを定義
    lat_space = 0.0010000
    lng_space = 0.0010000
    # 移動の縦横の関係性を見るために緯度経度の差を出す
    df['lat_diff'] = df['destination_area_lat'] - df['origin_area_lat']
    df['lng_diff'] = df['destination_area_lng'] - df['origin_area_lng']
    # 緯度が同じ&経度差がマイナス　→　西へ向かう　→　始点・終点を南にずらす（左側通行の原則。以下同様）
    df.loc[(df['lat_diff']==0)&(df['lng_diff']<0 ), 'origin_area_lat']      = df['origin_area_lat']      - lat_space 
    df.loc[(df['lat_diff']==0)&(df['lng_diff']<0 ), 'destination_area_lat'] = df['destination_area_lat'] - lat_space 
    # 緯度が同じ&経度差がプラス　→　東へ向かう　→　始点・終点を北にずらす
    df.loc[(df['lat_diff']==0)&(df['lng_diff']>0 ), 'origin_area_lat']      = df['origin_area_lat']      + lat_space
    df.loc[(df['lat_diff']==0)&(df['lng_diff']>0 ), 'destination_area_lat'] = df['destination_area_lat']  + lat_space
    # 緯度差がマイナス&経度が同じ　→　南へ向かう　→　始点・終点を東へずらす
    df.loc[(df['lat_diff']< 0)&(df['lng_diff']==0), 'origin_area_lng']      = df['origin_area_lng']      + lng_space
    df.loc[(df['lat_diff']< 0)&(df['lng_diff']==0), 'destination_area_lng'] = df['destination_area_lng'] + lng_space
    # 緯度差がプラス&経度が同じ　→　北へ向かう　→　始点・終点を西へずらす
    df.loc[(df['lat_diff']> 0)&(df['lng_diff']==0), 'origin_area_lng']      = df['origin_area_lng']      - lng_space
    df.loc[(df['lat_diff']> 0)&(df['lng_diff']==0), 'destination_area_lng'] = df['destination_area_lng'] - lng_space
    # 南西へ向かう　→　始点を南へ、終点を東へずらす
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']<0 ), 'origin_area_lat']      = df['origin_area_lat']      - lat_space
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']<0 ), 'destination_area_lat'] = df['destination_area_lat']
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']<0 ), 'origin_area_lng']      = df['origin_area_lng']
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']<0 ), 'destination_area_lng'] = df['destination_area_lng'] + lng_space
    # 北西へ向かう　→　始点を西へ、終点を南へずらす
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']<0 ), 'origin_area_lat']      = df['origin_area_lat']
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']<0 ), 'destination_area_lat'] = df['destination_area_lat'] - lat_space
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']<0 ), 'origin_area_lng']      = df['origin_area_lng']      - lng_space
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']<0 ), 'destination_area_lng'] = df['destination_area_lng']
    # 北東へ向かう　→　始点を北へ、終点を西へずらす
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']>0 ), 'origin_area_lat']      = df['origin_area_lat']      + lat_space
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']>0 ), 'destination_area_lat'] = df['destination_area_lat']
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']>0 ), 'origin_area_lng']      = df['origin_area_lng']
    df.loc[(df['lat_diff']>0 )&(df['lng_diff']>0 ), 'destination_area_lng'] = df['destination_area_lng'] - lng_space
    # 南東へ向かう　→　始点を東へ、終点を北へずらす
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']>0 ), 'origin_area_lat']      = df['origin_area_lat']
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']>0 ), 'destination_area_lat'] = df['destination_area_lat'] + lat_space
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']>0 ), 'origin_area_lng']      = df['origin_area_lng']      + lng_space
    df.loc[(df['lat_diff']<0 )&(df['lng_diff']>0 ), 'destination_area_lng'] = df['destination_area_lng']
    df.drop(columns=(['lat_diff', 'lng_diff']), inplace=True)
    # アーチにする
    # もともとがアニメーションにするコードだったこと等から冗長さを指摘する警告が出ます。。
    # 3次元で表現するので、高さ情報が必要になります。ここでは、ベースを0としていますが、もともと標高情報を持った3Dマップを使う場合は、ベースをその土地の標高を考慮した高さにしないといけないです。
    arch_resolution = 100
    for i in range(len(df)):
        df.loc[i, 'dist'] = grs80.inv(df.loc[i, 'origin_area_lng'], df.loc[i, 'origin_area_lat'], df.loc[i, 'destination_area_lng'], df.loc[i, 'destination_area_lat'])[2]
    for i in range(arch_resolution+1):
        df[f'origin_area_lat_{i}'] = df['origin_area_lat'] + (df['destination_area_lat'] - df['origin_area_lat'])/arch_resolution*i
        df[f'origin_area_lng_{i}'] = df['origin_area_lng'] + (df['destination_area_lng'] - df['origin_area_lng'])/arch_resolution*i
        df[f'altitude_{i}']   = round(abs((df['dist']/2)**2 - (df['dist']/2-df['dist']*i/arch_resolution)**2)**0.5, 2)
    # df.drop(columns=['latitude', 'longitude', 'next_latitude', 'next_longitude', 'dist'], inplace=True)
    # アーチ本体部分
    df['arch_points'] = ''
    for i in range(arch_resolution+1):
        df['arch_points'] = df['arch_points'] + df[f'origin_area_lng_{i}'].astype(str) + ',' + df[f'origin_area_lat_{i}'].astype(str) + ',' + df[f'altitude_{i}'].astype(str) + ','
        df.drop(columns=[f'origin_area_lat_{i}', f'origin_area_lng_{i}', f'altitude_{i}'], inplace=True)
    df['arch_points'] = df['arch_points'].str[:-1]
    df.drop(columns='dist', inplace=True)
    return df

# Webページ情報取得
data = sys.stdin.read()
params = json.loads(data)

df = pd.read_csv('testdata_2.csv', dtype = 'object')
# 属性カラムを判断し左からattr1, attr2, .. と命名 ※ 必須項目以外について、存在しない場合の処理はお任せします。
attr_columns = df.columns.drop(['origin_area', 'origin_area_lat', 'origin_area_lng', 'destination_area', 'destination_area_lat', 'destination_area_lng', 'year', 'month', 'date', 'hour', 'holiday', 'value'])
attrs = [] # attr1, attr2, ...→この後の処理に使用 
attrs_name = [] #  csv内のもとの名前→HTML内のフィルターの題名や、属性分析の属性選択リストに使用
for i, column in enumerate(attr_columns):
    df.rename(columns={column: f'attr{i+1}'}, inplace=True)
    attrs.append(f'attr{i+1}')
    attrs_name.append(column)
# 型指定（attr情報はobjectのまま）
df['origin_area_lat'] = df['origin_area_lat'].astype(float)
df['origin_area_lng'] = df['origin_area_lng'].astype(float)
df['destination_area_lat'] = df['destination_area_lat'].astype(float)
df['destination_area_lng'] = df['destination_area_lng'].astype(float)
df['year'] = df['year'].astype(int)
df['month'] = df['month'].astype(int)
df['date'] = df['date'].astype(int)
df['hour'] = df['hour'].astype(int)
df['value'] = df['value'].astype(float)
# 時間を持たせる
df['yyyymmdd'] = pd.to_datetime(df['year'].astype(str)+'-'+df['month'].astype(str)+'-'+df['date'].astype(str))
# 曜日を持たせる
df['dow'] = df['yyyymmdd'].dt.strftime("%a")

df = df[~(df['origin_area']==df['destination_area'])]
df_all = df.copy()

# フィルターを反映 ※ここでは選択された項目は例です。実装ではフィルター欄で選択された項目をリストとして入れてください。
df = df_all.copy()
'''
selected_year = [2019]
selected_month = [7]
selected_date = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]
selected_hour = [10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21]
selected_dow = ['Wed', 'Thu', 'Sat']
selected_holiday = ['平日', '休日']
selected_origin_area = ['上野公園', '蔵前']
selected_destination_area = ['秋葉原', '浅草']
selected_attr1 = ['男性', '女性']
selected_attr2 = ['30', '40', '50', '60']
selected_attr3 = ['すべて']
'''

selected_year = ['']
selected_month = ['']
selected_date = ['']
selected_hour = ['']
selected_dow = ['']
selected_holiday = ['']
selected_origin_area = ['']
selected_destination_area = ['']
selected_attr1 = ['']
selected_attr2 = ['']
selected_attr3 = ['']
selected_attr4 = ['']
selected_attr5 = ['']

if len(params['year']) != 0:
    selected_year =  [int(i) for i in params['year']]
if len(params['month']) != 0:
    selected_month =  [int(i) for i in params['month']]
if len(params['date']) != 0:
    selected_date =  [int(i) for i in params['date']]
if len(params['time']) != 0:
    selected_hour =  [int(i) for i in params['time']]
if len(params['yobi']) != 0:
    selected_dow =  params['yobi']
if len(params['holyday']) != 0:
    selected_holiday = params['holyday']
if len(params['origin_area']) != 0:
    selected_origin_area = params['origin_area']
if len(params['destination_area']) != 0:
    selected_destination_area = params['destination_area']

if len(params['attr1']) != 0:
    selected_attr1 = params['attr1']
if len(params['attr2']) != 0:
    selected_attr2 = params['attr2']
if len(params['attr3']) != 0:
    selected_attr3 = params['attr3']
if len(params['attr4']) != 0:
    selected_attr4 = params['attr4']
if len(params['attr5']) != 0:
    selected_attr5 = params['attr5']

if params['attr'] is not None :
    if len(params['attr']) != 0:
        selected_attr = params['attr']
else :
    selected_attr = ""


if selected_year != ['すべて']:
    df = df[df['year'].isin(selected_year)]
if selected_month != ['すべて']:
    df = df[df['month'].isin(selected_month)]
if selected_date != ['すべて']:
    df = df[df['date'].isin(selected_date)]
if selected_hour != ['すべて']:
    df = df[df['hour'].isin(selected_hour)]
if selected_dow != ['すべて']:
    df = df[df['dow'].isin(selected_dow)]
if selected_holiday != ['すべて']:
    df = df[df['holiday'].isin(selected_holiday)]
if selected_origin_area != ['すべて']:
    df = df[df['origin_area'].isin(selected_origin_area)]
if selected_destination_area != ['すべて']:
    df = df[df['destination_area'].isin(selected_destination_area)]
if 'selected_attr1' in locals():
    if selected_attr1 != ['すべて']:
        df = df[df['attr1'].isin(selected_attr1)]
if 'selected_attr2' in locals():
    if selected_attr2 != ['すべて']:
        df = df[df['attr2'].isin(selected_attr2)]
if 'selected_attr3' in locals():
    if selected_attr3 != ['すべて']:
        df = df[df['attr3'].isin(selected_attr3)]
if 'selected_attr4' in locals():
    if selected_attr4 != ['すべて']:
        df = df[df['attr4'].isin(selected_attr4)]
if 'selected_attr5' in locals():
    if selected_attr5 != ['すべて']:
        df = df[df['attr5'].isin(selected_attr5)]

df_selected = df.copy().reset_index(drop=True)
if len(df_selected) == 0:
    result = {}
    print("Content-type: application/json")
    print("\n\n")
    print(json.dumps(result))

    print('\n')
    exit()

# フィルター後の日数を持っておく
nod = df_selected['yyyymmdd'].nunique()
nod_week = df_selected[df_selected['holiday']=='平日']['yyyymmdd'].nunique()
nod_holi = df_selected[df_selected['holiday']=='休日']['yyyymmdd'].nunique()
# 冗長になるのでorigin情報とdestination情報をまとめたリストを持っておく
origin = ['origin_area', 'origin_area_lat', 'origin_area_lng']
destination = ['destination_area', 'destination_area_lat', 'destination_area_lng']

####### P1,2共通の画面左側 #######

### マップ用エリア間平均移動量 df_a
df = df_selected.copy()
df = df.groupby(origin + destination, as_index=False)['value'].sum()
df['cnt'] = df['value'] / nod
df.drop(columns=['value'], inplace=True)
df_a = arch_points(df)
### 年月日別合計移動量 df_b
df = df_selected.copy()
df_b = df.groupby(['yyyymmdd'], as_index=False)['value'].sum().rename(columns={'value': 'cnt'})
### 時間帯別平均移動量 df_c
df = df_selected.copy()
df = df.groupby(['hour'], as_index=False)['value'].sum()
df['cnt'] = df['value'] / nod
df_c = df[['hour', 'cnt']]

####### P3右側 曜日別分析 #######

# 年月日別合計移動量 df_d
df = df_selected.copy()
df = df.groupby(['yyyymmdd', 'holiday'], as_index=False)['value'].sum()
df.loc[df['holiday']=='平日', 'cnt'] = df['value']
df.loc[df['holiday']=='休日', 'cnt'] = df['value']
df_d = df[['yyyymmdd', 'holiday', 'cnt']]
# 曜日別平均移動量 df_e
df = df_d.copy()
df_e = df.groupby(['holiday'], as_index=False)['cnt'].mean()
# 時間帯別平均移動量 df_f
df = df_selected.copy()
df = df.groupby(['holiday', 'hour'], as_index=False)['value'].sum()
df.loc[df['holiday']=='平日', 'cnt'] = df['value'] / nod_week
df.loc[df['holiday']=='休日', 'cnt'] = df['value'] / nod_holi
df_f = df[['holiday', 'hour', 'cnt']]

####### P3右側 属性別分析 #######
# ※ 「集計対象」で選択された属性が「attr1」の場合の例です。
for i, column in enumerate(attr_columns):
    df_selected.rename(columns={f'attr{i+1}' : column }, inplace=True)

if selected_attr != "" :
    # 年月日別合計移動量 df_g
    df = df_selected.copy()
    df_g = df.groupby(['yyyymmdd', selected_attr], as_index=False)['value'].sum().rename(columns={'value': 'cnt'})
    # 属性別平均移動量 df_h
    df = df_g.copy()
    df_h = df.groupby([selected_attr], as_index=False)['cnt'].mean()
    # 時間帯別平均移動量 df_i
    df = df_selected.copy()
    df = df.groupby([selected_attr, 'hour'], as_index=False)['value'].sum()
    df['cnt'] = df['value'] / nod
    df_i = df[[selected_attr, 'hour', 'cnt']]

####### P2右側 OD表 #######
# OD表（人/日） df_j
df = df_selected.copy()
df = df.groupby(origin + destination, as_index=False)['value'].sum()
df['cnt'] = df['value'] / nod
df_j = df[origin + destination + ['cnt']]




geojson_data = df_a.to_dict(orient='records')

# Prepare Geojson FeatureCollection
ft_all = []
ft_all_2 = []
ft_all_3 = []
'''
for i, p in enumerate(geojson_data):
    arch_list = p['arch_points'].split(',')
    j = 0
    for j in range(len(arch_list)):
        if j % 3 == 0:
            lon, lat, z = float(arch_list[j]), float(arch_list[j+1]),float(arch_list[j+2])
            ft = Feature(geometry = Point((lon, lat, z,)),
                 properties = {'cnt': p['cnt']})
            ft_all.append(ft)
        else :
            continue
ft_colct = FeatureCollection(ft_all)
'''
origin_area_list = []
destination_area_list = []

for i, p in enumerate(geojson_data):
    if p['origin_area'] == p['destination_area'] :
        continue
    arch_list = p['arch_points'].split(',')
    j = 0
    pointList = []
    for j in range(len(arch_list)):
        if j % 3 == 0:
            lon, lat, z = float(arch_list[j]), float(arch_list[j+1]),float(arch_list[j+2])
            pointList.append((lon, lat, z))

        else :
            continue
    #arrow_list.append( [pointList[48][0] , pointList[45][1], pointList[45][2] - 25] )
    arrow_list = []
    arrow_list.append( [pointList[48][0] , pointList[48][1], pointList[48][2] + (pointList[48][2]*0.05)] )
    arrow_list.append( pointList[51])
    #arrow_list.append( [pointList[48][0] , pointList[45][1], pointList[45][2] - 50] )

    ft = Feature(geometry = LineString(arrow_list),
                 properties = {'cnt': p['cnt']})
    ft_all.append(ft)

    arrow_list = []
    arrow_list.append( pointList[51])
    arrow_list.append( [pointList[48][0] , pointList[48][1], pointList[48][2] - (pointList[48][2]*0.05)] )

    ft = Feature(geometry = LineString(arrow_list),
                 properties = {'cnt': p['cnt']})
    ft_all.append(ft)

    ft = Feature(geometry = LineString(pointList),
                 properties = {'cnt': p['cnt']})
    ft_all.append(ft)



ft_colct = FeatureCollection(ft_all)

df_json = df_selected.copy()
df_json_list = [*df.groupby(origin).groups]

for origin_area_i in df_json_list :
    ft_2 = Feature(geometry = Point((float(origin_area_i[2]), float(origin_area_i[1]), )),
                 properties = {'name': origin_area_i[0]})
    ft_all_2.append(ft_2)

ft_colct_2 = FeatureCollection(ft_all_2)

with open('outfile2.geojson', 'w') as f:
    dump(ft_colct, f, indent=2)
with open('outfile2_area.geojson', 'w') as f:
    dump(ft_colct_2, f, indent=2)

df_json_list = [*df_all.groupby(origin).groups]
i = 0
area_id_list = []
for origin_area_i in df_json_list :
    i = i + 1
    ft_3 = Feature(geometry = Point((float(origin_area_i[2]), float(origin_area_i[1]), )),
                 properties = {'name': origin_area_i[0]},id = i)
    area_id = [i,origin_area_i[0]]
    area_id_list.append(area_id)
    ft_all_3.append(ft_3)

ft_colct_3 = FeatureCollection(ft_all_3)

with open('outfile2_point.geojson', 'w') as f:
    dump(ft_colct_3, f, indent=2)






if selected_attr != "" :
    df_g.rename(columns={selected_attr : 'attr1'}, inplace=True)
    df_h.rename(columns={selected_attr : 'attr1'}, inplace=True)
    df_i.rename(columns={selected_attr : 'attr1'}, inplace=True)

df_d_m = df_d.pivot_table(values=['cnt'], index=['yyyymmdd'], columns=['holiday'], aggfunc='sum',fill_value=0)
df_d_m.columns = [cols[1] for cols in df_d_m.columns]
df_d_m = df_d_m.reset_index()
if not '平日' in df_d_m.columns:
    df_d_m['平日'] = 0
if not '休日' in df_d_m.columns:
    df_d_m['休日'] = 0

if selected_attr != "" :
    df_g_m = df_g.pivot_table(values=['cnt'], index=['yyyymmdd'], columns=['attr1'], aggfunc='sum',fill_value=0,margins=True)
    df_g_m = df_g_m.iloc[:-1]
    df_g_m.columns = [cols[1] for cols in df_g_m.columns]
    df_g_m = df_g_m.reset_index()


df_j_m = df_j.pivot_table(values=['cnt'], index=['origin_area'], columns=['destination_area'], aggfunc='sum',fill_value=0)
df_j_m.columns = [cols[1] for cols in df_j_m.columns]
df_j_m = df_j_m.reset_index()

df_j_m_2 = df_j_m.to_dict(orient='records')

html_cross1 = '<table  class="od-table"><tbody><tr><th class="od_title">O/D</th>'
for n in df_j_m.columns:
    if str(n) == 'origin_area':
        continue
    html_cross1 += '<th class="destination">' + str(n) + '</th>'
html_cross1 += '</tr>'

for df_list in df_j_m_2:
    html_cross1 += '<tr>'
    origin_area_name = ''
    for n in df_j_m.columns: 
        value = df_list[n]
        if str(n) == 'origin_area':
            html_cross1 += '<td>' + value + '</td>'
            origin_area_name = value
        elif str(n) == origin_area_name :
            html_cross1 += '<td>-</td>'
        else:    
            html_cross1 += '<td>' + "{:,.3f}".format(float(value)) + '</td>'
    html_cross1 += '</tr>'

html_cross1 += '</tbody></table>'







result = {}
df_b['yyyymmdd'] = df_b['yyyymmdd'].astype(str)
df_d_m['yyyymmdd'] = df_d_m['yyyymmdd'].astype(str)
if selected_attr != "" :
    df_g_m['yyyymmdd'] = df_g_m['yyyymmdd'].astype(str)
result['df_a'] = df_a.drop(columns='arch_points').to_dict(orient='records')
result['df_b'] = df_b.to_dict(orient='records')
result['df_c'] = df_c.to_dict(orient='records')
result['df_d'] = df_d_m.to_dict(orient='records')
result['df_e'] = df_e.to_dict(orient='records')
result['df_f'] = df_f.to_dict(orient='records')
if selected_attr != "" :
    result['df_g'] = df_g_m.to_dict(orient='records')
    result['df_h'] = df_h.sort_values('cnt', ascending=False).to_dict(orient='records')
    result['df_i'] = df_i.to_dict(orient='records')
else :
    result['df_g'] = []
    result['df_h'] = []
    result['df_i'] = []

result['df_j'] = df_j.to_dict(orient='records')
result['cross'] = html_cross1
result['pm'] = params
df_selected['yyyymmdd'] = df_selected['yyyymmdd'].astype(str)
result['df_selected'] = df_selected.to_dict(orient='records')
result['ft_all'] = ft_all
result['area_id_list'] = area_id_list
print("Content-type: application/json")
print("\n\n")
print(json.dumps(result))

print('\n')