# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ExemploPluginPEC
                                 A QGIS plugin
 Realiza a avaliação da acurácia posicional em produtos cartográficos
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-25
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Isaac Antunes Miranda Junior; Afonso de Paula dos Santos
        email                : isaac.junior@ufv.br; afonso.santos@ufv.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QModelIndex, QVariant
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import *
from pec_avalia.biblioteca.normas import *
from qgis.gui import QgsMessageBar
import processing
import statistics as st

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .pec_avalia_dialog import ExemploPluginPECDialog
import os.path
import processing
import sys, os
from osgeo import ogr

class ExemploPluginPEC:
    """QGIS Plugin Implementation."""
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ExemploPluginPEC_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&PEC_Avalia')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ExemploPluginPEC', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(':/plugins/pec_avalia/pec_avalia.png')
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = ':/plugins/pec_avalia/pec_avalia.png'
        self.add_action(
            icon_path,
            text=self.tr(u'PEC_Avalia'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&PEC_Avalia'),
                action)
            self.iface.removeToolBarIcon(action)

    def carregaVetor(self):
        """Preenche o combox com as layers vetoriais existentes no projeto"""
        self.dlg.comboBox.clear()
        self.dlg.comboBox_2.clear()
        lista_layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        lista_layer_vetor = []
        for layer in lista_layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                lista_layer_vetor.append(layer.name())
        self.dlg.comboBox.addItems(lista_layer_vetor)
        self.dlg.comboBox_2.addItems(lista_layer_vetor)

    def definirSaida(self):
        """Abre a janela de dialógo para definir o nome e o local da layer a ser gerada"""
        camada_salvar = str(QFileDialog.getSaveFileName(caption = "Defina o local de saída...",
                                                        filter = "Arquivo de texto (*.txt)")[0])
        self.dlg.lineEdit.setText(camada_salvar)
        self.local_saida = camada_salvar
    def abrirVetor(self):
        """Abre a janela de dialógo para abrir uma layer a ser escolhida"""
        camada_abrir = str(QFileDialog.getOpenFileName(caption = "Escolha a camada...",
                                                        filter = "Shapefiles (*.shp)")[0])
        #Se camada_abrir não for vazio
        if (camada_abrir != ""):
            self.iface.addVectorLayer(camada_abrir, str.split(os.path.basename(camada_abrir),".") [0], "ogr")
            self.carregaVetor()  
  
    def SeleNorma(self):
        #Preenche o combox com a escala a ser analisada
        self.dlg.comboBox_3.clear()
        self.dlg.comboBox_3.addItems(["Decreto 89.817/ET-CQDG","NBR 13.133 (Versão 1994)","INCRA"])


    def SeleEscala(self):
        #Preenche o combox com a escala a ser analisada
        self.dlg.comboBox_4.clear()
        self.dlg.comboBox_4.addItems(["100","250","500","1000","2000","5000","10000","25000",
                                        "50000","100000","250000","500000","1000000"])
        self.dlg.comboBox_4.setCurrentIndex(6)
        
    def SeleEscVert(self):
        #Preenche o combox com a escala a ser analisada
        self.dlg.comboBox_7.clear()
        self.dlg.comboBox_7.addItems(["0.1","0.2","0.25","0.5","1",
                                        "2","2.5","5","10","20","50","100"])
        self.dlg.comboBox_7.setCurrentIndex(4)
                                        
    def SeleK(self):
        #Preenche o combox com a escala a ser analisada
        self.dlg.comboBox_8.clear()
        self.dlg.comboBox_8.addItems(["1","1.5","2.5"])

    def SeleTipoLimite(self):
        #Preenche o combox com a escala a ser analisada
        self.dlg.comboBox_9.clear()
        self.dlg.comboBox_9.addItems(["Artificial","Natural","Inacessivel"])
        
    def AnalisaNorma(self,norma):
        if norma == "INCRA":
            self.dlg.comboBox_4.setEnabled(False)
            self.dlg.checkBox.setEnabled(False)
            self.dlg.checkBox_2.setEnabled(False)
            self.dlg.comboBox_8.setEnabled(False)
            self.dlg.comboBox_7.setEnabled(False)
            self.dlg.comboBox_9.setEnabled(True)
        else:
            self.SeleEscala()
            #self.dlg.comboBox_4.setEnabled(True)
            self.dlg.checkBox.setEnabled(True)
            self.dlg.checkBox_2.setEnabled(True)
            self.dlg.comboBox_8.setEnabled(True)
            self.dlg.comboBox_7.setEnabled(True)
            
        if norma == "NBR 13.133 (Versão 1994)":
            self.dlg.comboBox_9.setEnabled(False)
            if self.dlg.checkBox.isChecked():
                self.dlg.checkBox_2.setEnabled(False)
                self.dlg.comboBox_4.setEnabled(True)
                self.dlg.comboBox_7.setEnabled(False)
            elif self.dlg.checkBox_2.isChecked():
                self.dlg.checkBox.setEnabled(False)
                self.dlg.comboBox_4.setEnabled(False)
                self.dlg.comboBox_7.setEnabled(True) 
            else:
                self.dlg.checkBox.setEnabled(True)
                self.dlg.checkBox_2.setEnabled(True)
                self.dlg.comboBox_4.setEnabled(True)
                self.dlg.comboBox_7.setEnabled(True)
 
        if norma == "Decreto 89.817/ET-CQDG":
            self.dlg.comboBox_9.setEnabled(False)
            self.dlg.comboBox_8.setEnabled(False)
            if self.dlg.checkBox_2.isChecked():
                if self.dlg.checkBox.isChecked():
                    self.dlg.comboBox_4.setEnabled(True)
                    self.dlg.comboBox_7.setEnabled(True)
                else:
                    self.dlg.comboBox_4.setEnabled(False)
                    self.dlg.comboBox_7.setEnabled(True)                
            elif self.dlg.checkBox.isChecked():
                if self.dlg.checkBox_2.isChecked():
                    self.dlg.comboBox_4.setEnabled(True)
                    self.dlg.comboBox_7.setEnabled(True)
                else:
                    self.dlg.comboBox_4.setEnabled(True)
                    self.dlg.comboBox_7.setEnabled(False)
            else:
                self.dlg.comboBox_4.setEnabled(False)
                self.dlg.comboBox_7.setEnabled(False) 

    def obterTest(self):
        """Gets vector layer specified in combo box"""
        layer = None
        layername = self.dlg.comboBox.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
                break
        return layer
       
    def obterRef(self):
        """Gets vector layer specified in combo box"""
        layer = None
        layername = self.dlg.comboBox_2.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
                break
        return layer
        
    def leitura_decreto(self):
        # criando variaveis com os parametros do algoritmos
        #=======================================================================
        self.test = self.obterTest()
        self.ref = self.obterRef()
        
        # criar campos de geometrias x, y e z para as camadas de entrada
        #=======================================================================
        dpt = self.test.dataProvider()
        testa_campo = self.test.fields().indexFromName("IDt")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("IDt", QVariant.Int)])
        testa_campo = self.test.fields().indexFromName("Xxtest")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("Xxtest", QVariant.Double)])
        testa_campo = self.test.fields().indexFromName("Yytest")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("Yytest", QVariant.Double)])
        testa_campo = self.test.fields().indexFromName("Zztest")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("Zztest", QVariant.Double)])    
        self.test.updateFields()
        
        dpr = self.ref.dataProvider()
        testa_campo = self.ref.fields().indexFromName("IDr")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("IDr", QVariant.Int)])
        testa_campo = self.ref.fields().indexFromName("Xxref")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("Xxref", QVariant.Double)])
        testa_campo = self.ref.fields().indexFromName("Yyref")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("Yyref", QVariant.Double)])
        testa_campo = self.ref.fields().indexFromName("Zzref")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("Zzref", QVariant.Double)])
        self.ref.updateFields()
        
        # calculando os campos X Y Z
        #=======================================================================
        numb = 1
        for ft in self.test.getFeatures():
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["IDt"] : numb}})
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Xxtest"] : ft.geometry().asPoint().x()}})
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Yytest"] : ft.geometry().asPoint().y()}})
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Zztest"] : ft.geometry().vertexAt(0).z()}})
             #dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Zztest"] : 100}})
             numb = numb + 1
        self.test.commitChanges()
        
        nn = 1
        for fr in self.ref.getFeatures():
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["IDr"] : nn}})
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Xxref"] : fr.geometry().asPoint().x()}})
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Yyref"] : fr.geometry().asPoint().y()}})
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Zzref"] : fr.geometry().vertexAt(0).z()}})
             #dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Zzref"] : 200}})
             nn = nn + 1
        self.ref.commitChanges()
        
        # realizando a junção espacial dos pontos
        #=======================================================================
        algresult  = processing.run("qgis:joinbynearest", {
                'DISCARD_NONMATCHING' : True, 
                'FIELDS_TO_COPY' : [], 
                'INPUT' : self.test, 
                'INPUT_2' : self.ref, 
                'MAX_DISTANCE' : None, 
                'NEIGHBORS' : 1, 
                'OUTPUT' : 'memory:JOIN', 
                'PREFIX' : '' })
        self.join = algresult['OUTPUT']
        idd, xt, yt, zt, xr, yr, zr = [], [], [], [], [], [], []
        for f in self.join.getFeatures():
            geom = f.geometry()
            idd.append(f["IDr"])
            xt.append(f["Xxtest"])
            yt.append(f["Yytest"])
            zt.append(f["Zztest"])
            xr.append(f["Xxref"])
            yr.append(f["Yyref"])
            zr.append(f["Zzref"])

        QgsProject.instance().addMapLayer(self.join)
        return (self.join, idd, xt, yt, zt, xr, yr, zr)

    def leitura_incra(self):
        # criando variaveis com os parametros do algoritmos
        #=======================================================================
        self.test = self.obterTest()
        self.ref = self.obterRef()
        
        # criar campos de geometrias x, y e z para as camadas de entrada
        #=======================================================================
        dpt = self.test.dataProvider()
        testa_campo = self.test.fields().indexFromName("IDt")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("IDt", QVariant.Int)])
        testa_campo = self.test.fields().indexFromName("Xxtest")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("Xxtest", QVariant.Double)])
        testa_campo = self.test.fields().indexFromName("Yytest")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("Yytest", QVariant.Double)])
        testa_campo = self.test.fields().indexFromName("Zztest")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("Zztest", QVariant.Double)])    
        self.test.updateFields()
        
        dpr = self.ref.dataProvider()
        testa_campo = self.ref.fields().indexFromName("IDr")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("IDr", QVariant.Int)])
        testa_campo = self.ref.fields().indexFromName("Xxref")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("Xxref", QVariant.Double)])
        testa_campo = self.ref.fields().indexFromName("Yyref")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("Yyref", QVariant.Double)])
        testa_campo = self.ref.fields().indexFromName("Zzref")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("Zzref", QVariant.Double)])
        self.ref.updateFields()
        
        # calculando os campos X Y Z
        #=======================================================================
        numb = 1
        for ft in self.test.getFeatures():
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["IDt"] : numb}})
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Xxtest"] : ft.geometry().asPoint().x()}})
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Yytest"] : ft.geometry().asPoint().y()}})
             dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Zztest"] : 100}})
             numb = numb + 1
        self.test.commitChanges()
        
        nn = 1
        for fr in self.ref.getFeatures():
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["IDr"] : nn}})
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Xxref"] : fr.geometry().asPoint().x()}})
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Yyref"] : fr.geometry().asPoint().y()}})
             dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Zzref"] : 200}})
             nn = nn + 1
        self.ref.commitChanges()
        
        # realizando a junção espacial dos pontos
        #=======================================================================
        algresult  = processing.run("qgis:joinbynearest", {
                'DISCARD_NONMATCHING' : True, 
                'FIELDS_TO_COPY' : [], 
                'INPUT' : self.test, 
                'INPUT_2' : self.ref, 
                'MAX_DISTANCE' : None, 
                'NEIGHBORS' : 1, 
                'OUTPUT' : 'memory:JOIN', 
                'PREFIX' : '' })
        self.join = algresult['OUTPUT']
        idd, xt, yt, zt, xr, yr, zr = [], [], [], [], [], [], []
        for f in self.join.getFeatures():
            geom = f.geometry()
            idd.append(f["IDr"])
            xt.append(f["Xxtest"])
            yt.append(f["Yytest"])
            zt.append(f["Zztest"])
            xr.append(f["Xxref"])
            yr.append(f["Yyref"])
            zr.append(f["Zzref"])

        QgsProject.instance().addMapLayer(self.join)
        return (self.join, idd, xt, yt, zt, xr, yr, zr)

    def leitura_nbr(self, processamento):
        # criando variaveis com os parametros do algoritmos
        #=======================================================================
        self.test = self.obterTest()
        self.ref = self.obterRef()
        
        # criar campos de geometrias x, y e z para as camadas de entrada
        #=======================================================================
        dpt = self.test.dataProvider()
        testa_campo = self.test.fields().indexFromName("IDt")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("IDt", QVariant.Int)])
        testa_campo = self.test.fields().indexFromName("Dist_Map")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("Dist_Map", QVariant.Double)])
        testa_campo = self.test.fields().indexFromName("H_Map")
        if testa_campo == -1:
            dpt.addAttributes([QgsField("H_Map", QVariant.Double)])    
        self.test.updateFields()
        
        dpr = self.ref.dataProvider()
        testa_campo = self.ref.fields().indexFromName("IDr")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("IDr", QVariant.Int)])
        testa_campo = self.ref.fields().indexFromName("Dist_Terr")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("Dist_Terr", QVariant.Double)])
        testa_campo = self.ref.fields().indexFromName("H_Terr")
        if testa_campo == -1:
            dpr.addAttributes([QgsField("H_Terr", QVariant.Double)])
        self.ref.updateFields()
        
        # calculando os campos Dist e H
        #=======================================================================
        if processamento == 'plan':
            numb = 1
            for ft in self.test.getFeatures():
                 dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["IDt"] : numb}})
                 dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Dist_Map"] : ft.geometry().length()}})
                 dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["H_Map"] : 0 }})
                 numb = numb + 1
            self.test.commitChanges()
            
            nn = 1
            for fr in self.ref.getFeatures():
                 dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["IDr"] : nn}})
                 dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Dist_Terr"] : fr.geometry().length()}})
                 dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["H_Terr"] : 0}})
                 nn = nn + 1
            self.ref.commitChanges()
        
        else:
            numb = 1
            for ft in self.test.getFeatures():
                 dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["IDt"] : numb}})
                 dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["Dist_Map"] : 0}})
                 dpt.changeAttributeValues({ft.id() : {dpt.fieldNameMap()["H_Map"] : ft.geometry().vertexAt(0).z()}})
                 numb = numb + 1
            self.test.commitChanges()
            
            nn = 1
            for fr in self.ref.getFeatures():
                 dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["IDr"] : nn}})
                 dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["Dist_Terr"] : 0}})
                 dpr.changeAttributeValues({fr.id() : {dpr.fieldNameMap()["H_Terr"] : fr.geometry().vertexAt(0).z()}})
                 nn = nn + 1
            self.ref.commitChanges()
   
        # realizando a junção espacial dos pontos
        #=======================================================================
        algresult  = processing.run("qgis:joinbynearest", {
                'DISCARD_NONMATCHING' : True, 
                'FIELDS_TO_COPY' : [], 
                'INPUT' : self.test, 
                'INPUT_2' : self.ref, 
                'MAX_DISTANCE' : None, 
                'NEIGHBORS' : 1, 
                'OUTPUT' : 'memory:JOIN', 
                'PREFIX' : '' })
        self.join = algresult['OUTPUT']
        idd, Dist_Map, Dist_Terr, H_Map, H_Terr = [], [], [], [], []
        for f in self.join.getFeatures():
            geom = f.geometry()
            idd.append(f["IDr"])
            Dist_Map.append(f["Dist_Map"])
            Dist_Terr.append(f["Dist_Terr"])
            H_Map.append(f["H_Map"])
            H_Terr.append(f["H_Terr"])

        QgsProject.instance().addMapLayer(self.join)
        return (self.join, idd, Dist_Map, Dist_Terr, H_Map, H_Terr)

    def variaveis(self):
        """define as variaveis utiizadas na função run"""
        self.esc_plan = self.dlg.comboBox_4.currentText()
        self.esc_alt = self.dlg.comboBox_7.currentText()
        self.k = self.dlg.comboBox_8.currentText()
        tipo_limite = self.dlg.comboBox_9.currentText()
        #self.local_saida = self.dlg.lineEdit.text()
        norma = self.dlg.comboBox_3.currentText()
        
        if self.dlg.checkBox.isChecked() and self.dlg.checkBox_2.isChecked():
            processamento = 'planealt'
        elif self.dlg.checkBox.isChecked() :
            processamento ='plan'
        else:
            processamento = 'alt'
            
        esc_plan = float(self.esc_plan)
        esc_alt = float(self.esc_alt)
        k = float(self.k)
        
        return(esc_plan,esc_alt,k,tipo_limite,norma,processamento)
        
    def analisa_processamento(self):
        if self.dlg.comboBox_3.currentText() == "NBR 13.133 (Versão 1994)":
            if self.dlg.checkBox.isChecked():
                self.dlg.checkBox_2.setEnabled(False)
                self.dlg.comboBox_4.setEnabled(True)
                self.dlg.comboBox_7.setEnabled(False)
            elif self.dlg.checkBox_2.isChecked():
                self.dlg.checkBox.setEnabled(False)
                self.dlg.comboBox_4.setEnabled(False)
                self.dlg.comboBox_7.setEnabled(True) 
            else:
                self.dlg.checkBox.setEnabled(True)
                self.dlg.checkBox_2.setEnabled(True)
                self.dlg.comboBox_4.setEnabled(True)
                self.dlg.comboBox_7.setEnabled(True)
                
        if self.dlg.comboBox_3.currentText() == "Decreto 89.817/ET-CQDG":        
            if self.dlg.checkBox_2.isChecked():
                if self.dlg.checkBox.isChecked():
                    self.dlg.comboBox_4.setEnabled(True)
                    self.dlg.comboBox_7.setEnabled(True)
                else:
                    self.dlg.comboBox_4.setEnabled(False)
                    self.dlg.comboBox_7.setEnabled(True)                
            elif self.dlg.checkBox.isChecked():
                if self.dlg.checkBox_2.isChecked():
                    self.dlg.comboBox_4.setEnabled(True)
                    self.dlg.comboBox_7.setEnabled(True)
                else:
                    self.dlg.comboBox_4.setEnabled(True)
                    self.dlg.comboBox_7.setEnabled(False)
            else:
                self.dlg.comboBox_4.setEnabled(False)
                self.dlg.comboBox_7.setEnabled(False)
        
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = True
            self.dlg = ExemploPluginPECDialog()

        # show the dialog
        self.dlg.show()
        #adicionando as funções criadas
        self.local_saida = " "
        self.carregaVetor()
        self.dlg.toolButton.clicked.connect(self.abrirVetor)
        self.dlg.toolButton_2.clicked.connect(self.abrirVetor)
        self.SeleNorma()
        self.SeleEscVert()
        self.SeleK()
        self.SeleTipoLimite()
        self.dlg.comboBox_3.currentTextChanged.connect(self.AnalisaNorma)
        self.AnalisaNorma(self.dlg.comboBox_3.currentText())
        self.dlg.toolButton_3.clicked.connect(self.definirSaida)
        self.dlg.checkBox.clicked.connect(self.analisa_processamento)
        self.dlg.checkBox_2.clicked.connect(self.analisa_processamento)

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            i_teste = 0
            esc_plan,esc_alt,k,tipo_limite,norma,processamento = self.variaveis()
            if self.local_saida == " ":
                self.iface.messageBar().pushMessage("Insira um local para salvar o relatório")
                i_teste = 1
            else:
                output_file = open(self.local_saida, "wt")
                
            if norma == "NBR 13.133 (Versão 1994)" and  i_teste != 1: 
                if processamento == 'plan':
                    if self.obterTest().geometryType() == QgsWkbTypes.PointGeometry or self.obterRef().geometryType() == QgsWkbTypes.PointGeometry:
                        self.iface.messageBar().pushMessage("Insira apenas camadas tipo linha para os cálculos da NBR 13.133 planimétrico")
                        i_teste = 1
                    else:
                        saida, idd, d_planta, d_terr, h_planta, h_terr = self.leitura_nbr(processamento)
                        self.iface.messageBar().pushMessage("Concluido")
                elif processamento == 'alt':
                    if self.obterTest().geometryType() == QgsWkbTypes.LineGeometry or self.obterRef().geometryType() == QgsWkbTypes.LineGeometry:
                        self.iface.messageBar().pushMessage("Insira apenas camadas tipo ponto para os cálculos da NBR 13.133 altimétrico")
                        i_teste = 1
                    else:
                        saida, idd, d_planta, d_terr, h_planta, h_terr = self.leitura_nbr(processamento)
                        self.iface.messageBar().pushMessage("Concluido")
            elif norma == "Decreto 89.817/ET-CQDG" and  i_teste != 1:
                if self.obterTest().geometryType() == QgsWkbTypes.PointGeometry and self.obterRef().geometryType() == QgsWkbTypes.PointGeometry:
                    saida, idd, xt, yt, zt, xr, yr, zr = self.leitura_decreto()
                    self.iface.messageBar().pushMessage("Concluido")
                else:
                    self.iface.messageBar().pushMessage("Insira apenas camadas tipo ponto para os cálculos do Decreto 89.817/ET-CQDG")
                    i_teste = 1
            elif norma == "INCRA" and  i_teste != 1:
                if self.obterTest().geometryType() == QgsWkbTypes.PointGeometry and self.obterRef().geometryType() == QgsWkbTypes.PointGeometry:
                    saida, idd, xt, yt, zt, xr, yr, zr = self.leitura_incra()
                    if len(idd) >= 20:
                        self.iface.messageBar().pushMessage("Concluido")
                        pass
                    else:
                        i_teste = 1
                        self.iface.messageBar().pushMessage("Amostra menor que 20 pontos")
                else:
                    self.iface.messageBar().pushMessage("Insira apenas camadas tipo ponto para os cálculos do INCRA")
                    i_teste = 1

            if norma == "Decreto 89.817/ET-CQDG" and i_teste != 1:
                #Calculo dos Parametros           
                EM_A_pla,EM_A_alt,EM_B_pla,EM_B_alt,EM_C_pla,EM_C_alt,EM_D_pla,EM_D_alt, EP_A_pla,EP_A_alt,EP_B_pla,EP_B_alt,EP_C_pla,EP_C_alt,EP_D_pla,EP_D_alt = param_classes(esc_plan,esc_alt)
                #Calculos das Discrepancias
                disc_x, disc_y, disc_z = discrepancia1(idd, xt, xr, yt, yr, zt, zr)  #Calculo das Discrepancias
                if processamento == 'plan' or processamento == 'planealt':
                    eHi = discrepancia2D(idd, disc_x, disc_y) #Calculo das Discrepancias Resultantes 2D
                else:
                    eHi = disc_z
                porce_A_plan, porce_A_alt, porce_B_plan, porce_B_alt, porce_C_plan, porce_C_alt,porce_D_plan, porce_D_alt = perc_pec_CQDG(idd, processamento, eHi, disc_z, EM_A_pla, EM_A_alt, EM_B_pla, EM_B_alt, EM_C_pla, EM_C_alt, EM_D_pla, EM_D_alt)
                rms_x, rms_y, rms_z, rms_d2d = calc_rms(idd, processamento, disc_x, disc_y, disc_z)
                saida_plan, saida_alt = analise_classe(processamento,rms_d2d,esc_plan, porce_A_plan, porce_A_alt, porce_B_plan, porce_B_alt,porce_C_plan, porce_C_alt, porce_D_plan, porce_D_alt, EP_A_pla, EP_B_pla, EP_C_pla, EP_D_pla,rms_z, EP_A_alt, EP_B_alt, EP_C_alt, EP_D_alt, esc_alt)
                
            elif norma == "NBR 13.133 (Versão 1994)" and i_teste != 1:
                #Calculo do desvio padrão admissivel para comparação
                ma, desv_alt = desv_pad_ad(esc_plan, k, esc_alt)
                #Calculo o padrão de exatidão
                pep, pea = pad_exa(ma, desv_alt)
                #Calculo das discrepancias
                disc_x, disc_y = discrepancia_nbr(idd, processamento, d_planta, d_terr, h_planta, h_terr )
                #Análise da porcentagem do PEC
                porce_alt, porce_plan = perc_pec_nbr(idd, processamento, disc_x, disc_y, pep, pea )
                #Calculo do desvio padrao das amostras
                desv_pad_alt, desv_pad_plan = desv_pad_amostras(idd,processamento, disc_x, disc_y)
                #RMS
                rms_x, rms_y = calc_rms_nbr(idd, processamento, disc_x, disc_y)
                #Analise NBR
                saida_plan,saida_alt = analise_nbr(processamento, desv_pad_plan,porce_plan, ma, porce_alt, desv_pad_alt)
            
            elif norma == "INCRA" and i_teste != 1:
                if len(idd) >= 20:
                    #Calculos das Discrepancias
                    disc_x, disc_y, disc_z = discrepancia1(idd, xt, xr, yt, yr, zt, zr)
                    #Calculo das Discrepacias resultantes
                    eHi = discrepancia2D(idd, disc_x, disc_y)
                    #Teste Shapiro-Wilk
                    shapiro_p_valor_E,shapiro_p_valor_N, result_shapiro,dados_shapiro = shapiro(eHi, disc_x, disc_y)
                    #Teste t Student
                    t_student_p_E,t_student_p_N,result_tstudent,dados_tstudent = t_student(xt, xr, yt, yr)
                    #Avaliar se 100% das discrepâncias posicionais são <= a precisão posicional
                    saida_incra, cont_artificial, cont_natural, cont_inacessivel = avalia_INCRA(idd, eHi, tipo_limite,t_student_p_E,t_student_p_N,shapiro_p_valor_E,shapiro_p_valor_N)
                       
            #RELATÓRIO
            if i_teste != 1:
                output_file.write(' '*25 + 'PROCESSAMENTO ACURÁCIA POSICIONAL - PEC AVALIA' + ' '*25)
                output_file.write('\n' + '-'*100 + '\n\n')
                output_file.write('Norma utilizada: {}' .format(norma) +'\n')
                
            if norma == "Decreto 89.817/ET-CQDG" and i_teste != 1:
                if processamento == 'plan':
                    output_file.write('Processamento: Planimétrico\n')
                    output_file.write('Escala planimétrica: 1/{}' .format(esc_plan) +'\n')
                elif processamento == 'alt':
                    output_file.write('Processamento: Altimétrico\n')
                    output_file.write('Equidistância das curvas verticais: {}m' .format(esc_alt) +'\n')
                else:
                    output_file.write('Processamento: Planimétrico e Altimétrico\n')
                    output_file.write('Escala planimétrica: 1/{}' .format(esc_plan) +'\n')
                    output_file.write('Equidistância das curvas verticais: {}m' .format(esc_alt) +'\n')                  
            elif norma == "NBR 13.133 (Versão 1994)" and i_teste != 1:
                if processamento == 'plan':
                    output_file.write('Processamento: Planimétrico\n')
                    output_file.write('Escala planimétrica: 1/{}' .format(esc_plan) +'\n')
                elif processamento == 'alt':
                    output_file.write('Processamento: Altimétrico\n')
                    output_file.write('Equidistância das curvas verticais: {}m' .format(esc_alt) +'\n')
                else:
                    output_file.write('Processamento: Planimétrico e Altimétrico\n')
                    output_file.write('Escala planimétrica: 1/{}' .format(esc_plan) +'\n')
                    output_file.write('Equidistância das curvas verticais: {}m' .format(esc_alt) +'\n')
                output_file.write('K: {}' .format(k) +'\n')
            elif norma == "INCRA" and i_teste != 1:
                output_file.write('Tipo de limite: {}' .format(tipo_limite) +'\n')
            if i_teste != 1:    
                output_file.write('Camada teste: {}' .format(self.dlg.comboBox.currentText()) + '\n')
                output_file.write('Camada de referência: {}' .format(self.dlg.comboBox_2.currentText()) + '\n')
                output_file.write('\n' + '-'*100 + '\n\n')
            if norma == "Decreto 89.817/ET-CQDG" and i_teste != 1:
                if processamento == 'plan':
                    output_file.write('RESULTADO PLANIMETRIA:\n')
                    output_file.write(saida_plan + '\n')
                elif processamento == 'alt':
                    output_file.write('RESULTADO ALTIMETRIA:\n')
                    output_file.write(saida_alt + '\n')
                else:
                    output_file.write('RESULTADO PLANIMETRIA:\n')
                    output_file.write(saida_plan + '\n\n')
                    output_file.write('RESULTADO ALTIMETRIA:\n')
                    output_file.write(saida_alt + '\n')
            elif norma == "NBR 13.133 (Versão 1994)" and i_teste != 1:
                if processamento == 'plan':
                    output_file.write(saida_plan + '\n')
                elif processamento == 'alt':
                    output_file.write(saida_alt + '\n')
                else:
                    output_file.write(saida_plan + '\n')
                    output_file.write(saida_alt + '\n')
            elif norma == "INCRA" and i_teste != 1:
                if len(idd)>= 20:
                    output_file.write('RESULTADO:\n')
                    output_file.write(saida_incra + '\n')
                else:
                    self.iface.messageBar().pushMessage("Amostra menor que 20 pontos")
            if i_teste != 1:
                output_file.write('\n' + '-'*100 + '\n\n')
                output_file.write('ESTATÍSTICAS:\n')
                output_file.write('Número de pontos utilizados: {}\n\n' .format(len(idd)))
            if norma == "Decreto 89.817/ET-CQDG" and i_teste != 1:
                if processamento == 'plan':
                    output_file.write(' '*18 + '    dx   ' + ' '*5 + '    dy   ' + ' '*5 + '    d2d  \n')
                    output_file.write('Média             ' + '{:>9.4f}' .format((st.mean(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.mean(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.mean(eHi))) + '\n')
                    output_file.write('Desvio Padrão     ' + '{:>9.4f}' .format((st.stdev(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.stdev(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.stdev(eHi))) + '\n')
                    output_file.write('Variância         ' + '{:>9.4f}' .format((st.variance(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.variance(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.variance(eHi))) + '\n')
                    output_file.write('RMS               ' + '{:>9.4f}' .format(rms_x) + ' '*5 + '{:>9.4f}' .format(rms_y) + ' '*5 + '{:>9.4f}' .format(rms_d2d) + '\n')
                    output_file.write('Máximo            ' + '{:>9.4f}' .format((max(disc_x))) + ' '*5 + '{:>9.4f}' .format((max(disc_y))) + ' '*5 + '{:>9.4f}' .format((max(eHi))) + '\n')
                    output_file.write('Mínimo            ' + '{:>9.4f}' .format((min(disc_x))) + ' '*5 + '{:>9.4f}' .format((min(disc_y))) + ' '*5 + '{:>9.4f}' .format((min(eHi))) + '\n')
                elif processamento == 'alt':
                    output_file.write(' '*18 + ' '*5 + '    dz \n')
                    output_file.write('Média             ' + ' '*5 + '{:>9.4f}' .format((st.mean(disc_z))) + '\n')
                    output_file.write('Desvio Padrão     ' + ' '*5 + '{:>9.4f}' .format((st.stdev(disc_z))) + '\n')
                    output_file.write('Variância         ' + ' '*5 + '{:>9.4f}' .format((st.variance(disc_z))) + '\n')
                    output_file.write('RMS               ' + ' '*5 + '{:>9.4f}' .format(rms_z) + '\n')
                    output_file.write('Máximo            ' + ' '*5 + '{:>9.4f}' .format((max(disc_z))) + '\n')
                    output_file.write('Mínimo            ' + ' '*5 + '{:>9.4f}' .format((min(disc_z))) + '\n')
                else:
                    output_file.write(' '*18 + '    dx   ' + ' '*5 + '    dy   ' + ' '*5 + '    dz   ' + ' '*5 + '    d2d  \n')
                    output_file.write('Média             ' + '{:>9.4f}' .format((st.mean(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.mean(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.mean(disc_z)))+ ' '*5 + '{:>9.4f}' .format((st.mean(eHi))) + '\n')
                    output_file.write('Desvio Padrão     ' + '{:>9.4f}' .format((st.stdev(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.stdev(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.stdev(disc_z)))+ ' '*5 + '{:>9.4f}' .format((st.stdev(eHi))) + '\n')
                    output_file.write('Variância         ' + '{:>9.4f}' .format((st.variance(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.variance(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.variance(disc_z)))+ ' '*5 + '{:>9.4f}' .format((st.variance(eHi))) + '\n')
                    output_file.write('RMS               ' + '{:>9.4f}' .format(rms_x) + ' '*5 + '{:>9.4f}' .format(rms_y) + ' '*5 + '{:>9.4f}' .format(rms_z)+ ' '*5 + '{:>9.4f}' .format(rms_d2d) + '\n')
                    output_file.write('Máximo            ' + '{:>9.4f}' .format((max(disc_x))) + ' '*5 + '{:>9.4f}' .format((max(disc_y))) + ' '*5 + '{:>9.4f}' .format((max(disc_z)))+ ' '*5 + '{:>9.4f}' .format((max(eHi))) + '\n')
                    output_file.write('Mínimo            ' + '{:>9.4f}' .format((min(disc_x))) + ' '*5 + '{:>9.4f}' .format((min(disc_y))) + ' '*5 + '{:>9.4f}' .format((min(disc_z)))+ ' '*5 + '{:>9.4f}' .format((min(eHi))) + '\n')
            elif norma == "NBR 13.133 (Versão 1994)" and i_teste != 1:
                if processamento == 'plan':
                    output_file.write(' '*18 + 'disc. D\n')
                    output_file.write('Média             ' + '{:>9.4f}' .format((st.mean(disc_x))) + '\n')
                    output_file.write('Desvio Padrão     ' + '{:>9.4f}' .format((st.stdev(disc_x))) + '\n')
                    output_file.write('Variância         ' + '{:>9.4f}' .format((st.variance(disc_x))) + '\n')
                    output_file.write('RMS               ' + '{:>9.4f}' .format(rms_x) + '\n')
                    output_file.write('Máximo            ' + '{:>9.4f}' .format((max(disc_x))) + '\n')
                    output_file.write('Mínimo            ' + '{:>9.4f}' .format((min(disc_x))) + '\n')
                else:
                    output_file.write(' '*18 + 'disc. H\n')
                    output_file.write('Média             ' + '{:>9.4f}' .format((st.mean(disc_y))) + '\n')
                    output_file.write('Desvio Padrão     ' + '{:>9.4f}' .format((st.stdev(disc_y))) + '\n')
                    output_file.write('Variância         ' + '{:>9.4f}' .format((st.variance(disc_y))) + '\n')
                    output_file.write('RMS               ' + '{:>9.4f}' .format(rms_y) + '\n')
                    output_file.write('Máximo            ' + '{:>9.4f}' .format((max(disc_y))) + '\n')
                    output_file.write('Mínimo            ' + '{:>9.4f}' .format((min(disc_y))) + '\n')
                    
            elif norma == "INCRA" and i_teste != 1:
                output_file.write(' '*18 + '    dx   ' + ' '*5 + '    dy   ' + ' '*5 + '    d2d  \n')
                output_file.write('Média             ' + '{:>9.4f}' .format((st.mean(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.mean(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.mean(eHi))) + '\n')
                output_file.write('Desvio Padrão     ' + '{:>9.4f}' .format((st.stdev(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.stdev(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.stdev(eHi))) + '\n')
                output_file.write('Variância         ' + '{:>9.4f}' .format((st.variance(disc_x))) + ' '*5 + '{:>9.4f}' .format((st.variance(disc_y))) + ' '*5 + '{:>9.4f}' .format((st.variance(eHi))) + '\n')
                rms_x, rms_y, rms_z, rms_d2d = calc_rms(idd, 'planealt', disc_x, disc_y, disc_z)
                output_file.write('RMS               ' + '{:>9.4f}' .format(rms_x) + ' '*5 + '{:>9.4f}' .format(rms_y) + ' '*5 + '{:>9.4f}' .format(rms_d2d) + '\n')
                output_file.write('Máximo            ' + '{:>9.4f}' .format((max(disc_x))) + ' '*5 + '{:>9.4f}' .format((max(disc_y))) + ' '*5 + '{:>9.4f}' .format((max(eHi))) + '\n')
                output_file.write('Mínimo            ' + '{:>9.4f}' .format((min(disc_x))) + ' '*5 + '{:>9.4f}' .format((min(disc_y))) + ' '*5 + '{:>9.4f}' .format((min(eHi))) + '\n')   
            if i_teste != 1:
                output_file.write('\n' + '-'*100 + '\n\n')
            
            if norma == "Decreto 89.817/ET-CQDG" and i_teste != 1:
                if processamento == 'plan':
                    output_file.write('Tolerâncias' + ' '*5 + 'PEC-PCD Plan' + ' '*5 + '   EP Plan   ')
                    output_file.write('\n' + '     A     ' + ' '*5 + '{:^12.2f}' .format(EM_A_pla) + ' '*5 + '{:^13.2f}' .format(EP_A_pla))
                    output_file.write('\n' + '     B     ' + ' '*5 + '{:^12.2f}' .format(EM_B_pla) + ' '*5 + '{:^13.2f}' .format(EP_B_pla))
                    output_file.write('\n' + '     C     ' + ' '*5 + '{:^12.2f}' .format(EM_C_pla) + ' '*5 + '{:^13.2f}' .format(EP_C_pla))
                    output_file.write('\n' + '     D     ' + ' '*5 + '{:^12.2f}' .format(EM_D_pla) + ' '*5 + '{:^13.2f}' .format(EP_D_pla))
                    
                    output_file.write('\n\n' + ' ET-CQDG ' + ' '*5 + '%di(2D) <= PEC-PCD')
                    output_file.write('\n' + '    A    ' + ' '*5 + '{:^18.2%}' .format(porce_A_plan))
                    output_file.write('\n' + '    B    ' + ' '*5 + '{:^18.2%}' .format(porce_B_plan)) 
                    output_file.write('\n' + '    C    ' + ' '*5 + '{:^18.2%}' .format(porce_C_plan))    
                    output_file.write('\n' + '    D    ' + ' '*5 + '{:^18.2%}' .format(porce_D_plan))     
                    output_file.write('\n' + '-'*100 + '\n\n')
                    
                    #DISCREPANCIAS
                    output_file.write('DISCREPÂNCIAS\n')
                    output_file.write('\n ID  ' + ' '*5 + '  di(E)  ' + ' '*5 + '  di(N)  ' + ' '*5 + '  di(2D) ')
                    for i in range(len(idd)):
                        output_file.write('\n' + '{:^4}' .format(idd[i]) + ' '*5 + '{:>9.4f}' .format(disc_x[i]) + ' '*5 + '{:>9.4f}' .format(disc_y[i]) + ' '*5 + '{:>9.4f}' .format(eHi[i]))            
                elif processamento == 'alt':
                    output_file.write('Tolerâncias' + ' '*5 + 'PEC-PCD Alt' + ' '*5 + '   EP Alt   ')
                    output_file.write('\n' + '     A     ' + ' '*5 + '{:^11.2f}' .format(EM_A_alt) + ' '*5 + '{:^12.2f}' .format(EP_A_alt))
                    output_file.write('\n' + '     B     ' + ' '*5 + '{:^11.2f}' .format(EM_B_alt) + ' '*5 + '{:^12.2f}' .format(EP_B_alt))
                    output_file.write('\n' + '     C     ' + ' '*5 + '{:^11.2f}' .format(EM_C_alt) + ' '*5 + '{:^12.2f}' .format(EP_C_alt))
                    output_file.write('\n' + '     D     ' + ' '*5 + '{:^11.2f}' .format(EM_D_alt) + ' '*5 + '{:^12.2f}' .format(EP_D_alt))
                    
                    output_file.write('\n\n' + ' ET-CQDG ' + ' '*5 + '%di(z) <= PEC-PCD')
                    output_file.write('\n' + '    A    ' + ' '*5 + '{:^17.2%}' .format(porce_A_alt))
                    output_file.write('\n' + '    B    ' + ' '*5 + '{:^17.2%}' .format(porce_B_alt)) 
                    output_file.write('\n' + '    C    ' + ' '*5 + '{:^17.2%}' .format(porce_C_alt))    
                    output_file.write('\n' + '    D    ' + ' '*5 + '{:^17.2%}' .format(porce_D_alt))     
                    output_file.write('\n' + '-'*100 + '\n\n')
                    
                    #DISCREPANCIAS
                    output_file.write('DISCREPÂNCIAS\n')
                    output_file.write('\n ID  ' + ' '*5 + '  di(Z)  ')
                    for i in range(len(idd)):
                        output_file.write('\n' + '{:^4}' .format(idd[i]) + ' '*5 + '{:>9.4f}' .format(disc_z[i]))                
                else:
                    output_file.write('Tolerâncias' + ' '*5 + 'PEC-PCD Plan' + ' '*5 + '   EP Plan   ' + ' '*5 + 'PEC-PCD Alt' + ' '*5 + '   EP Alt   ')
                    output_file.write('\n' + '     A     ' + ' '*5 + '{:^12.2f}' .format(EM_A_pla) + ' '*5 + '{:^13.2f}' .format(EP_A_pla) + ' '*5 + '{:^11.2f}' .format(EM_A_alt) + ' '*5 + '{:^12.2f}' .format(EP_A_alt))
                    output_file.write('\n' + '     B     ' + ' '*5 + '{:^12.2f}' .format(EM_B_pla) + ' '*5 + '{:^13.2f}' .format(EP_B_pla) + ' '*5 + '{:^11.2f}' .format(EM_B_alt) + ' '*5 + '{:^12.2f}' .format(EP_B_alt))
                    output_file.write('\n' + '     C     ' + ' '*5 + '{:^12.2f}' .format(EM_C_pla) + ' '*5 + '{:^13.2f}' .format(EP_C_pla) + ' '*5 + '{:^11.2f}' .format(EM_C_alt) + ' '*5 + '{:^12.2f}' .format(EP_C_alt))
                    output_file.write('\n' + '     D     ' + ' '*5 + '{:^12.2f}' .format(EM_D_pla) + ' '*5 + '{:^13.2f}' .format(EP_D_pla) + ' '*5 + '{:^11.2f}' .format(EM_D_alt) + ' '*5 + '{:^12.2f}' .format(EP_D_alt))
                    
                    output_file.write('\n\n' + ' ET-CQDG ' + ' '*5 + '%di(2D) <= PEC-PCD' + ' '*5 + '%di(z) <= PEC-PCD')
                    output_file.write('\n' + '    A    ' + ' '*5 + '{:^18.2%}' .format(porce_A_plan) + ' '*5 + '{:^17.2%}' .format(porce_A_alt))
                    output_file.write('\n' + '    B    ' + ' '*5 + '{:^18.2%}' .format(porce_B_plan) + ' '*5 + '{:^17.2%}' .format(porce_B_alt)) 
                    output_file.write('\n' + '    C    ' + ' '*5 + '{:^18.2%}' .format(porce_C_plan) + ' '*5 + '{:^17.2%}' .format(porce_C_alt))    
                    output_file.write('\n' + '    D    ' + ' '*5 + '{:^18.2%}' .format(porce_D_plan) + ' '*5 + '{:^17.2%}' .format(porce_D_alt))     
                    output_file.write('\n' + '-'*100 + '\n\n')
                    
                    #DISCREPANCIAS
                    output_file.write('DISCREPÂNCIAS\n')
                    output_file.write('\n ID  ' + ' '*5 + '  di(E)  ' + ' '*5 + '  di(N)  ' + ' '*5 + '  di(2D) ' + ' '*5 + '  di(Z)  ')
                    for i in range(len(idd)):
                        output_file.write('\n' + '{:^4}' .format(idd[i]) + ' '*5 + '{:>9.4f}' .format(disc_x[i]) + ' '*5 + '{:>9.4f}' .format(disc_y[i]) + ' '*5 + '{:>9.4f}' .format(eHi[i]) + ' '*5 + '{:>9.4f}' .format(disc_z[i]))
                
            elif norma == "NBR 13.133 (Versão 1994)" and i_teste != 1:
                output_file.write('ma planimétrico: {:.4f}m\n' .format(ma))
                output_file.write('ma altimétrico: {:.4f}m\n' .format(desv_alt))
                output_file.write('m planimétrico: {:.4f}m\n' .format(desv_pad_plan))
                output_file.write('m altimétrico: {:.4f}m\n' .format(desv_pad_alt))
                output_file.write('PEP: {:.4f}m\n' .format(pep))
                output_file.write('PEA: {:.4f}m\n' .format(pea))
                output_file.write('%di <= PEP: {:.2%}\n' .format(porce_plan))
                output_file.write('%di <= PEA: {:.2%}\n' .format(porce_alt))
                output_file.write('\n' + '-'*100 + '\n\n')
                
                #DISCREPANCIAS
                output_file.write('DISCREPÂNCIAS\n')
                if processamento == 'plan':
                    output_file.write('\n ID  ' + ' '*5 + 'di(dist)')
                    for i in range(len(idd)):
                        output_file.write('\n' + '{:^4}' .format(idd[i]) + ' '*5 + '{:>9.4f}' .format(disc_x[i]))
                else:
                    output_file.write('\n ID  ' + ' '*5 + '  di(H) ')
                    for i in range(len(idd)):
                        output_file.write('\n' + '{:^4}' .format(idd[i]) + ' '*5 + '{:>9.4f}' .format(disc_y[i]))
                        
            elif norma == "INCRA" and i_teste != 1:
                output_file.write(dados_shapiro)
                output_file.write('\n' + result_shapiro)
                output_file.write('\n\n' + dados_tstudent)
                output_file.write('\np-valor para um nível de confiança a 90%: 0.1')
                output_file.write('\n' + result_tstudent)
                
                res_artificial = (cont_artificial/len(idd))
                res_natural = (cont_natural/len(idd))
                res_inacessivel = (cont_inacessivel/len(idd))
                
                output_file.write('\n\n\n' + '-'*10 + ' %di <= Tolerância Limite ' + '-'*10)
                output_file.write('\n' + '%di <= Tolerância do limite artificial: {:.2%}' .format(res_artificial))
                output_file.write('\n' + '%di <= Tolerância do limite natural: {:.2%}' .format(res_natural))
                output_file.write('\n' + '%di <= Tolerância do limite inacessível: {:.2%}' .format(res_inacessivel))
                
                output_file.write('\n\nRESULTADOS:')
                if res_artificial == 1:
                    output_file.write('\nResultado para o tipo de limite Artificial: Aprovado com 100.000% das amostras menores que a tolerância')
                else:
                    output_file.write('\nResultado para o tipo de limite Artificial: Reprovado com {:.3%} das amostras menores que a tolerância' .format(res_artificial))
                if res_natural == 1:
                    output_file.write('\nResultado para o tipo de limite Natural: Aprovado com 100.000% das amostras menores que a tolerância')
                else:
                    output_file.write('\nResultado para o tipo de limite Natural: Reprovado com {:.3%} das amostras menores que a tolerância' .format(res_natural))                
                if res_inacessivel == 1:
                    output_file.write('\nResultado para o tipo de limite Inacessivel: Aprovado com 100.000% das amostras menores que a tolerância')
                else:
                    output_file.write('\nResultado para o tipo de limite Inacessivel: Reprovado com {:.3%} das amostras menores que a tolerância' .format(res_inacessivel))                
                output_file.write('\n' + '-'*100 + '\n\n')
                
                #DISCREPANCIAS
                output_file.write('DISCREPÂNCIAS\n')
                output_file.write('\n ID  ' + ' '*5 + '  di(E)  ' + ' '*5 + '  di(N)  ' + ' '*5 + '  di(2D) ')
                for i in range(len(idd)):
                    output_file.write('\n' + '{:^4}' .format(idd[i]) + ' '*5 + '{:>9.4f}' .format(disc_x[i]) + ' '*5 + '{:>9.4f}' .format(disc_y[i]) + ' '*5 + '{:>9.4f}' .format(eHi[i]))
            if i_teste != 1:
                output_file.write('\n' + '-'*150 + '\n\n')
                output_file.write('Programa desenvolvido por Isaac Antunes Miranda Junior do curso de Engenharia de Agrimensura e Cartográfica da Universidade Federal de Viçosa, orientado pelo Professor Afonso de Paula dos Santos através do programa de iniciação cientifica CAPES/PIBIC.')
                output_file.write('\n\nEste projeto de pesquisa é parte integrante de pesquisas que estão em desenvolvimento no Programa de Pós-Graduação em Engenharia Civil (PPGEC), área de concentração em Informações Espaciais, linha de pesquisa Cartografia, da Universidade Federal de Viçosa.')
                output_file.write('\n\n' + '-'*150 + '\n\n') 
                output_file.close()
        pass
