# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PathSorting
                                 A QGIS plugin
 Change line dirction
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-16
        git sha              : $Format:%H$
        copyright            : (C) 2021 by GeoEspacio Tech Private Limited
        email                : info@geoespaciotech.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
import qgis.utils
from qgis.gui import *
from qgis.core import *
from .resources import *
import os.path
import sys
from builtins import object
sys.path.append(os.path.dirname(__file__))
import resources
class PathSorting:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PathSorting_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Path Sorting')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PathSorting', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/path_sorting/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Path Sorting'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Path Sorting'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        cval=[]
        ll = QgsProject.instance().layerTreeRoot().findLayers()
        if len(ll) != 2:
            qgis.utils.iface.messageBar().pushMessage(u"Path Sorting ", u"Please add only 2 layer (line and point)", level=Qgis.Critical)
            return
        for l in ll:
            l1=l.layer()
            if l1.geometryType()== QgsWkbTypes.LineGeometry:
                lShp= l1
            else:
                pshp=l1
        lShp.startEditing()
        for f in lShp.getFeatures():
            geom=f.geometry()
            fv=QgsGeometry(geom.get()[0][0])
            for k in pshp.getFeatures():
                if k.geometry().intersects(fv):
                    g2 = geom
                    cval.append(g2)
                    if g2.isMultipart():
                        mlsg = QgsMultiLineString()
                        for line in g2.asGeometryCollection():
                            mlsg.addGeometry(line.constGet().reversed())
                        ng2 = QgsGeometry(mlsg)
                        lShp.changeGeometry(f.id(),ng2)
                    else:
                        ng2 = QgsGeometry(g2.constGet().reversed())
                        lShp.changeGeometry(f.id(),ng2)
        lShp.commitChanges()
        if len(cval)>0:
            qgis.utils.iface.mapCanvas().refresh()
            qgis.utils.iface.messageBar().pushMessage(u"Path Sorting ", u"Dirction changed", level=Qgis.Info)
        else:
            qgis.utils.iface.messageBar().pushMessage(u"Path Sorting ", u"Nothing to change", level=Qgis.Info)
