# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PartialHistogram
                                 A QGIS plugin
 This plugin creates histogram of a part of a raster.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-20
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Murat ÇALIŞKAN
        email                : caliskan.murat.20@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.utils import iface

from qgis.core import Qgis, QgsProject

import numpy as np
from osgeo import gdal

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .partial_histogram_dialog import PartialHistogramDialog
import os.path


try:
    import cv2
    mdlChck_cv = 1
except:
    mdlChck_cv = 0
    
try:
    from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
    import matplotlib.pyplot as plt
    mdlChck_plt = 1
except:
    mdlChck_plt = 0
    
class PartialHistogram:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PartialHistogram_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Partial Histogram')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PartialHistogram', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToRasterMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/partial_histogram/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Partial Histogram'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginRasterMenu(
                self.tr(u'&Partial Histogram'),
                action)
            self.iface.removeToolBarIcon(action)


    def updateBandNumbers(self, rasterName):
        self.rasterName = rasterName
        self.raster_path = self.raster_layers[self.rasterName].source()
        self.raster = gdal.Open(self.raster_path)
        self.bandCount = self.raster.RasterCount
        
        self.dlg.cbBand.clear()
        self.bandList = [str(i) for i in range(1,self.bandCount+1)]
        self.dlg.cbBand.addItems(self.bandList)
    
    
    def plot(self):
        self.rasterName = self.dlg.cbRaster.currentText()
        self.selectedList = self.dlg.lstFieldVals.selectedItems()
        
        if self.selectedList:
            if self.rasterName:            
                self.dlg.lblMessage.setText("Processing " + self.rasterName + "...")
                self.dlg.lblMessage.repaint()
                
                self.array = self.getRaster()
                
                if self.array is not None:
                    self.bins = self.dlg.spnBins.value()
                    
                    self.figure.clear()
                    self.ax = self.figure.add_subplot(111)
                    
                    self.ax.hist(self.array, bins=self.bins)
                    self.canvas.draw()
                    
                    self.dlg.lblMessage.setText("Result Raster: " + self.rasterName + ", Band: " + self.bandNo + ", by: " + self.selectedList[0].text())
                    self.dlg.lblmin.setText("Min   : " + str(round(self.array.min(), 2)))
                    self.dlg.lblmax.setText("Max   : " + str(round(self.array.max(), 2)))
                    self.dlg.lblmean.setText("Mean : " + str(round(self.array.mean(), 2)))
                    self.dlg.lblstd.setText("Std    : " + str(round(self.array.std(), 2)))
                else:
                    self.dlg.lblMessage.setText("Null Geometry!")
            
            else:           
                self.dlg.lblMessage.setText("No raster selected.")
                self.dlg.lblMessage.repaint()
        else:
            self.dlg.lblMessage.setText("No Attribute Selected From List")
            
    def fillAttributes(self, activeField):
        self.dlg.lstFieldVals.clear()
        self.selectedField = activeField        
        
        try:
            self.layer = [i for i in QgsProject.instance().mapLayersByName(self.dlg.cbVector.currentText()) if i.wkbType() in [3,6]][0]
            self.features = sorted(set([str(i[self.selectedField]) for i in self.layer.getFeatures()]))
            self.dlg.lstFieldVals.addItems(self.features)
        except:
            pass
            
    
    def fillFields(self, activeLayer):
        self.dlg.cbFields.clear()
        if QgsProject.instance().mapLayersByName(activeLayer):
            self.selectedLayer = [i for i in QgsProject.instance().mapLayersByName(activeLayer) if i.wkbType() in [3,6]][0]
            self.fields = [field.name() for field in self.selectedLayer.fields()]
            self.dlg.cbFields.addItems(self.fields)
    
    def map2pix(self, coors, x0, y0, size):
        self.x, self.y = coors
        self.col = int((self.x-x0)/size)
        self.row = int((y0-self.y)/size)    
        return self.col, self.row
    
    def getRaster(self):
        self.rasterName = self.dlg.cbRaster.currentText()
        self.vectorName = self.dlg.cbVector.currentText()
                
        self.raster_path = self.raster_layers[self.rasterName].source()                
        self.raster = gdal.Open(self.raster_path)
        self.geot = self.raster.GetGeoTransform()
        
        self.bandNo = self.dlg.cbBand.currentText()
        self.band = self.raster.GetRasterBand(int(self.bandNo))        
        self.nodata = self.band.GetNoDataValue()
        
        self.layer = [i for i in QgsProject.instance().mapLayersByName(self.vectorName) if i.wkbType() in [3,6]][0]
        self.features = self.layer.getFeatures()
        
        self.fld = self.dlg.cbFields.currentText()
        self.attr = self.dlg.lstFieldVals.selectedItems()[0]
        self.array = np.array([])
        for feat in self.features:
            if str(feat[self.fld]) == self.attr.text():
                if feat.geometry().isEmpty():
                    self.dlg.lblMessage.setText("Invalid geometry!")                    
                    return None
                
                self.geom = feat.geometry().buffer(0,5)
                self.bbox = self.geom.boundingBox()
                self.minX, self.maxX, self.minY, self.maxY = self.bbox.xMinimum(), self.bbox.xMaximum(), self.bbox.yMinimum(), self.bbox.yMaximum()
                self.col_left, self.row_top = self.map2pix((self.minX, self.maxY), x0=self.geot[0], y0=self.geot[3], size=self.geot[1])
                self.col_right, self.row_bottom = self.map2pix((self.maxX, self.minY), x0=self.geot[0], y0=self.geot[3], size=self.geot[1])
                
                self.xoff, self.yoff = self.col_left, self.row_top
                self.xsize = self.col_right - self.col_left + 1
                self.ysize = self.row_bottom - self.row_top + 1
                
                
                if self.xoff < 0:
                    self.xsize = self.xsize + self.xoff
                    self.xoff = 0
                    
                if self.yoff < 0:           
                    self.ysize = self.ysize + self.yoff
                    self.yoff = 0
                    
                
                if self.xsize + self.xoff > self.raster.RasterXSize:
                    self.xsize = self.raster.RasterXSize - self.xoff
                if self.ysize + self.yoff > self.raster.RasterYSize:
                    self.ysize = self.raster.RasterYSize - self.yoff
                
                try:
                    self.arr = self.band.ReadAsArray(self.xoff, self.yoff, self.xsize, self.ysize)                    
                except:
                    return None
                
                if self.arr is None:
                    return None
                
                self.arr = self.arr.astype(float)
                self.new_geot = ["_","_","_","_","_","_"]
                self.new_geot[0] = self.geot[0] + self.xoff * self.geot[1]
                self.new_geot[1] = self.geot[1]
                self.new_geot[2] = self.geot[2]
                self.new_geot[3] = self.geot[3] + self.yoff * self.geot[5]
                self.new_geot[4] = self.geot[4]
                self.new_geot[5] = self.geot[5]                
                
                
                self.pol_list = []
                if self.geom.wkbType() == 3: # Polygon
                    self.pol = self.geom.asPolygon()
                    for g in self.pol:
                        self.glist = [self.map2pix((gg.x(), gg.y()), x0=self.new_geot[0], y0=self.new_geot[3], size=self.new_geot[1]) for gg in g]
                        self.pol_list.append(np.array(self.glist))
                
                elif self.geom.wkbType() == 6: # MultiPolygon
                    self.pol = self.geom.asMultiPolygon() 
                    for g in self.pol:
                        for gg in g:
                            self.glist = [self.map2pix((ggg.x(), ggg.y()), x0=self.new_geot[0], y0=self.new_geot[3], size=self.new_geot[1]) for ggg in gg]
                            self.pol_list.append(np.array(self.glist)) 
        
                self.arr_clip = self.arr.copy()
                
                self.foo = cv2.fillPoly(self.arr_clip, np.array(self.pol_list), np.nan)
                self.arr_clip = np.where(self.arr_clip == self.arr_clip, np.nan, np.where(self.arr==self.nodata, np.nan, self.arr))
                self.array = np.append(self.array, self.arr_clip[self.arr_clip==self.arr_clip])
                del self.arr, self.arr_clip
                
        return self.array
    
    def run(self):
        """Run method that performs all the real work"""
        
        self.dlg = PartialHistogramDialog()
        
        if mdlChck_cv == 0:
            iface.messageBar().pushMessage("Error", "opencv couldn't be impported successfully! Please check the GitHub page to learn how to install manually." , level=Qgis.Critical, duration=10)
            return
        if mdlChck_plt == 0:
            iface.messageBar().pushMessage("Error", "matplotlib couldn't be impported successfully! Please check the GitHub page to learn how to install manually." , level=Qgis.Critical, duration=10)
            return
        
        self.vector_layers = {layer.name():layer for layer in QgsProject.instance().mapLayers().values() if (layer.type()== 0 and layer.wkbType() in (3,6))}
        self.raster_layers = {layer.name():layer for layer in QgsProject.instance().mapLayers().values() if layer.type()== 1}
        
        self.dlg.cbVector.clear()
        self.dlg.cbVector.addItems(self.vector_layers.keys()) 
        
        self.dlg.cbRaster.clear()
        self.dlg.cbRaster.addItems(self.raster_layers.keys())
        
        self.rasterName = self.dlg.cbRaster.currentText()
        self.fillFields(self.dlg.cbVector.currentText())
        self.fillAttributes(self.dlg.cbFields.currentText())
        
        self.figure = plt.figure()
        self.canvas = FigureCanvas(self.figure)
        self.dlg.layout.addWidget(self.canvas)
        self.ax = self.figure.add_subplot(111) 
        
        try:
            self.raster_path = self.raster_layers[self.rasterName].source()
            self.raster = gdal.Open(self.raster_path)
            self.bandCount = self.raster.RasterCount
            self.bandList = [str(i) for i in range(1,self.bandCount+1)]
            self.dlg.cbBand.addItems(self.bandList)
        except:
            pass        
        
        self.dlg.btnPlot.clicked.connect(self.plot)
        self.dlg.cbRaster.currentTextChanged.connect(lambda x:self.updateBandNumbers(x))
        self.dlg.cbVector.currentTextChanged.connect(lambda x:self.fillFields(x))
        self.dlg.cbFields.currentTextChanged.connect(lambda x:self.fillAttributes(x))
        

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False            

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
