from pathlib import Path

from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDockWidget

from panoramax.gui.panoramax_widget import PanoramaxWidget
from panoramax.model.picture import Picture
from panoramax.toolbelt import PlgLogger


class DlgImageViewer(QDockWidget):
    def __init__(self, parent=None):
        super().__init__("Panoramax Viewer", parent)
        uic.loadUi(Path(__file__).parent / f"{Path(__file__).stem}.ui", self)

        # toolbelt
        self.log = PlgLogger().log

        self.pano_widget = PanoramaxWidget()
        self.frame_layout.addWidget(self.pano_widget)
        self._orientation = 0.0
        self.initial_orientation = 0.0

    def set_pixmap(self, pixmap, field_of_view: int):
        """
        Met à jour l'image affichée dans le viewer.
        :param pixmap: image to display
        :type pixmap: QPixmap
        :param field_of_view: indicates the field of view of the picture
        :type field_of_view: int
        :return: None
        :rtype: None
        """
        self.pano_widget.setPixmap(pixmap, field_of_view)

    def set_content_infos(self, picture_infos: Picture, pictures_count: int = 0):
        """
        Met à jour l'entête avec les infos de l'image.
        :param picture_infos: panoramax picture info
        :type picture_infos: Picture
        :param pictures_count: total number of pictures in the sequence
        :type pictures_count: int
        :return: None
        :rtype: None
        """

        item_rank = picture_infos.get_rank_in_sequence()
        rank_str = f"({item_rank} / {pictures_count})" if item_rank else ""

        self.header_label.setText(
            self.tr(
                f"Picture : <a href='https://explore.panoramax.fr?pic={picture_infos.get_id()}'>"
                f"{picture_infos.get_id()}</a> {rank_str} <br>"
                f"Author : {picture_infos.get_author()}<br>"
                f"Date : {picture_infos.get_date()}<br>"
                f"License : {picture_infos.get_license()}<br>"
                f"Original instance : {picture_infos.get_instance()}<br>"
            )
        )
        # open link in web browser when clicked
        self.header_label.setOpenExternalLinks(True)
