class Sequence:
    def __init__(self, sequence_object):
        self.id = sequence_object["id"]
        self.pictures_count = sequence_object["stats:items"]["count"]
        self.instance_url = None
        for el in sequence_object["links"]:
            if el["rel"] == "via":
                self.instance_url = el["href"]

    def get_id(self):
        return self.id

    def get_pictures_count(self):
        return self.pictures_count

    def get_instance_url(self):
        return self.instance_url

    def __str__(self):
        return f"Sequence(id={self.id}, pictures_count={self.pictures_count})"
