from qgis.core import QgsPointXY


class Picture:
    def __init__(self, picture_object):
        """
        Initialize a Picture object.

        :param picture_object: The picture object from the API response.
        :type picture_object: dict
        """
        self.id = picture_object["id"]
        self.sequence_id = picture_object["collection"]
        self.previous_geom = None
        self.next_geom = None
        # retrieve previous and next pictures in sequance from links
        self.previous, self.next = None, None
        for el in picture_object["links"]:
            if el["rel"] == "prev":
                self.previous = el["id"]
                self.previsous_geom = QgsPointXY(*el["geometry"]["coordinates"])
            elif el["rel"] == "next":
                self.next = el["id"]
                self.next_geom = QgsPointXY(*el["geometry"]["coordinates"])

        # get properties
        properties = picture_object["properties"]
        self.rank_in_sequence = properties["geovisio:rank_in_collection"]
        self.heading = properties["view:azimuth"]
        self.url = properties["geovisio:image"]

        # get geometry
        geometry = picture_object["geometry"]
        if not geometry or "coordinates" not in geometry:
            raise ValueError("Invalid geometry in picture object")
        coordinates = geometry["coordinates"]
        self.geom = QgsPointXY(*coordinates)

    def get_id(self):
        return self.id

    def get_sequence_id(self):
        return self.sequence_id

    def get_sequence_url(self):
        return self.sequence_url

    def get_rank_in_sequence(self):
        return self.rank_in_sequence

    def get_heading(self) -> float:
        return self.heading

    def get_previous(self):
        return self.previous

    def get_next(self):
        return self.next

    def get_url(self):
        return self.url

    def get_geom(self):
        return self.geom

    def get_previous_geom(self):
        return self.previsous_geom

    def get_next_geom(self):
        return self.next_geom

    def __str__(self):
        return f"Picture(id={self.id}, sequence_id={self.sequence_id}, rank_in_sequence={self.rank_in_sequence})"
