from pathlib import Path

from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDockWidget

from panoramax.gui.panoramax_widget import PanoramaxWidget
from panoramax.model.picture import Picture
from panoramax.toolbelt import PlgLogger


class DlgImageViewer(QDockWidget):
    def __init__(self, parent=None):
        super().__init__("Panoramax Viewer", parent)
        uic.loadUi(Path(__file__).parent / f"{Path(__file__).stem}.ui", self)

        # toolbelt
        self.log = PlgLogger().log

        self.pano_widget = PanoramaxWidget()
        self.frame_layout.addWidget(self.pano_widget)
        self._orientation = 0.0
        self.initial_orientation = 0.0

    def set_pixmap(self, pixmap):
        self.pano_widget.setPixmap(pixmap)

    def set_content_infos(self, picture_infos: Picture, pictures_count: int = 0):
        """
        Met à jour l'entête avec les infos de l'image.
        :param picture_infos: panoramax picture info
        :type picture_infos: Picture
        :param pictures_count: total number of pictures in the sequence
        :type pictures_count: int
        :return: None
        :rtype: None
        """
        self.header_label.setText(
            self.tr(
                f"Picture : {picture_infos.id}\n"
                f"Sequence {picture_infos.sequence_id}\n"
                f"{picture_infos.rank_in_sequence} / {pictures_count}"
            )
        )
