def compute_center_x_for_heading(image_width, initial_heading, target_heading):
    """
    Compute the center x position to display target_heading at the center of
    the panoramic widget.
    :param image_width: width of the image (int)
    :param initial_heading: heading of the photo (float)
    :param target_heading: target heading (float)
    :return: center x position (float)
    """
    rel_angle = (target_heading - initial_heading) % 360
    return image_width * 1.5 + (rel_angle / 360.0) * image_width
