# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AbstractClsDialog
                                 A QGIS plugin
 UsingQT abstract tiem
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-02-22
        git sha              : $Format:%H$
        copyright            : (C) 2025 by fdo
        email                : fbadilla@ing.uchile.cl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
from functools import partial
from math import nan

from osgeo_utils.gdal_calc import GDALDataTypeNames  # type: ignore
from PyQt5.QtCore import QUrl
from PyQt5.QtGui import QDesktopServices
from qgis.core import QgsProject, QgsRectangle, QgsVectorLayer  # type: ignore
from qgis.gui import QgsDoubleSpinBox  # type: ignore
from qgis.PyQt import QtWidgets, uic  # type: ignore
from qgis.PyQt.QtCore import QSize, Qt  # type: ignore

from .double_spin_slider import DoubleSpinSlider


def breakit():
    # fmt: off
    from IPython.terminal.embed import InteractiveShellEmbed
    from qgis.PyQt.QtCore import pyqtRemoveInputHook
    pyqtRemoveInputHook()
    # fmt: on
    return InteractiveShellEmbed()


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), "dialog.ui"))


class Dialog(QtWidgets.QDialog, FORM_CLASS):  # type: ignore
    def __init__(self, parent=None, iface=None, model=None):
        """Constructor."""
        super().__init__(parent)

        self.setupUi(self)

        self.iface = iface
        self.model = model

        self.tree.setItemsExpandable(True)
        self.tree.setModel(self.model)
        self.tree.setEditTriggers(QtWidgets.QAbstractItemView.AllEditTriggers)
        self.tree.setItemDelegateForColumn(2, WeightDoubleSpinSliderDelegate(self))
        self.tree.setItemDelegateForColumn(3, UtilityFuncComboBoxDelegate(self))
        self.tree.setItemDelegateForColumn(4, SliderListDelegate(self))
        # buttons
        self.button_box.button(QtWidgets.QDialogButtonBox.Apply).clicked.connect(lambda: self.on_apply())
        self.button_box.button(QtWidgets.QDialogButtonBox.Cancel).clicked.connect(lambda: self.on_cancel())
        self.button_box.button(QtWidgets.QDialogButtonBox.Close).clicked.connect(lambda: self.reject())
        self.button_box.button(QtWidgets.QDialogButtonBox.Help).clicked.connect(lambda: self.on_help())
        self.button_box.button(QtWidgets.QDialogButtonBox.Ok).clicked.connect(lambda: self.on_ok())
        self.button_box.button(QtWidgets.QDialogButtonBox.Reset).clicked.connect(lambda: self.on_reset())

        # datatype
        for i, text in enumerate(GDALDataTypeNames):
            self.comboBox_rtype.addItem(text, i)
        # self.comboBox_rtype.setCurrentIndex(GDALDataTypeNames.index("Float32"))
        self.comboBox_rtype.setCurrentIndex(-1)
        # nodata
        self.doubleSpinBox_no_data.setSpecialValueText("")
        self.doubleSpinBox_no_data.clear()
        # extent
        self.setup_extent_group_box()
        self.iface.mapCanvas().extentsChanged.connect(self.handle_extent_change)
        self.iface.mapCanvas().selectionChanged.connect(self.on_iface_selection_changed_update_extent_group_box)

    def on_apply(self):
        self.model.balance_weights()

    def on_ok(self):
        self.model.balance_weights()
        self.model.doit(
            load_normalized=self.checkBox_load_normalized.isChecked(),
            no_data=revalue_double_spin_box(self.doubleSpinBox_no_data),
            rtype=revalue_combo_box(self.comboBox_rtype),
            projwin=self.mExtentGroupBox.outputExtent(),
            outfile=self.fileWidget.filePath(),
        )

    def on_help(self):
        QDesktopServices.openUrl(QUrl("https://fire2a.github.io/qgis-pan-europeo/"))

    def on_cancel(self):
        self.model.cancel_tasks()

    def on_reset(self):
        self.reject()
        self.model.reset()

    def setup_extent_group_box(self):
        """Set up the QgsExtentGroupBox."""
        extent = self.iface.mapCanvas().extent()
        crs = QgsProject.instance().crs()

        self.mExtentGroupBox.setOriginalExtent(extent, crs)
        self.mExtentGroupBox.setCurrentExtent(extent, crs)
        self.mExtentGroupBox.setOutputCrs(crs)

    def handle_extent_change(self):
        """Handle the extentsChanged signal from the map canvas."""
        extent = self.iface.mapCanvas().extent()
        crs = QgsProject.instance().crs()
        self.mExtentGroupBox.setCurrentExtent(extent, crs)

    def on_iface_selection_changed_update_extent_group_box(self, layer):
        if isinstance(layer, QgsVectorLayer) and layer.selectedFeatureCount() > 0:
            if layer.selectedFeatureCount() == 1:
                extent = layer.selectedFeatures()[0].geometry().boundingBox()
            else:
                min_x = float("inf")
                max_x = -float("inf")
                min_y = float("inf")
                max_y = -float("inf")
                for feat in layer.selectedFeatures():
                    bbox = feat.geometry().boundingBox()
                    min_x = min(bbox.xMinimum(), min_x)
                    max_x = max(bbox.xMaximum(), max_x)
                    min_y = min(bbox.yMinimum(), min_y)
                    max_y = max(bbox.yMaximum(), max_y)
                extent = QgsRectangle(min_x, min_y, max_x, max_y)

            crs = QgsProject.instance().crs()
            self.mExtentGroupBox.setOutputExtentFromUser(extent, crs)


def revalue_combo_box(combo):
    if combo.currentIndex() == -1:
        return None
    return combo.currentIndex()


def revalue_double_spin_box(spin):
    if spin.text() == spin.specialValueText():
        return None
    return spin.value()


class WeightDoubleSpinSliderDelegate(QtWidgets.QStyledItemDelegate):
    def createEditor(self, parent, option, index):
        value = index.model().data(index, Qt.EditRole)
        editor = DoubleSpinSlider(parent=parent)
        editor.set3(0, value, 100)
        editor.valueChanged.connect(lambda value, idx=index: self.on_value_changed(value, idx))
        return editor

    def setEditorData(self, editor, index):
        editor.setValue(index.model().data(index, Qt.EditRole))

    def setModelData(self, editor, model, index):
        model.setData(index, editor.value(), Qt.EditRole)

    def on_value_changed(self, value, index):
        model = index.model()
        model.setData(index, value, Qt.EditRole)

    def updateEditorGeometry(self, editor, option, index):
        editor.setGeometry(option.rect)

    def paint(self, painter, option, index):
        if value := index.model().data(index, Qt.EditRole):
            # widget = QtWidgets.QWidget()
            # layout = QtWidgets.QBoxLayout(widget)
            slider = DoubleSpinSlider(parent=self.parent().tree)
            slider.set3(0, value, 100)
            slider.setGeometry(option.rect)
            # layout.addWidget(slider)
            tree = self.parent().tree
            tree_top_left = tree.viewport().mapTo(tree, option.rect.topLeft())
            window_top_left = tree.mapTo(tree.window(), tree_top_left)
            slider.render(painter, window_top_left)
            del slider
            # widget.render(painter, window_top_left)
            # pt = painter.deviceTransform().map(option.rect.topLeft())
            # print(
            #     f"weight:paint: {index.row()} t w r p",
            #     tree_top_left,
            #     window_top_left,
            #     option.rect.topLeft(),
            #     #     pt,
            #     sep="\n",
            # )
        else:
            super().paint(painter, option, index)

    def sizeHint(self, option, index):
        return QSize(200, 40)


class UtilityFuncComboBoxDelegate(QtWidgets.QStyledItemDelegate):
    def createEditor(self, parent, option, index):
        # print(f"ComboBoxDelegate:createEditor: {index.row()=}, {index.column()=}")
        model = index.model()
        editor = QtWidgets.QComboBox(parent=parent)
        data = model.data(index, Qt.EditRole)
        for item in data["cb"]:
            editor.addItem(item["description"], item)
        editor.setCurrentIndex(data["idx"])
        editor.currentIndexChanged.connect(partial(self.commitAndCloseEditor, editor))
        return editor

    def setEditorData(self, editor, index):
        # print(f"ComboBoxDelegate:setEditorData: {index.row()=}, {index.column()=}")
        value = index.model().data(index, Qt.EditRole)
        editor.setCurrentIndex(editor.findData(value))

    def setModelData(self, editor, model, index):
        # print(f"ComboBoxDelegate:setModelData: {index.row()=}, {index.column()=}")
        value = {"cb": [editor.itemData(i) for i in range(len(editor))], "idx": editor.currentIndex()}
        model.setData(index, value, Qt.EditRole)

    def commitAndCloseEditor(self, editor):
        self.commitData.emit(editor)
        self.closeEditor.emit(editor, QtWidgets.QAbstractItemDelegate.NoHint)

    def updateEditorGeometry(self, editor, option, index):
        editor.setGeometry(option.rect)

    def sizeHint(self, option, index):
        return QSize(200, 40)

    def paint(self, painter, option, index):
        # disp = index.model().data(index, Qt.DisplayRole) ALWAYS NULL ?? incluso con model.setData DisplayRole ?
        # edit = index.model().data(index, Qt.EditRole)
        # print(f"ComboBoxDelegate:print: {index.row()=}, {index.column()=}, {disp=}, {edit=}")
        if value := index.model().data(index, Qt.EditRole):
            idx = value["idx"]
            description = value["cb"][idx]["description"]
            combo = QtWidgets.QComboBox(parent=self.parent().tree)
            combo.addItem(description)
            combo.setGeometry(option.rect)
            tree = self.parent().tree
            tree_top_left = tree.viewport().mapTo(tree, option.rect.topLeft())
            window_top_left = tree.mapTo(tree.window(), tree_top_left)
            combo.render(painter, window_top_left)
            del combo
        else:
            super().paint(painter, option, index)


class SliderListDelegate(QtWidgets.QStyledItemDelegate):
    def createEditor(self, parent, option, index):
        sliders = index.model().data(index, Qt.EditRole)
        editor = QtWidgets.QWidget(parent=parent)
        editor.setAttribute(Qt.WA_TranslucentBackground)
        layout = QtWidgets.QVBoxLayout(editor)
        layout.setContentsMargins(0, 0, 0, 0)
        for slidx, (text, min_, val, max_) in enumerate(sliders):
            slider = DoubleSpinSlider(parent=editor)
            slider.set3(min_, val, max_)
            slider.setText(text)
            slider.valueChanged.connect(lambda value, idx=index, sid=slidx: self.on_value_changed(value, idx, sid))
            layout.addWidget(slider)
        return editor

    def setEditorData(self, editor, index):
        sliders = index.model().data(index, Qt.EditRole)
        for i, slider in enumerate(editor.findChildren(DoubleSpinSlider)):
            text, min_, val, max_ = sliders[i]
            slider.set3(min_, val, max_)
            slider.setText(text)

    def setModelData(self, editor, model, index):
        sliders = []
        for slider in editor.findChildren(DoubleSpinSlider):
            text = slider.text()
            min_ = slider.minimum()
            val = slider.value()
            max_ = slider.maximum()
            sliders.append((text, min_, val, max_))
        model.setData(index, sliders, Qt.EditRole)

    def on_value_changed(self, value, index, slidx):
        model = index.model()
        sliders = model.data(index, Qt.EditRole)
        sliders[slidx] = (sliders[slidx][0], sliders[slidx][1], value, sliders[slidx][3])
        model.setData(index, sliders, Qt.EditRole)

    def updateEditorGeometry(self, editor, option, index):
        editor.setGeometry(option.rect)

    def sizeHint(self, option, index):
        sliders = index.model().data(index, Qt.EditRole)
        return QSize(100, 40 * len(sliders))

    def paint(self, painter, option, index):
        if sliders := index.model().data(index, Qt.EditRole):
            # print(f"SliderListDelegate:print: {index.row()}, {index.column()} {sliders=}")
            tree = self.parent().tree
            editor = QtWidgets.QWidget(parent=tree)
            editor.setAttribute(Qt.WA_TranslucentBackground)
            layout = QtWidgets.QVBoxLayout(editor)
            layout.setContentsMargins(0, 0, 0, 0)
            for slidx, (text, min_, val, max_) in enumerate(sliders):
                slider = DoubleSpinSlider()
                slider.setRange(min_, max_)
                slider.setValue(val)
                slider.setText(text)
                slider.valueChanged.connect(lambda value, idx=index, sid=slidx: self.on_value_changed(value, idx, sid))
                layout.addWidget(slider)

            tree_top_left = tree.viewport().mapTo(tree, option.rect.topLeft())
            window_top_left = tree.mapTo(tree.window(), tree_top_left)
            # pt = painter.deviceTransform().map(option.rect.topLeft())
            editor.setGeometry(option.rect)
            editor.render(
                painter,
                window_top_left,
                # QRegion(0, 0, option.rect.width(), option.rect.height()),
                # QtWidgets.QWidget.RenderFlag.DrawChildren,
            )
            del editor
        else:
            super().paint(painter, option, index)


if __name__ == "__main__":
    import sys
    from math import nan

    from qgis.gui import QgsDoubleSpinBox  # type: ignore
    from qgis.PyQt.QtWidgets import QApplication  # type: ignore
    from qgis.PyQt.QtWidgets import QDoubleSpinBox  # type: ignore

    app = QApplication(sys.argv)
    spin = QDoubleSpinBox()
    spin.setSpecialValueText("Not set")
    assert spin.specialValueText() == "Not set"
    spin = QgsDoubleSpinBox()
    spin.setClearValue(nan, "Not set")
    spin.clear()
    nan == spin.clearValue()

    dialog = Dialog()
    dialog.show()
    sys.exit(app.exec_())
