# -*- coding: utf-8 -*-

"""
003	2012-08-05
	incorpora le conversioni degli angoli
002	2012-07-30
	si appoggia a numpy
	MatrixTransformation() rinominata in matrixTransformation()
	versione sperimentale limitata 2D:
	opera sempre in coordinate omogenee.
"""

import math
import numpy as np

def rad2sessag(angRad):
	"""
		Converte i gradi radianti in sessagesimali
	"""
	a = angRad * 180.0 / math.pi
	if a < 0:
		a = a + 360
	return a

def sessag2rad(angSess):
	"""
		Converte i gradi sessagesimali in radianti
	"""
	a = angSess * math.pi / 180.0
	if a < 0:
		a = a + 2*math.pi
	return a

def translation(dx,dy):
	"""
		Calcola la matrice di traslazione;
	"""
	return np.array([[1.,0.,dx],[0.,1.,dy],[0.,0.,1.]],dtype='f')

def scale(sx,sy):
	"""
		Calcola la matrice di scala.
	"""
	return np.array([[sx,0.,0.],[0.,sy,0.],[0.,0.,1.]],dtype='f')

def rotation(a):
	"""
		rotazione dell'angolo a [radians]
	"""
	c= math.cos(a)
	s = math.sin(a)
	return np.array([[c,-s,0.],[s,c,0.],[0.,0.,1.]],dtype='f')

