# -*- coding: utf-8 -*-

"""
000	2012-08-04
"""

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *

# Import custom libraries
from cad4qgis_core import *

class pLine4qgisItemsSelectDlg(QDialog):	#QtGui.
	"""
		Dialogo per la selezione di elementi di poliline (edges4qgis):
		seleziona:
			polylines
			edges
			vertices

		presuppone che il parente abbia queste risorse:
			self.parent.clickTool
			self.parent.isClickToolActivated
			self.parent.selectList
			self.parent.markerList
	"""

	def __init__(self,parent,type,msg=''):
		""" Inizializza la maschera di selezione """

		self.parent = parent
		self.type = type

		QDialog.__init__(self)	#QtGui.
		self.setObjectName("Dialog")
		self.resize(220, 110)
		self.setWindowTitle('Select '+type)

		if msg != '':
			lab = QLabel(self)	#QtGui.
			lab.setGeometry(QRect(10, 10, 200, 30))	#QtCore.
			lab.setText(msg)

		self.items = QLabel(self)	#QtGui.
		self.items.setGeometry(QRect(10, 40, 200, 30))	#QtCore.

		buttonBox = QDialogButtonBox(self)	#QtGui.
		buttonBox.setGeometry(QRect(50, 80, 100, 20))	#QtCore.
		buttonBox.setOrientation(Qt.Horizontal)	#QtCore.
		buttonBox.setStandardButtons(QDialogButtonBox.Cancel|QDialogButtonBox.Ok)	#QtGui.,QtGui.
		buttonBox.setObjectName("buttonBox")

		QObject.connect(buttonBox, SIGNAL("accepted()"), self.accept)	#QtCore.,QtCore.
		QObject.connect(buttonBox, SIGNAL("rejected()"), self.reject)	#QtCore.,QtCore.
		QMetaObject.connectSlotsByName(self)	#QtCore.

		self.clear()

		# try to disconnect previous signals
		if self.parent.isClickToolActivated:
			self.parent.clickTool.canvasClicked.disconnect()
			self.parent.isClickToolActivated = False
		# connect to click signal
		QObject.connect(
			self.parent.clickTool,
			SIGNAL("canvasClicked(const QgsPoint &, Qt::MouseButton)"),
			self.appendSel
		)
		self.parent.isClickToolActivated = True

	def clear(self):
		self.parent.selectList = []
		self.items.setText('item: ')

	def appendSel(self,point):
		"""
			Aggiunge il selezionato;
		"""
		searchPline(self.parent,point)
		feat = QgsFeature()
		self.parent.cLayer.nextFeature(feat)
		if feat.isValid():
			fid = feat.id()
			# salva il contenuto di self.items
			oldText = self.items.text()
			if self.type == 'line':
				self.parent.selectList.append(feat)
				fM = pLineHighlight(self.parent.canvas,feat)
				self.parent.markerList.append(fM)
				self.items.setText(tmp + ' %d' % (fid))	# non deve essere oldText?
			elif self.type == 'edge':
				tmp = searchPlineEdge(feat,point,self.parent.eps)
				if len(tmp) == 2:
					eid,[p1,p2] = tmp
					self.parent.selectList.append([p1,p2])
					eM = edgeHighlight(self.parent.canvas,p1,p2)
					self.parent.markerList.append(eM)
					newText = ' %d:%d' % (fid,eid)
					self.items.setText(oldText + newText)
			elif self.type == 'vertex':
				tmp = searchPlineVertex(feat,point,self.parent.eps)
				if len(tmp) == 2:
					vid,p = tmp
					self.parent.selectList.append(p)
					m = pntHighlight(self.parent.canvas,p.x(),p.y())
					self.parent.markerList.append(m)
					tmp = self.items.text()
					self.items.setText(tmp + ' %d:%d' % (fid,vid))	# non deve essere oldText?

