# -*- coding: utf-8 -*-

"""
000	2012-08-01
"""

# Import standard libraries
import os

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *

prefix_icons = os.environ['PWD']+'/.qgis/python/plugins/cad4qgisLati/Icons/'

class pLine4qgisUi(QDialog):	#QtGui.
	"""
		Dialogo per edges4qgis
	"""

	def __init__(self):
		""" Inizializza la maschera per l'editing """
		QDialog.__init__(self)	#QtGui.
		self.setObjectName("Dialog")
		self.resize(220, 660)
		self.setWindowTitle('Cad for qGis')

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 10, 200, 20))	#QtCore.
		lbl.setText('GENERAL')

		self.lay = QLabel(self)	#QtGui.
		self.lay.setGeometry(QRect(10, 30, 100, 20))	#QtCore.
		self.lay.setText('')

		self.lay_edit = QLabel(self)	#QtGui.
		self.lay_edit.setGeometry(QRect(110, 30, 100, 20))	#QtCore.
		self.lay_edit.setText('')

		self.prov = QLabel(self)	#QtGui.
		self.prov.setGeometry(QRect(10, 50, 200, 20))	#QtCore.
		self.prov.setText('')

		self.crs = QLabel(self)	#QtGui.
		self.crs.setGeometry(QRect(10, 70, 200, 20))	#QtCore.
		self.crs.setText('CRS ')

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 90, 200, 20))	#QtCore.
		lbl.setText('items ')

		self.sbNumPnts = QSpinBox(self)	#QtGui.
		self.sbNumPnts.setMinimum(4)
		self.sbNumPnts.setMaximum(100)
		self.sbNumPnts.setGeometry(QRect(70, 90, 100, 20))	#QtCore.
		self.sbNumPnts.setValue(10)

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 110, 200, 20))	#QtCore.
		lbl.setText('INQUIRY	')

		self.pbInqLine = QPushButton(self)	#QtGui.
		self.pbInqLine.setIcon(QIcon(prefix_icons+"actionPolyInq.png"))	#QtGui.
		self.pbInqLine.setGeometry(QRect(10, 130, 20, 20))	#QtCore.
#		self.pbInqLine.setText('Line inquiring')
		self.pbInqLine.setToolTip("Line inquiring")

		self.pbInqEdge = QPushButton(self)	#QtGui.
		self.pbInqEdge.setIcon(QIcon(prefix_icons+"actionEdgeInq.png"))	#QtGui.
		self.pbInqEdge.setGeometry(QRect(40, 130, 20, 20))	#QtCore.
#		self.pbInqEdge.setText('Edge inquiring')
		self.pbInqEdge.setToolTip("Edge inquiring")

		self.pbInqVertex = QPushButton(self)	#QtGui.
		self.pbInqVertex.setIcon(QIcon(prefix_icons+"actionVertexInq.png"))	#QtGui.
		self.pbInqVertex.setGeometry(QRect(70, 130, 20, 20))	#QtCore.
#		self.pbInqVertex.setText('Vertex inquiring')
		self.pbInqVertex.setToolTip("Vertex inquiring")

		self.pbLineLength = QPushButton(self)	#QtGui.
		self.pbLineLength.setIcon(QIcon(prefix_icons+"actionpbVerticesDiag.png"))	#QtGui.
		self.pbLineLength.setGeometry(QRect(100, 130, 20, 20))	#QtCore.
#		self.pbLineLength.setText('Polyline length')
		self.pbLineLength.setToolTip("Polyline length")

		self.pbVerticesDiag = QPushButton(self)	#QtGui.
		self.pbVerticesDiag.setIcon(QIcon(prefix_icons+"actionpbVerticesDiag.png"))	#QtGui.
		self.pbVerticesDiag.setGeometry(QRect(130, 130, 20, 20))	#QtCore.
#		self.pbVerticesDiag.setText('Looking for duplicated vertices')
		self.pbVerticesDiag.setToolTip("Looking for duplicated vertices")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 150, 200, 20))	#QtCore.
		lbl.setText('COSTRUCTION')

		self.pbLineAdd = QPushButton(self)	#QtGui.
		self.pbLineAdd.setIcon(QIcon(prefix_icons+"actionPntAddByMouse.png"))	#QtGui.
		self.pbLineAdd.setGeometry(QRect(10, 170, 20, 20))	#QtCore.
#		self.pbLineAdd.setText('Line Adding')
		self.pbLineAdd.setToolTip("Line adding")

		self.pbLineOffset = QPushButton(self)	#QtGui.
		self.pbLineOffset.setIcon(QIcon(prefix_icons+"actionPlineOffset.png"))	#QtGui.
		self.pbLineOffset.setGeometry(QRect(40, 170, 20, 20))	#QtCore.
#		self.pbLineOffset.setText('Line offset')
		self.pbLineOffset.setToolTip("Line offset")

		self.pbLineRectSeries = QPushButton(self)	#QtGui.
		self.pbLineRectSeries.setIcon(QIcon(prefix_icons+"actionPntRectSeries.png"))	#QtGui.
		self.pbLineRectSeries.setGeometry(QRect(70, 170, 20, 20))	#QtCore.
#		self.pbLineRectSeries.setText('Rectangular series of Lines')
		self.pbLineRectSeries.setToolTip("Rectangular series of Lines")

		self.pbLinePolarSeries = QPushButton(self)	#QtGui.
		self.pbLinePolarSeries.setIcon(QIcon(prefix_icons+"actionPntPolarSeries.png"))	#QtGui.
		self.pbLinePolarSeries.setGeometry(QRect(100, 170, 20, 20))	#QtCore.
#		self.pbLinePolarSeries.setText('Polar series of Lines')
		self.pbLinePolarSeries.setToolTip("Polar series of Lines")

		self.pbLineAxialMirror = QPushButton(self)	#QtGui.
		self.pbLineAxialMirror.setIcon(QIcon(prefix_icons+"actionPntAxialMirror.png"))	#QtGui.
		self.pbLineAxialMirror.setGeometry(QRect(130, 170, 20, 20))	#QtCore.
#		self.pbLineAxialMirror.setText('Axial symmetry of Lines')
		self.pbLineAxialMirror.setToolTip("Axial symmetry of Lines")

		self.pbLineRadialMirror = QPushButton(self)	#QtGui.
		self.pbLineRadialMirror.setIcon(QIcon(prefix_icons+"actionPntRadialMirror.png"))	#QtGui.
		self.pbLineRadialMirror.setGeometry(QRect(160, 170, 20, 20))	#QtCore.
#		self.pbLineRadialMirror.setText('Radial symmetry of Lines')
		self.pbLineRadialMirror.setToolTip("Radial symmetry of Lines")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 190, 200, 20))	#QtCore.
		lbl.setText('QUADRATIC INTERPOLATION (CIRCLE)')

		self.pbLineRegPolyg = QPushButton(self)	#QtGui.
		self.pbLineRegPolyg.setIcon(QIcon(prefix_icons+"actionPntRegPolyg.png"))	#QtGui.
		self.pbLineRegPolyg.setGeometry(QRect(10, 210, 20, 20))	#QtCore.
#		self.pbLineRegPolyg.setText('Regular polygon On/Off')
		self.pbLineRegPolyg.setToolTip("Regular polygon")

		self.pbLineCircle2P = QPushButton(self)	#QtGui.
		self.pbLineCircle2P.setIcon(QIcon(prefix_icons+"actionPntCircle2P.png"))	#QtGui.
		self.pbLineCircle2P.setGeometry(QRect(40, 210, 20, 20))	#QtCore.
#		self.pbLineCircle2P.setText('2 points circle On/Off')
		self.pbLineCircle2P.setToolTip("2 points circle")

		self.pbLineCircleInCbyP = QPushButton(self)	#QtGui.
		self.pbLineCircleInCbyP.setIcon(QIcon(prefix_icons+"actionPntCircleInCbyP.png"))	#QtGui.
		self.pbLineCircleInCbyP.setGeometry(QRect(70, 210, 20, 20))	#QtCore.
#		self.pbLineCircleInCbyP.setText('Circle in C by P On/Off')
		self.pbLineCircleInCbyP.setToolTip("Circle in C by P")

		self.pbLineCircle3P = QPushButton(self)	#QtGui.
		self.pbLineCircle3P.setIcon(QIcon(prefix_icons+"actionPntCircle3P.png"))	#QtGui.
		self.pbLineCircle3P.setGeometry(QRect(100, 210, 20, 20))	#QtCore.
#		self.pbLineCircle3P.setText('Cerchio per 3 punti On/Off')
		self.pbLineCircle3P.setToolTip("3 points circle")

		self.pbLineArc = QPushButton(self)	#QtGui.
		self.pbLineArc.setIcon(QIcon(prefix_icons+"actionPntArc.png"))	#QtGui.
		self.pbLineArc.setGeometry(QRect(10, 230, 20, 20))	#QtCore.
#		self.pbLineArc.setText('Points arc On/Off')
		self.pbLineArc.setToolTip("Points arc")

		self.pbLineArc3P = QPushButton(self)	#QtGui.
		self.pbLineArc3P.setIcon(QIcon(prefix_icons+"actionPntArc3P.png"))	#QtGui.
		self.pbLineArc3P.setGeometry(QRect(40, 230, 20, 20))	#QtCore.
#		self.pbLineArc3P.setText('3 points arc On/Off')
		self.pbLineArc3P.setToolTip("3 points arc")

		self.pbLineParabola1 = QPushButton(self)	#QtGui.
		self.pbLineParabola1.setIcon(QIcon(prefix_icons+"actionPntParabola1.png"))	#QtGui.
		self.pbLineParabola1.setGeometry(QRect(10, 250, 20, 20))	#QtCore.
#		self.pbLineParabola1.setText('Parabolic points 1 On/Off')
		self.pbLineParabola1.setToolTip("Parabolic points 1")

		self.pbLineParabola2 = QPushButton(self)	#QtGui.
		self.pbLineParabola2.setIcon(QIcon(prefix_icons+"actionPntParabola2.png"))	#QtGui.
		self.pbLineParabola2.setGeometry(QRect(40, 250, 20, 20))	#QtCore.
#		self.pbLineParabola2.setText('Parabolic points 2 On/Off')
		self.pbLineParabola2.setToolTip("Parabolic points 2")

		self.pbLineParabola3 = QPushButton(self)	#QtGui.
		self.pbLineParabola3.setIcon(QIcon(prefix_icons+"actionPntParabola3.png"))	#QtGui.
		self.pbLineParabola3.setGeometry(QRect(70, 250, 20, 20))	#QtCore.
#		self.pbLineParabola3.setText('Parabolic points 3 On/Off')
		self.pbLineParabola3.setToolTip("Parabolic points 3")

		self.pbLineParabola4 = QPushButton(self)	#QtGui.
		self.pbLineParabola4.setIcon(QIcon(prefix_icons+"actionPntParabola4.png"))	#QtGui.
		self.pbLineParabola4.setGeometry(QRect(100, 250, 20, 20))	#QtCore.
#		self.pbLineParabola4.setText('Parabolic points 3 On/Off')
		self.pbLineParabola4.setToolTip("Parabolic points 4")

		self.pbLineEllisse = QPushButton(self)	#QtGui.
		self.pbLineEllisse.setIcon(QIcon(prefix_icons+"actionPntEllisse.png"))	#QtGui.
		self.pbLineEllisse.setGeometry(QRect(10, 270, 20, 20))	#QtCore.
#		self.pbLineEllisse.setText('Ellipsys')
		self.pbLineEllisse.setToolTip("Ellipsys")

		self.pbLineEllisseByP = QPushButton(self)	#QtGui.
		self.pbLineEllisseByP.setIcon(QIcon(prefix_icons+"actionPntEllisseByP.png"))	#QtGui.
		self.pbLineEllisseByP.setGeometry(QRect(40, 270, 20, 20))	#QtCore.
#		self.pbLineEllisseByP.setText('Ellipsys by P')
		self.pbLineEllisseByP.setToolTip("Ellipsys by P")

		self.pbLineDel = QPushButton(self)	#QtGui.
		self.pbLineDel.setIcon(QIcon(prefix_icons+"actionPntDel.png"))	#QtGui.
		self.pbLineDel.setGeometry(QRect(130, 270, 20, 20))	#QtCore.
#		self.pbLineDel.setText('Line deleting')
		self.pbLineDel.setToolTip("Line deleting")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 290, 200, 20))	#QtCore.
		lbl.setText('CUBIC INTERPOLATION')

		self.pbLineHermite = QPushButton(self)	#QtGui.
		self.pbLineHermite.setIcon(QIcon(prefix_icons+"actionPntHermite.png"))	#QtGui.
		self.pbLineHermite.setGeometry(QRect(10, 310, 20, 20))	#QtCore.
#		self.pbLineHermite.setText('Hermite curve On/Off')
		self.pbLineHermite.setToolTip("Hermite curve")

		self.pbLineBezier = QPushButton(self)	#QtGui.
		self.pbLineBezier.setIcon(QIcon(prefix_icons+"actionPntBezier.png"))	#QtGui.
		self.pbLineBezier.setGeometry(QRect(40, 310, 20, 20))	#QtCore.
#		self.pbLineBezier.setText('Bezier curve On/Off')
		self.pbLineBezier.setToolTip("Bezier curve")

		self.pbLineUnRspline = QPushButton(self)	#QtGui.
		self.pbLineUnRspline.setIcon(QIcon(prefix_icons+"actionPntUNRBS.png"))	#QtGui.
		self.pbLineUnRspline.setGeometry(QRect(70, 310, 20, 20))	#QtCore.
#		self.pbLineUnRspline.setText('Uniform nonRational spline On/Off')
		self.pbLineUnRspline.setToolTip("Uniform nonRational spline")

		self.pbLineOverhauser = QPushButton(self)	#QtGui.
		self.pbLineOverhauser.setIcon(QIcon(prefix_icons+"actionPntOverhauser.png"))	#QtGui.
		self.pbLineOverhauser.setGeometry(QRect(100, 310, 20, 20))	#QtCore.
#		self.pbLineOverhauser.setText('Overhauser spline On/Off')
		self.pbLineOverhauser.setToolTip("Overhauser spline")

		self.pbLineBetaSpline = QPushButton(self)	#QtGui.
		self.pbLineBetaSpline.setIcon(QIcon(prefix_icons+"actionPntBetaSpline.png"))	#QtGui.
		self.pbLineBetaSpline.setGeometry(QRect(130, 310, 20, 20))	#QtCore.
#		self.pbLineBetaSpline.setText('Interpolazione cubica BetaSpline On/Off')
		self.pbLineBetaSpline.setToolTip("Beta spline")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 330, 200, 20))	#QtCore.
		lbl.setText('GENERIC INTERPOLATION')

		self.pbLineInterpolation = QPushButton(self)	#QtGui.
		self.pbLineInterpolation.setIcon(QIcon(prefix_icons+"actionPntPolyInt1.png"))	#QtGui.
		self.pbLineInterpolation.setGeometry(QRect(10, 350, 20, 20))	#QtCore.
#		self.pbLineInterpolation.setText('Polynomial Interpolation')
		self.pbLineInterpolation.setToolTip("Polynomial Interpolation")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 370, 200, 20))	#QtCore.
		lbl.setText('EDITING')

		self.pbLineVrtsEditMouse = QPushButton(self)	#QtGui.
		self.pbLineVrtsEditMouse.setIcon(QIcon(prefix_icons+"actionLineVrtsEditMouse.png"))	#QtGui.
		self.pbLineVrtsEditMouse.setGeometry(QRect(10, 390, 20, 20))	#QtCore.
#		self.pbLineVrtsEditMouse.setText('Analogic editing pLine vertices')
		self.pbLineVrtsEditMouse.setToolTip("Analogic editing pLine vertice")

		self.pbLineVrtsEdit = QPushButton(self)	#QtGui.
		self.pbLineVrtsEdit.setIcon(QIcon(prefix_icons+"actionLineVrtsEdit.png"))	#QtGui.
		self.pbLineVrtsEdit.setGeometry(QRect(40, 390, 20, 20))	#QtCore.
#		self.pbLineVrtsEdit.setText('Line vertices editing')
		self.pbLineVrtsEdit.setToolTip("Line vertices editing")

		self.pbLineOpenClose = QPushButton(self)	#QtGui.
		self.pbLineOpenClose.setIcon(QIcon(prefix_icons+"actionbLineOpenClose.png"))	#QtGui.
		self.pbLineOpenClose.setGeometry(QRect(100, 390, 20, 20))	#QtCore.
#		self.pbLineOpenClose.setText('Open/Close polylines')
		self.pbLineOpenClose.setToolTip("Open/Close polylines")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 410, 200, 20))	#QtCore.
		lbl.setText('INTERSECTION')

		self.pbLineIntersect = QPushButton(self)	#QtGui.
		self.pbLineIntersect.setIcon(QIcon(prefix_icons+"actionLineIntersection.png"))	#QtGui.
		self.pbLineIntersect.setGeometry(QRect(10, 430, 20, 20))	#QtCore.
#		self.pbLineIntersect.setText('Analogic editing pLine vertices')
		self.pbLineIntersect.setToolTip("Analogic editing pLine vertice")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 450, 200, 20))	#QtCore.
		lbl.setText('UNION & SPLITTING')

		self.pbLineUnion = QPushButton(self)	#QtGui.
		self.pbLineUnion.setIcon(QIcon(prefix_icons+"actionLineUnion.png"))	#QtGui.
		self.pbLineUnion.setGeometry(QRect(10, 470, 20, 20))	#QtCore.
#		self.pbLineUnion.setText('Line union')
		self.pbLineUnion.setToolTip("Line union")

		self.pbLineSplit = QPushButton(self)	#QtGui.
		self.pbLineSplit.setIcon(QIcon(prefix_icons+"actionLineSplit.png"))	#QtGui.
		self.pbLineSplit.setGeometry(QRect(40, 470, 20, 20))	#QtCore.
#		self.pbLineSplit.setText('Splitting of edges')
		self.pbLineSplit.setToolTip("Line splitting")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 490, 200, 20))	#QtCore.
		lbl.setText('FILLET/CHAMFER')

		self.pbLineFillet = QPushButton(self)	#QtGui.
		self.pbLineFillet.setIcon(QIcon(prefix_icons+"actionLineFillet.png"))	#QtGui.
		self.pbLineFillet.setGeometry(QRect(10, 510, 20, 20))	#QtCore.
#		self.pbLineFillet.setText('Intersection of 4 Lines On/Off')
		self.pbLineFillet.setToolTip("Lines fillet")

		self.pbLineChamfer = QPushButton(self)	#QtGui.
		self.pbLineChamfer.setIcon(QIcon(prefix_icons+"actionLineChamfer.png"))	#QtGui.
		self.pbLineChamfer.setGeometry(QRect(40, 510, 20, 20))	#QtCore.
#		self.pbLineChamfer.setText('Intersection of 4 Lines On/Off')
		self.pbLineChamfer.setToolTip("Lines chamfer")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 530, 200, 20))	#QtCore.
		lbl.setText('TRANSFORMATIONS')

		self.pbLineTranslation = QPushButton(self)	#QtGui.
		self.pbLineTranslation.setIcon(QIcon(prefix_icons+"actionPntTranslation.png"))	#QtGui.
		self.pbLineTranslation.setGeometry(QRect(10, 550, 20, 20))	#QtCore.
#		self.pbLineTranslation.setText('Line translation')
		self.pbLineTranslation.setToolTip("Line translation")

		self.pbLineScaling = QPushButton(self)	#QtGui.
		self.pbLineScaling.setIcon(QIcon(prefix_icons+"actionPntScaling.png"))	#QtGui.
		self.pbLineScaling.setGeometry(QRect(40, 550, 20, 20))	#QtCore.
#		self.pbLineScaling.setText('Line scaling')
		self.pbLineScaling.setToolTip("Line scaling")

		self.pbLineRotation = QPushButton(self)	#QtGui.
		self.pbLineRotation.setIcon(QIcon(prefix_icons+"actionPntRotation.png"))	#QtGui.
		self.pbLineRotation.setGeometry(QRect(70, 550, 20, 20))	#QtCore.
#		self.pbLineRotation.setText('Line rotation')
		self.pbLineRotation.setToolTip("Line rotation")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 570, 200, 20))	#QtCore.
		lbl.setText('COLLIMATIONS')

		self.pbLineCollimation1P = QPushButton(self)	#QtGui.
		self.pbLineCollimation1P.setIcon(QIcon(prefix_icons+"actionPntCollimation1P.png"))	#QtGui.
		self.pbLineCollimation1P.setGeometry(QRect(10, 590, 20, 20))	#QtCore.
#		self.pbLineCollimation1P.setText('1 pair collimation')
		self.pbLineCollimation1P.setToolTip("1 pair collimation")

		self.pbLineCollimation2P = QPushButton(self)	#QtGui.
		self.pbLineCollimation2P.setIcon(QIcon(prefix_icons+"actionPntCollimation2P.png"))	#QtGui.
		self.pbLineCollimation2P.setGeometry(QRect(40, 590, 20, 20))	#QtCore.
#		self.pbLineCollimation2P.setText('Two pairs collimation')
		self.pbLineCollimation2P.setToolTip("Two pairs collimation")

		self.pbLineCollimationNP = QPushButton(self)	#QtGui.
		self.pbLineCollimationNP.setIcon(QIcon(prefix_icons+"actionPntCollimationNP.png"))	#QtGui.
		self.pbLineCollimationNP.setGeometry(QRect(70, 590, 20, 20))	#QtCore.
#		self.pbLineCollimationNP.setText('Collimation with N pairs')
		self.pbLineCollimationNP.setToolTip("Collimation with N pairs")

		lbl = QLabel(self)	#QtGui.
		lbl.setGeometry(QRect(10, 610, 200, 20))	#QtCore.
		lbl.setText('HELP')

		self.pbAbout = QPushButton(self)	#QtGui.
		self.pbAbout.setIcon(QIcon(prefix_icons+"buttonAbout.png"))	#QtGui.
		self.pbAbout.setGeometry(QRect(10, 630, 20, 20))	#QtCore.
#		self.pbAbout.setText('About')
		self.pbAbout.setToolTip("About")

		self.pbInfo = QPushButton(self)	#QtGui.
		self.pbInfo.setIcon(QIcon(prefix_icons+"buttonInfo.png"))	#QtGui.
		self.pbInfo.setGeometry(QRect(40, 630, 20, 20))	#QtCore.
#		self.pbInfo.setText('Info')
		self.pbInfo.setToolTip("Info")

		self.pbHelpFlag = QPushButton(self)	#QtGui.
		self.pbHelpFlag.setIcon(QIcon(prefix_icons+"buttonHelpFlag.png"))	#QtGui.
		self.pbHelpFlag.setGeometry(QRect(70, 630, 20, 20))	#QtCore.
#		self.pbHelpFlag.setText('Help flag')
# non so come mai questa istruzione crea errore		self.pbHelpFlag.setToolTip("Help")‎

		buttonBox = QDialogButtonBox(self)	#QtGui.
		buttonBox.setGeometry(QRect(100, 630, 100, 20))	#QtCore.
		buttonBox.setOrientation(Qt.Horizontal)	#QtCore.
		buttonBox.setStandardButtons(QDialogButtonBox.Cancel)	#QtGui.,QtGui.
		buttonBox.setObjectName("buttonBox")

		QObject.connect(buttonBox, SIGNAL("rejected()"), self.reject)	#QtCore.,QtCore.
		QMetaObject.connectSlotsByName(self)	#QtCore.

	def setLayer(self,layName,layEdit,prName,scrs):
		""" Setta il layer + provider  """
		self.lay.setText('layer     '+layName)
		self.lay_edit.setText(layEdit)
		self.prov.setText('provider '+prName)
		self.crs.setText('CRS: '+scrs)

	def setLayerEdit(self,layEdit):
		""" Setta il layer + provider  """
		self.lay_edit.setText(layEdit)

	def getNumPnts(self):
		""" Restituisce il numero di punti delle nuove primitive  """
		return self.sbNumPnts.value()

	def clear(self):
		""" Azzera tutto """
		self.lay.setText('layer ')
		self.prov.setText('provider ')
		self.numPnts.setText("10")
