# -*- coding: utf-8 -*-
"""
/***************************************************************************
 P190ImportDialog
		                         A QGIS plugin
 Read UKOOA P1/90 files
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
		                     -------------------
		begin                : 2019-05-17
		git sha              : $Format:%H$
		copyright            : (C) 2019 by Aaltronav s.r.o.
		email                : devel@aaltronav.eu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets
from qgis.gui import QgsProjectionSelectionDialog

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
	os.path.dirname(__file__), 'p190_import_dialog_base.ui'))


class P190ImportDialog(QtWidgets.QDialog, FORM_CLASS):
	def __init__(self, parent=None):
		"""Constructor."""
		super(P190ImportDialog, self).__init__(parent)
		# Set up the user interface from Designer through FORM_CLASS.
		# After self.setupUi() you can access any designer object by doing
		# self.<objectname>, and you can use autoconnect slots - see
		# http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
		# #widgets-and-dialogs-with-auto-connect
		self.setupUi(self)
		self.crsDialog = QgsProjectionSelectionDialog()
		
		self.browseButton.clicked.connect(self.select_file)
		self.fileEdit.textChanged.connect(self.validate)
		self.crsButton.clicked.connect(self.crsDialog.show)
		self.crsDialog.accepted.connect(self.select_crs)
		self.crs = None
		self.record_types = { r for r in "SGQATCVEZ" } # Must match initial dialog state
		self.validate()
		
	def select_file(self):
		filename, _filter = QtWidgets.QFileDialog.getOpenFileName(self, "Open P1/90 file", "", "P1/90 Files (*.p190 *.P190 *.p1 *.P1, *.190)")
		self.fileEdit.setText(filename)
		
	def select_crs(self):
		self.crs = self.crsDialog.crs()
		if self.crs:
			self.crsName.setText(self.crs.description())
		self.validate()
		
	def set_record_types(self, state):
		key = self.sender().objectName()[-1]
		if state:
			self.record_types.add(key)
		else:
			self.record_types.remove(key)

	def accept_enabled(self, state):
		self.button_box.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(state)

	def validate(self):
		if len(self.fileEdit.text()) > 0 and (self.crs or self.geographicalCrs.isChecked()):
			self.accept_enabled(True)
		else:
			self.accept_enabled(False)
