# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OtsusMethod
                                 A QGIS plugin
 This plugin applies Otsu's method for automated thresholding and segmentation of raster data.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-12
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Florian J. Ellsäßer
        email                : f.j.ellsaesser@utwente.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from .otsusmethod_dialog import OtsusMethodDialog
import os.path

class OtsusMethod:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor: initializes the plugin, interface, and locale settings."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', 'OtsusMethod_{}.qm'.format(locale))
        
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&OtsusMethod')
        self.first_start = None

    def tr(self, message):
        """Get the translation for a string using Qt translation API."""
        return QCoreApplication.translate('OtsusMethod', message)

    def add_action(
        self, icon_path, text, callback, enabled_flag=True, add_to_menu=True, 
        add_to_toolbar=True, status_tip=None, whats_this=None, parent=None):
        """Add a toolbar icon to the toolbar and QGIS menu."""
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)
        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        plugin_dir = os.path.dirname(__file__)
        icon_path = os.path.join(plugin_dir, 'icon.png')
        self.add_action(
            icon_path,
            text=self.tr(u"Otsu's Method for Thresholding and Segmentation"),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&OtsusMethod'), action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method: starts the plugin dialog and executes Otsu's thresholding if confirmed."""
        if self.first_start == True:
            self.first_start = False
            self.dlg = OtsusMethodDialog()
        
        self.dlg.show()
        result = self.dlg.exec_()

        if result:
            self.dlg.apply_otsu_thresholding()