# -*- coding: utf-8 -*-
"""
/***************************************************************************
 sidewalkreator
                                 A QGIS plugin
 Plugin conceived to create the Geometries of Sidewalks (separated from streets) based on OpenStreetMap Streets, given a bounding polygon, outputting to JOSM format. It is mostly intended for acessibility Mapping. 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-09-29
        copyright            : (C) 2021 by Kaue de Moraes Vestena
        email                : kauemv2@gmail.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load sidewalkreator class from file sidewalkreator.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    # Import the main plugin class
    from .osm_sidewalkreator import sidewalkreator

    # Return an instance of the main plugin class.
    # Provider registration is now handled within sidewalkreator.initGui()
    return sidewalkreator(iface)

def _build_plugin_paths(profile_path):
    """Backwards-compat helper for tests: compute plugin directories.

    This duplicate keeps imports side-effect free during test collection.
    The canonical implementation lives in osm_sidewalkreator.py.
    """
    import os

    profile_path = os.path.normpath(profile_path)
    basepath = os.path.join(
        profile_path, "python", "plugins", "osm_sidewalkreator"
    )
    temps_path = os.path.join(basepath, "temporary")
    reports_path = os.path.join(basepath, "reports")
    assets_path = os.path.join(basepath, "assets")
    return basepath, temps_path, reports_path, assets_path
