# -*- coding: utf-8 -*-

"""
/***************************************************************************
Osm Map Matching
                                 A QGIS plugin
 Plugin che fa qualche cosa
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-07-26
        copyright            : (C) 2023 by G.Rossi
        email                : grossi@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Gianluca Rossi'
__date__ = '2023-07-26'
__copyright__ = '(C) 2023 by G.Rossi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsApplication
from .osm_map_matching_provider import OsmMapMatchingProvider

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

import processing

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class OsmMapMatchingPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = OsmMapMatchingProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        iconname = os.path.join(os.path.dirname(__file__), 'icon.png')
        self.action = QAction(QIcon(iconname),u"Analyze", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addPluginToMenu(u"OSM Map Matching", self.action )
        self.iface.addToolBarIcon(self.action)
        
    def run(self):
        processing.execAlgorithmDialog("Osm Map Matching:Analyze")
        
    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        
        self.iface.removePluginMenu(u"OSM Map Matching", self.action)
        self.iface.removeToolBarIcon(self.action)

