# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Osm2TopoMap
                                 A QGIS plugin
 A plugin intended to intermediate the process of using OSM data for official (authoritative) Topographc Maps, or rather, databases
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-06-14
        copyright            : (C) 2023 by Leonardo Scharth; Kauê Vestena; Silvana Camboim
        email                : scharth.leo@gmail.com 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Leonardo Scharth; Kauê Vestena; Silvana Camboim'
__date__ = '2023-06-14'
__copyright__ = '(C) 2023 by Leonardo Scharth; Kauê Vestena; Silvana Camboim'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .osm_2_topomap_provider import Osm2TopoMapProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class Osm2TopoMapPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = Osm2TopoMapProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
