# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Osm2TopoMap
                                 A QGIS plugin
 A plugin intended to intermediate the process of using OSM data for official (authoritative) Topographc Maps, or rather, databases
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-06-14
        copyright            : (C) 2023 by Leonardo Scharth; Kauê Vestena; Silvana Camboim
        email                : scharth.leo@gmail.com 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Leonardo Scharth; Kauê Vestena; Silvana Camboim'
__date__ = '2023-06-14'
__copyright__ = '(C) 2023 by Leonardo Scharth; Kauê Vestena; Silvana Camboim'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider, QgsApplication
# from .osm_2_topomap_algorithm import Osm2TopoMapAlgorithm
from .o2m_algorithms.fluxo_1_grupos_transformadores_p import Transformadores
from .o2m_algorithms.fluxo_2_campo_quadra_p import Quadra
from .o2m_algorithms.fluxo_3_edif_saude_p import Saude
from .o2m_algorithms.fluxo_4_posto_pol_rod_p import Policia_rodoviaria
from .o2m_algorithms.fluxo_5_6_7_relevo_pico_morro_praia_p_a import RelevoFisiograficoNatural 
from .o2m_algorithms.fluxo_8_heliponto_p import Heliponto
from .o2m_algorithms.fluxo_9_posto_gasolina_p import PostoDeGasolina
from .o2m_algorithms.fluxo_10_aerogerador_p import Aerogerador
from .o2m_algorithms.fluxo_11_edif_policia_p import Policia
from .o2m_algorithms.fluxo_12_praca_a import Praca
from .o2m_algorithms.fluxo_13_14_via_deslocamento_l import ViaDeslocamento
from .o2m_algorithms.fluxo_15_trecho_energia_l import PowerLine

from qgis.PyQt.QtGui import QIcon
from . import resources

from os.path import join

class Osm2TopoMapProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        # self.addAlgorithm(Osm2TopoMapAlgorithm())

        self.addAlgorithm(Transformadores())
        self.addAlgorithm(Quadra())
        self.addAlgorithm(Saude())
        self.addAlgorithm(Policia_rodoviaria())
        self.addAlgorithm(RelevoFisiograficoNatural())
        self.addAlgorithm(Heliponto())
        self.addAlgorithm(PostoDeGasolina())
        self.addAlgorithm(Aerogerador())
        self.addAlgorithm(Policia())
        self.addAlgorithm(Praca())
        self.addAlgorithm(ViaDeslocamento())
        self.addAlgorithm(PowerLine())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'osm2topomap'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('osm2topomap')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        # return QIcon(':/plugins/osm2topomap/icon.png')
        profilepath = QgsApplication.qgisSettingsDirPath()
        icon_rel_path = 'python/plugins/osm2topomap/icon.svg'
        icon_path = join(profilepath,icon_rel_path)


        return QIcon(icon_path)
        # return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
