#  standard
import json
from dataclasses import dataclass

# PyQGIS
from qgis.PyQt.QtCore import QUrl

# plugin
from oslandia.gitlab_api.custom_exceptions import UnavailableUserException
from oslandia.toolbelt import PlgLogger, PlgOptionsManager
from oslandia.toolbelt.network_manager import NetworkRequestsManager


@dataclass
class User:
    id: str
    username: str
    name: str
    email: str = ""


class UserRequestManager:
    def __init__(self):
        """
        Helper for user request

        """
        self.log = PlgLogger().log
        self.ntwk_requester_blk = NetworkRequestsManager()
        self.plg_settings = PlgOptionsManager.get_plg_settings()

    def get_current_user(self) -> User:
        """
        Get current connected User

        Raise UnavailableUserException if we can't get the current User

        Returns: connected User
        """

        # send request
        req_reply = self.ntwk_requester_blk.get_url(
            QUrl(f"{self.plg_settings.gitlab_api_url_base}user"),
            self.plg_settings.authentification_config_id,
        )
        if req_reply:
            data = json.loads(req_reply.data().decode("utf-8"))
            return User(
                id=data["id"],
                username=data["username"],
                email=data["email"],
                name=data["name"],
            )
        else:
            raise UnavailableUserException("Error while fetching user info")
