from datetime import datetime

from qgis.PyQt.QtCore import QDateTime


def to_qdatetime(val: datetime) -> QDateTime:
    """Transform a python datetime to a QDateTime

    :param val: python datetime
    :type val: datetime
    :return: converted QDateTime
    :rtype: QDateTime
    """
    return QDateTime(
        val.year,
        val.month,
        val.day,
        val.hour,
        val.minute,
        val.second,
        val.microsecond // 1000,  # QDateTime uses milliseconds
    )
