from qgis.PyQt.QtCore import QObject, Qt
from qgis.PyQt.QtGui import QStandardItemModel

from oslandia.gitlab_api.issue import Issues, IssuesRequestManager
from oslandia.toolbelt import PlgLogger


class IssuesListModel(QStandardItemModel):
    DATE_COL = 0
    NAME_COL = 1
    STATE_COL = 2
    DESCRIPTION_COL = 3

    def __init__(self, parent: QObject = None):
        """
        QStandardItemModel for datastore list display

        Args:
            parent: QObject parent
        """
        super().__init__(parent)
        self.log = PlgLogger().log
        self.setHorizontalHeaderLabels(
            [self.tr("date"), self.tr("name"), self.tr("state")]
        )

    def flags(self, index):
        default_flags = super().flags(index)
        return default_flags & ~Qt.ItemIsEditable  # Disable editing

    def set_project(self, project_id: str) -> None:
        """
        Refresh QStandardItemModel data with current project_id members

        """
        self.removeRows(0, self.rowCount())

        manager = IssuesRequestManager()
        issues = manager.get_issues_list(project_id)
        for issue in issues:
            self.insert_issues(issue)

    def insert_issues(self, issues: Issues) -> None:
        """Insert members into model

        :param members: members to insert
        :type members: members

        """
        row = self.rowCount()
        self.insertRow(row)
        self.setData(self.index(row, self.DATE_COL), issues.date)
        self.setData(self.index(row, self.STATE_COL), issues.state)
        self.setData(self.index(row, self.DESCRIPTION_COL), issues.description)

        self.setData(self.index(row, self.NAME_COL), issues.name)
        self.setData(self.index(row, self.NAME_COL), issues, Qt.UserRole)


# class IssueView(QStandardItemModel):
#     NAME_COL = 0
#     DESCRIPTION_COL = 1

#     def __init__(self, parent: QObject = None):
#         """
#         QStandardItemModel for datastore list display

#         Args:
#             parent: QObject parent
#         """
#         super().__init__(parent)
#         self.log = PlgLogger().log
#         self.setHorizontalHeaderLabels(
#             [ self.tr("name"), self.tr("description")]
#         )

#     def flags(self, index):
#         default_flags = super().flags(index)
#         return default_flags & ~Qt.ItemIsEditable  # Disable editing

#     def set_issue(self, project_id: str, issue_id: str) -> None:
#         """
#         Refresh QStandardItemModel data with current project_id members

#         """
#         self.removeRows(0, self.rowCount())

#         manager = IssuesRequestManager()
#         issue = manager.get_issue(project_id, issue_id)
#         self.insert_issues(issue)
#         return issue
#     def insert_issues(self, issues: Issues) -> None:
#         """Insert members into model

#         :param members: members to insert
#         :type members: members

#         """
#         row = self.rowCount()
#         self.insertRow(row)
#         self.setData(self.index(row, self.DESCRIPTION_COL), issues.description)
#         self.setData(self.index(row, self.NAME_COL), issues.name)
#         self.setData(self.index(row, self.NAME_COL), issues, Qt.UserRole)
