"""
Get token api gitlab

"""

# ############################################################################
# ########## Imports ###############
# ##################################


# Standard library
import logging

# PyQGIS
from qgis.PyQt.Qt import QMessageBox, QUrl

# project
from oslandia.toolbelt.log_handler import PlgLogger
from oslandia.toolbelt.network_manager import NetworkRequestsManager
from oslandia.toolbelt.preferences import PlgOptionsManager

# ############################################################################
# ########## Globals ###############
# ##################################

logger = logging.getLogger(__name__)


class RequestApi:
    """
    Class to manage the requests API
    """

    def __init__(self) -> None:
        """

        Initialize the request API
        Sets up the logger, network requester, plugins settings

        """
        self.log = PlgLogger().log
        self.ntwk_requester_blk = NetworkRequestsManager()
        self.plg_settings = PlgOptionsManager.get_plg_settings()

    def get_api_token(self, config_id: str):
        """
        Sends a network request to the API URL to retrieve an API token.

        :param config_id: The configuration ID from the QGIS auth.
        :return: The API token if the request is successful.
        """

        # request URL
        url_api = self.plg_settings.gitlab_api_url_pat
        req_reply = self.ntwk_requester_blk.get_url(QUrl(url_api), config_id)

        if req_reply:
            QMessageBox.information(
                None, "API information", "Successful connection", QMessageBox.Ok
            )
            return req_reply
        else:
            QMessageBox.warning(
                None,
                "API information",
                " FAILED : \n check the authentication config",
                QMessageBox.Ok,
            )
            return None
