#! python3  # noqa: E265

# Standard library
from dataclasses import dataclass
from datetime import datetime
from typing import Optional

# Plugin
from oslandia.toolbelt.qt_utils import localize_qdatetime


@dataclass
class RssItem:
    """Dataclass describing a RSS channel item."""

    abstract: Optional[str] = None
    authors: Optional[list[Optional[str]]] = None
    categories: Optional[list[Optional[str]]] = None
    date_pub: Optional[tuple[int, ...]] = None
    guid: Optional[str] = None
    image_length: Optional[str] = None
    image_type: Optional[str] = None
    image_url: Optional[str] = None
    title: Optional[str] = None
    url: Optional[str] = None

    def get_date(self):
        """
        Date in readable format
        """
        # date_pub contains tzinfo which datetime doesn't need
        date_pub = datetime(*self.date_pub[:6]).date()
        return localize_qdatetime(date_pub)
