from typing import Optional

from qgis.PyQt.QtCore import QModelIndex, QObject, QSortFilterProxyModel, Qt

from oslandia.gui.mdl_members import MembersListModel


class MembersProxyModel(QSortFilterProxyModel):
    def __init__(self, parent: QObject = None):
        """Proxy model for issue

        :param parent: object parent, defaults to None
        :type parent: QObject, optional
        """
        super().__init__(parent)
        self.excluded_assignee: Optional[list[str]] = None

    def set_excluded_assignee(self, excluded_assignee: Optional[list[str]]) -> None:
        """Define excluded assignee that won't be visible

        :param userid: User ID
        :type userid: list
        """
        if self.excluded_assignee != excluded_assignee:
            self.excluded_assignee = excluded_assignee
            self.invalidateFilter()

    def filterAcceptsRow(self, source_row: int, source_parent: QModelIndex) -> bool:
        """
        Filter visible rows for issue

        Args:
            source_row: (int) source row
            source_parent: (QModelIndex) source parent

        Returns: True if row is visible, False otherwise

        """
        result = True
        name_index = self.sourceModel().index(
            source_row, MembersListModel.NAME_COL, source_parent
        )
        member = self.sourceModel().data(name_index, Qt.ItemDataRole.UserRole)

        if self.excluded_assignee and member:
            result &= member.username not in self.excluded_assignee

        return result
