from dataclasses import dataclass
from typing import Any, List, Tuple

from qgis.core import QgsNetworkReplyContent


@dataclass
class PageLoadResult:
    """Contains result for a gitlab object list page"""

    nb_object: int
    nb_page: int
    page: int
    gitlab_object_list: List[Any]


def get_nb_result_and_page_from_reply(
    req_reply: QgsNetworkReplyContent,
) -> Tuple[int, int]:
    """Get nb available result and nb of page from reply header X-Total and X-Total-Pages

    :param req_reply: request reply
    :type req_reply: QgsNetworkReplyContent
    :return: nb_result, nb_page
    :rtype: Tuple[int, int]
    """
    if req_reply.hasRawHeader("X-Total".encode()):
        nb_result = int(req_reply.rawHeader("X-Total".encode()).data().decode("utf-8"))
    else:
        nb_result = -1
    if req_reply.hasRawHeader("X-Total-Pages".encode()):
        nb_page = int(
            req_reply.rawHeader("X-Total-Pages".encode()).data().decode("utf-8")
        )
    else:
        nb_page = -1

    return nb_result, nb_page
