'''
-------------------[ PROGRAM INFO ]-------------------

ortoPNOAqgis v 2
date: jun-2012
language: PYTHON, QGIS plugin
author: Cesar Gomez Paez
email: gcp2258@gmail.com
web: https://sites.google.com/site/euwesttrail/

Copyright and License Statement

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; version 3 of the License.
'''

'''
C:\Python27\Lib\site-packages\PyQt4\pyuic4.bat  ui_orthopnoa.ui -o ui_orthopnoa.py
    
en el terminal de python:
       
>>> import py_compile
>>> py_compile.compile('ui_orthopnoa.py')    

esto crea ui_orthopnoa.pyc (ejecutable)

Compiling Resources:
C:\Python27\Lib\site-packages\PyQt4\pyrcc4.exe -o resources.py resources.qrc

'''
from PyQt4 import QtCore, QtGui
import sys, webbrowser, urllib2, os, time

try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s

class Ui_orthoPNOA(object):
    def downloadOrthosASC(self):
        self.textBrowser.setPlainText("Initial LONGITUDE: "+ self.lineEdit.text())
        self.textBrowser.append("Initial LATITUDE: " + self.lineEdit_2.text())
        self.textBrowser.append("Georefs output TXT file: " + self.lineEdit_3.text())
        self.textBrowser.append("mdt25 output TXT file: " + self.lineEdit_4.text())

        #_________________________________________________________________________________________________________________________________________
        self.textBrowser.append("_______________________________________________________________")

        InitialLongitude = int(self.lineEdit.text())
        InitialLatitude = int(self.lineEdit_2.text())
        GeorefTXT = self.lineEdit_3.text()
        GeorefStripsTXT = self.lineEdit_4.text()
        
        self.textBrowser.append("Starting the data processing ... this task takes a long time, be patient ...\n")

        SERVER_PATH_TRANSLATED="C:\\gis-apps\\PNOA\\txt\\"
        pathJGW ="C:\\gis-apps\\PNOA/jgw\\"
        pathOrthosJPG = "C:\\gis-apps\\PNOA\\orthos\\"
        pathElevationASC = "C:\\gis-apps\\PNOA\\dem\\"
        
        linea=1
        incremento_longitud=1000
        incremento_latitud=850
        
        longitud_inicial = InitialLongitude
        lat_min = InitialLatitude-850
        
        http_part1="http://www.idee.es/wms/PNOA/PNOA?TRANSPARENT=true&VERSION=1.1.1&BGCOLOR=0xFFFFFF&SERVICE=WMS&REQUEST=GetMap&STYLES=default&EXCEPTIONS=application%2Fvnd.ogc.se_inimage&FORMAT=image%2Fjpeg&LAYERS=pnoa&SRS=EPSG%3A23030&BBOX="
        http_part2="&WIDTH=2000&HEIGHT=1700"
        http_mdt25_part1 = "http://www.idee.es/wcs/IDEE-WCS-UTM30N/wcsServlet?SERVICE=WCS&REQUEST=GetCoverage&VERSION=1.0.0&CRS=EPSG:23030&BBOX="
        http_mdt25_part2 = "&COVERAGE=MDT25_peninsula_ZIP&RESX=25&RESY=25&FORMAT=AsciiGrid&EXCEPTIONS=XML"
        
        escalaX = 0.500010000290
        escalaY = -0.500010000290
        
        rotacionX = 0.00000000000000000
        rotacionY = 0.00000000000000000
        
        
        georefHandle = open(SERVER_PATH_TRANSLATED + GeorefTXT, "w+")
        mdtHandle = open(SERVER_PATH_TRANSLATED + GeorefStripsTXT, "w+")
        
        #___________________WRITTING THE GEOREF FILES__________________________________________________________________________________________________________________
        while linea < 31:
            #______________________________________________________________________________
            iteracion=1
            longitude = longitud_inicial
            self.textBrowser.append("LINE______" + str(linea) + "\n")
            #print "LINE______" + str(linea) + "\n"
            georefHandle.write("LINE______" + str(linea) + "\n")
        
            prjHandle = open(pathJGW + "L" + str(linea) + ".prj", "w+")
            prjHandle.write("Projection     UTM"+"\n")
            prjHandle.write("Datum          EUROPEAN_DATUM_1950"+"\n")
            prjHandle.write("Zunits         NO"+"\n")
            prjHandle.write("Units          METERS"+"\n")
            prjHandle.write("Zone           30"+"\n")
            prjHandle.write("Xshift         0.000000"+"\n")
            prjHandle.write("Yshift         0.000000"+"\n")
            prjHandle.write("Parameters"+"\n")
            prjHandle.close()
        
            while iteracion < 26:
                lon_max = longitude+1000
                box = str(longitude)+","+str(lat_min)+","+str(lon_max)+","+str(InitialLatitude)
                georefHandle.write(box+"\n")
                if iteracion == 1:
                    mdtHandle.write("LINE______"+str(linea)+"\n")
                    jgwHandle = open(pathJGW + "L" + str(linea) + ".jgw", "w+")
                    jgwHandle.write("0.500010000290"+"\n")
                    jgwHandle.write("0.00000000000000000"+"\n")
                    jgwHandle.write("0.00000000000000000"+"\n")
                    jgwHandle.write("-0.500010000290"+"\n")
                    CentroX = longitude-1
                    jgwHandle.write(str(CentroX)+".750015000435" + "\n")
                '''
                #___________WRITING THE ORTHOPHOTO (2000X1700 PIXELS) TO THE HARD DISK_________________________________________________________________________________
                infp = urllib2.urlopen(http_part1 + str(longitude)+","+str(lat_min)+","+str(lon_max)+","+str(InitialLatitude) + http_part2)
                # Open the WMS JPG file for writing
                outfp = open(pathOrthosJPG + str(linea) + "-" + str(iteracion) +'.jpg', 'wb')
                # Transfer data .. this can take a while ...
                outfp.write(infp.read())
                outfp.close()
                #___________END OF THE ORTHOPHOTO  WRITING(2000X1700 PIXELS) TO THE HARD DISK__________________________________________________________________________
                
                #___________I PUT A DELAY OF 10 SECONDS TO THE NEXT REQUEST, THIS MEANS THIS PROGRAM LET TIME FOR THE REQUEST OF OTHER USERS OVER THE SAME SERVICE
                time.sleep(10)
                #___________PLEASE DON'T REMOVE THIS DELAY, THIS SOFTWARE IS INTENDED TO MAKE A NON ABUSIVE USE OF SPANISH WMS and WCS SERVICES________________________
                '''
                enlace = http_part1 + box + http_part2
                #print enlace +"\n"
                self.textBrowser.append(enlace +"\n")
                if iteracion == 25:
                    mdtHandle.write(str(longitude) + "," +str(lat_min) + "," + str(lon_max) + "," + str(InitialLatitude) + "\n")
                    enlace_mdt = http_mdt25_part1 + str(longitude) + "," +str(lat_min) + "," + str(lon_max) + "," + str(InitialLatitude) + http_mdt25_part2
                    #print enlace_mdt +"\n"
                    self.textBrowser.append(enlace_mdt +"\n")
                    '''
                    #___________WRITING THE ASC ELEVATION DATA TO THE HARD DISK________________________________________________________________________________________
                    infp = urllib2.urlopen(http_mdt25_part1 + str(longitude) + "," +str(lat_min) + "," + str(lon_max) + "," + str(InitialLatitude) + http_mdt25_part2)
                    # Open the WCS ASC file for writing
                    outfp = open(pathElevationASC +'Line'+ str(linea) +'mdt25.asc', 'w+')
                    # Transfer data .. this can take a while ...
                    outfp.write(infp.read())
                    outfp.close()
                    #___________END OF THE ASC WRITING_________________________________________________________________________________________________________________
                    ''' 
                    CentroY = str(InitialLatitude) + ".250005000145"
                    jgwHandle.write(str(CentroY) + "\n")
                    jgwHandle.close()
                    
                longitude = lon_max
                iteracion = iteracion + 1
                
            InitialLatitude =  lat_min
            lat_min = InitialLatitude - 850
            linea = linea + 1
               
            #______________________________________________________________________________
        
        georefHandle.close()
        mdtHandle.close()
        
        #___________________END OF THE GEOREF FILES WRITTING___________________________________________________________________________________________________________


        self.textBrowser.append("END OF THE GEOREF FILES WRITTING\n")
        self.textBrowser.append("STARTING OF THE ORTHOPHOTOS AND ASC ELEVATION DATA DOWNLOAD\n")
        
        
        
        linea=1
        incremento_longitud=1000
        incremento_latitud=850

        InitialLongitude = int(self.lineEdit.text())
        InitialLatitude = int(self.lineEdit_2.text())

        longitud_inicial = InitialLongitude
        lat_min = InitialLatitude-850
        
        
        while linea < 31:
            #______________________________________________________________________________
            iteracion=1
            longitude = longitud_inicial
            #print "_____________________LINE_____________________ " + str(linea) + "\n"
            self.textBrowser.append("_____________________LINE_____________________ " + str(linea) + "\n")
            
            while iteracion < 26:
                lon_max = longitude+1000
                box = str(longitude)+","+str(lat_min)+","+str(lon_max)+","+str(InitialLatitude)
                
                #print "Downloading ... " + str(linea) + "-" + str(iteracion) +'.jpg' + "\n"
                self.textBrowser.append("Downloading ... " + str(linea) + "-" + str(iteracion) +'.jpg' + "\n")
                
                if not os.path.exists(pathOrthosJPG + str(linea) + "-" + str(iteracion) +'.jpg'):
                    QtGui.QApplication.processEvents()
                    infp = urllib2.urlopen(http_part1 + str(longitude)+","+str(lat_min)+","+str(lon_max)+","+str(InitialLatitude) + http_part2)
                    # Open the WMS JPG file for writing
                    outfp = open(pathOrthosJPG + str(linea) + "-" + str(iteracion) +'.jpg', 'wb')
                    # Transfer data .. this can take a while ...
                    outfp.write(infp.read())
                    outfp.close()
                    #sleep(20)
                    #___________END OF THE ORTHOPHOTO  WRITING(2000X1700 PIXELS) TO THE HARD DISK__________________________________________________________________________
                    
                    #___________I PUT A DELAY OF 10 SECONDS TO THE NEXT REQUEST, THIS MEANS THIS PROGRAM LET TIME FOR THE REQUEST OF OTHER USERS OVER THE SAME SERVICE
                    time.sleep(10)
                    #___________PLEASE DON'T REMOVE THIS DELAY, THIS SOFTWARE IS INTENDED TO MAKE A NON ABUSIVE USE OF SPANISH WMS and WCS SERVICES________________________
        
                if iteracion == 25:
                    #print "Downloading ... " +'Line'+ str(linea) +'mdt25.asc' + "\n"
                    self.textBrowser.append("Downloading ... " +'Line'+ str(linea) +'mdt25.asc' + "\n")
                    #___________WRITING THE ASC ELEVATION DATA TO THE HARD DISK________________________________________________________________________________________
                    infp = urllib2.urlopen(http_mdt25_part1 + str(longitude) + "," +str(lat_min) + "," + str(lon_max) + "," + str(InitialLatitude) + http_mdt25_part2)
                    # Open the WCS ASC file for writing
                    outfp = open(pathElevationASC +'Line'+ str(linea) +'mdt25.asc', 'w+')
                    # Transfer data .. this can take a while ...
                    outfp.write(infp.read())
                    outfp.close()
                    #___________END OF THE ASC WRITING_________________________________________________________________________________________________________________
        
                longitude = lon_max
                iteracion = iteracion + 1
                
            InitialLatitude =  lat_min
            lat_min = InitialLatitude - 850
            linea = linea + 1
        
        #print "END OF ORTHOPHOTOS AND ASC FILE WRITTING"
        self.textBrowser.append("END OF ORTHOPHOTOS AND ASC FILE WRITTING")
        
        #_________________________________________________________________________________________________________________________________________
        
    def orthoPNOAgpl(self):
        url = 'http://www.euwesttrail.net/gpllicense.html'
        webbrowser.open_new(url)    
    def orthoPNOAhelp(self):
        url = 'http://www.euwesttrail.net/PNOA/ortoPNOAhelp.html'
        webbrowser.open_new(url)    
    def setupUi(self, orthoPNOA):
        orthoPNOA.setObjectName(_fromUtf8("orthoPNOA"))
        orthoPNOA.resize(560, 477)
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(_fromUtf8("../../../../../../Users/geo2011/.qgis/python/plugins/orthoPNOA/orthoPNOA.png")), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        orthoPNOA.setWindowIcon(icon)
        self.buttonBox = QtGui.QDialogButtonBox(orthoPNOA)
        self.buttonBox.setGeometry(QtCore.QRect(430, 420,121, 21))
        self.buttonBox.setOrientation(QtCore.Qt.Horizontal)
        self.buttonBox.setStandardButtons(QtGui.QDialogButtonBox.Ok)
        self.buttonBox.setObjectName(_fromUtf8("buttonBox"))
        self.label_8 = QtGui.QLabel(orthoPNOA)
        self.label_8.setGeometry(QtCore.QRect(120, 360, 301, 31))
        self.label_8.setAlignment(QtCore.Qt.AlignCenter)
        self.label_8.setObjectName(_fromUtf8("label_8"))
        #self.pushButton_2 = QtGui.QPushButton(orthoPNOA)
        #self.pushButton_2.setGeometry(QtCore.QRect(430, 420, 121, 21))
        #self.pushButton_2.setObjectName(_fromUtf8("pushButton_2"))
        self.frame = QtGui.QFrame(orthoPNOA)
        self.frame.setGeometry(QtCore.QRect(10, 10, 541, 341))
        font = QtGui.QFont()
        font.setFamily(_fromUtf8("Verdana"))
        font.setPointSize(10)
        self.frame.setFont(font)
        self.frame.setFrameShape(QtGui.QFrame.StyledPanel)
        self.frame.setFrameShadow(QtGui.QFrame.Sunken)
        self.frame.setObjectName(_fromUtf8("frame"))
        self.label_2 = QtGui.QLabel(self.frame)
        self.label_2.setGeometry(QtCore.QRect(10, 0, 341, 16))
        font = QtGui.QFont()
        font.setFamily(_fromUtf8("Verdana"))
        font.setPointSize(10)
        self.label_2.setFont(font)
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.label_4 = QtGui.QLabel(self.frame)
        self.label_4.setGeometry(QtCore.QRect(30, 30, 91, 16))
        self.label_4.setObjectName(_fromUtf8("label_4"))
        self.label_5 = QtGui.QLabel(self.frame)
        self.label_5.setGeometry(QtCore.QRect(30, 60, 91, 16))
        self.label_5.setObjectName(_fromUtf8("label_5"))
        self.label_6 = QtGui.QLabel(self.frame)
        self.label_6.setGeometry(QtCore.QRect(30, 90, 91, 16))
        self.label_6.setObjectName(_fromUtf8("label_6"))
        self.label_7 = QtGui.QLabel(self.frame)
        self.label_7.setGeometry(QtCore.QRect(30, 120, 91, 16))
        self.label_7.setObjectName(_fromUtf8("label_7"))
        self.lineEdit = QtGui.QLineEdit(self.frame)
        self.lineEdit.setGeometry(QtCore.QRect(130, 30, 113, 20))
        self.lineEdit.setObjectName(_fromUtf8("lineEdit"))
        self.lineEdit_2 = QtGui.QLineEdit(self.frame)
        self.lineEdit_2.setGeometry(QtCore.QRect(130, 60, 113, 20))
        self.lineEdit_2.setObjectName(_fromUtf8("lineEdit_2"))
        self.lineEdit_3 = QtGui.QLineEdit(self.frame)
        self.lineEdit_3.setGeometry(QtCore.QRect(130, 90, 181, 20))
        self.lineEdit_3.setObjectName(_fromUtf8("lineEdit_3"))
        self.lineEdit_4 = QtGui.QLineEdit(self.frame)
        self.lineEdit_4.setGeometry(QtCore.QRect(130, 120, 181, 20))
        self.lineEdit_4.setObjectName(_fromUtf8("lineEdit_4"))
        self.label_3 = QtGui.QLabel(self.frame)
        self.label_3.setGeometry(QtCore.QRect(20, 150, 331, 16))
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.textBrowser = QtGui.QTextBrowser(self.frame)
        self.textBrowser.setGeometry(QtCore.QRect(10, 170, 521, 161))
        self.textBrowser.setObjectName(_fromUtf8("textBrowser"))
        self.pushButton = QtGui.QPushButton(self.frame)
        self.pushButton.setGeometry(QtCore.QRect(250, 30, 281, 51))
        self.pushButton.setObjectName(_fromUtf8("pushButton"))
        self.label = QtGui.QLabel(self.frame)
        self.label.setGeometry(QtCore.QRect(320, 80, 211, 71))
        font = QtGui.QFont()
        font.setFamily(_fromUtf8("Verdana"))
        font.setPointSize(8)
        self.label.setFont(font)
        self.label.setObjectName(_fromUtf8("label"))
        self.label_9 = QtGui.QLabel(orthoPNOA)
        self.label_9.setGeometry(QtCore.QRect(130, 400, 291, 41))
        self.label_9.setObjectName(_fromUtf8("label_9"))
        self.pushButton_3 = QtGui.QPushButton(orthoPNOA)
        self.pushButton_3.setGeometry(QtCore.QRect(430, 360, 121, 23))
        self.pushButton_3.setAutoExclusive(False)
        self.pushButton_3.setObjectName(_fromUtf8("pushButton_3"))
        self.pushButton_4 = QtGui.QPushButton(orthoPNOA)
        self.pushButton_4.setGeometry(QtCore.QRect(430, 390, 121, 23))
        self.pushButton_4.setObjectName(_fromUtf8("pushButton_4"))
        self.label_10 = QtGui.QLabel(orthoPNOA)
        self.label_10.setGeometry(QtCore.QRect(10, 360, 101, 81))
        self.label_10.setText(_fromUtf8(""))
        self.label_10.setPixmap(QtGui.QPixmap(_fromUtf8("../../../../../../Users/geo2011/.qgis/python/plugins/orthoPNOA/spain.jpg")))
        self.label_10.setObjectName(_fromUtf8("label_10"))

        self.retranslateUi(orthoPNOA)
        QtCore.QObject.connect(self.buttonBox, QtCore.SIGNAL(_fromUtf8("accepted()")), orthoPNOA.accept)
        QtCore.QObject.connect(self.buttonBox, QtCore.SIGNAL(_fromUtf8("rejected()")), orthoPNOA.reject)
        QtCore.QMetaObject.connectSlotsByName(orthoPNOA)

    def retranslateUi(self, orthoPNOA):
        orthoPNOA.setWindowTitle(QtGui.QApplication.translate("orthoPNOA", "orthoPNOA", None, QtGui.QApplication.UnicodeUTF8))
        self.label_8.setText(QtGui.QApplication.translate("orthoPNOA", "This application complies with all restrictions on its use imposed\n"
"by the Spanish IDEE services.", None, QtGui.QApplication.UnicodeUTF8))
        #self.pushButton_2.setText(QtGui.QApplication.translate("orthoPNOA", "exit", None, QtGui.QApplication.UnicodeUTF8))
        #self.pushButton_2.clicked.connect(QtCore.QCoreApplication.instance().quit)
        #self.pushButton_2.clicked.connect()
        self.label_2.setText(QtGui.QApplication.translate("orthoPNOA", "QUERY over WMS and WCS spanish IDEE services", None, QtGui.QApplication.UnicodeUTF8))
        self.label_4.setText(QtGui.QApplication.translate("orthoPNOA", "LONGITUDE", None, QtGui.QApplication.UnicodeUTF8))
        self.label_5.setText(QtGui.QApplication.translate("orthoPNOA", "LATITUDE", None, QtGui.QApplication.UnicodeUTF8))
        self.label_6.setText(QtGui.QApplication.translate("orthoPNOA", "GEOREF TXT", None, QtGui.QApplication.UnicodeUTF8))
        self.label_7.setText(QtGui.QApplication.translate("orthoPNOA", "MDT25 TXT", None, QtGui.QApplication.UnicodeUTF8))
        self.lineEdit.setText(QtGui.QApplication.translate("orthoPNOA", "360745", None, QtGui.QApplication.UnicodeUTF8))
        self.lineEdit_2.setText(QtGui.QApplication.translate("orthoPNOA", "4477504", None, QtGui.QApplication.UnicodeUTF8))
        self.lineEdit_3.setText(QtGui.QApplication.translate("orthoPNOA", "georefs-Iruelas-valley.txt", None, QtGui.QApplication.UnicodeUTF8))
        self.lineEdit_4.setText(QtGui.QApplication.translate("orthoPNOA", "mdt25-Iruelas-valley.txt", None, QtGui.QApplication.UnicodeUTF8))
        self.label_3.setText(QtGui.QApplication.translate("orthoPNOA", "orthoPNOA result", None, QtGui.QApplication.UnicodeUTF8))
        self.textBrowser.setHtml(QtGui.QApplication.translate("orthoPNOA", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n"
"<html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">\n"
"p, li { white-space: pre-wrap; }\n"
"</style></head><body style=\" font-family:\'Verdana\'; font-size:10pt; font-weight:400; font-style:normal;\">\n"
"<p style=\" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">output ...</p></body></html>", None, QtGui.QApplication.UnicodeUTF8))
        self.pushButton.setText(QtGui.QApplication.translate("orthoPNOA", " Download the orthophotos and ASC files", None, QtGui.QApplication.UnicodeUTF8))
        self.pushButton.clicked.connect(self.downloadOrthosASC)
        self.label.setText(QtGui.QApplication.translate("orthoPNOA", "Fill the initial Longitude  and Latitude\n"
"for the top-left corner of the 25x25\n"
"KM area to download and the\n"
"filenames for the output TXT files.", None, QtGui.QApplication.UnicodeUTF8))
        self.label_9.setText(QtGui.QApplication.translate("orthoPNOA", "If a WMS service delay stop the app execution, just restart\n"
"it with the same parameters, the app continues in the point\n"
"where it left off.", None, QtGui.QApplication.UnicodeUTF8))
        self.pushButton_3.setText(QtGui.QApplication.translate("orthoPNOA", "Help Page", None, QtGui.QApplication.UnicodeUTF8))
        self.pushButton_3.clicked.connect(self.orthoPNOAhelp)
        self.pushButton_4.setText(QtGui.QApplication.translate("orthoPNOA", "GNU GPL", None, QtGui.QApplication.UnicodeUTF8))
        self.pushButton_4.clicked.connect(self.orthoPNOAgpl)

