# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ORKa.MV Data API
                                 A QGIS plugin
 This plugin downloads a geopackage from the ORKa.MV Data API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-05-03
        git sha              : $Format:%H$
        copyright            : (C) 2021 by terrestris GmbH & Co. KG
        email                : info@terrestris.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from enum import Enum
from typing import Optional, TypedDict, List


class ErrorReason(Enum):
    ERROR = 'ERROR'
    TIMEOUT = 'TIMEOUT'
    BBOX_TOO_BIG = 'BBOX_TOO_BIG'
    BBOX_INVALID = 'BBOX_INVALID'
    NO_THREADS_AVAILABLE = 'NO_THREADS_AVAILABLE'
    NETWORK_ERROR = 'NETWORK_ERROR'
    GROUPS_ERROR = 'GROUPS_ERROR'


class TaskStatus(Enum):
    STARTED = 1
    CANCELLED = 2
    COMPLETED = 3


class OrkamvApiException(Exception):
    def __init__(self, reason: ErrorReason, message: Optional[str] = None):
        self.reason = reason
        self.message = message
        super().__init__(self, str(reason))


class LayerGroup(TypedDict):
    """Typing for the layer group mapping.
    """
    title: str
    layers: List[str]


class LayerSelectionMode(Enum):
    ALL = 1
    GROUP = 2


LAYER_GROUPS_PROP_NAME = 'ORKA_LAYER_GROUPS'
LAYER_BASE_NAME = 'ORKa.MV Data API'
