# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ORKa.MV Data API
                                 A QGIS plugin
 This plugin downloads a geopackage from the ORKa.MV Data API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-05-03
        git sha              : $Format:%H$
        copyright            : (C) 2021 by terrestris GmbH & Co. KG
        email                : info@terrestris.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import json
import os
from time import sleep
from typing import Optional, List

from qgis._core import QgsTask, QgsRectangle

from .network_request import post_json, get_json, get_bytes
from .types import ErrorReason, OrkamvApiException


class GeopackageTask(QgsTask):

    layers: List[str] = None
    job_id: int
    data_id: str
    file_name: str
    error_reason: Optional[ErrorReason] = None
    error_message: Optional[str] = None

    def __init__(self, base_url: str, target_dir: str, extent: QgsRectangle, layers: List[str] = None):
        self.base_url = base_url[:-1] if base_url.endswith('/') else base_url
        self.extent = (
            extent.xMinimum(),
            extent.yMinimum(),
            extent.xMaximum(),
            extent.yMaximum()
        )
        self.target_dir = target_dir
        if layers is not None:
            self.layers = layers
        super().__init__('ORKa.MV Data API Geopackage Job', QgsTask.Flag())

    def start_job(self):
        params = {
            'bbox': self.extent,
        }
        if self.layers is not None:
            params['layers'] = self.layers
        res_data = post_json(f'{self.base_url}/jobs/', params)
        self.job_id = res_data['job_id']

    def get_job_status(self) -> bool:
        res_data = get_json(f'{self.base_url}/jobs/{self.job_id}')

        if res_data.get('status') == 'CREATED':
            self.data_id = res_data['data_id']
            return True
        else:
            return False

    def download_file(self):
        data = get_bytes(f'{self.base_url}/data/{self.data_id}')

        self.file_name = os.path.abspath(os.path.join(self.target_dir, 'geopackage.gpkg'))

        with open(self.file_name, 'w+b') as fp:
            fp.write(data)

    def run(self):
        try:
            self.setProgress(10)
            self.start_job()

            if self.isCanceled():
                return False

            self.setProgress(20)
            while not self.get_job_status():
                if self.isCanceled():
                    return False
                sleep(0.5)

            if self.isCanceled():
                return False

            self.setProgress(80)
            self.download_file()

            if self.isCanceled():
                return False

            self.setProgress(100)
            return True

        except OrkamvApiException as e:
            self.error_reason = e.reason
            self.error_message = e.message
            return False

    def get_results(self) -> str:
        return self.file_name
