# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OPTileLoader
                                 A QGIS plugin
 Load Mars and The Moon basemaps
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-29
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Rober J
        email                : roberer_@outlook.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import Qgis, QgsRasterLayer, QgsProject
from qgis.utils import iface

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .optileloader_dialog import OPTileLoaderDialog
import os.path


class OPTileLoader:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'OPTileLoader_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&OpenPlanetary Tile Loader')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('OPTileLoader', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/optileloader/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'OpenPlanetary Tile Loader'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&OpenPlanetary Tile Loader'),
                action)
            self.iface.removeToolBarIcon(action)

    # This function sets QgsRasterLayer parameters based on which button was pressed #
    def loadtile(self, button):
        if button == self.dlg.basemap:
            uri = 'https://cartocdn-gusc.global.ssl.fastly.net/opmbuilder/api/v1/map/named/opm-mars-basemap-v0-2/all/%7Bz%7D/%7Bx%7D/%7By%7D.png'
            name = 'OPM Mars Basemap v0.2'
        elif button == self.dlg.colourmola:
                uri = 'http://s3-eu-west-1.amazonaws.com/whereonmars.cartodb.net/mola_color-noshade_global/%7Bz%7D/%7Bx%7D/%7B-y%7D.png'
                name = 'Mars Colour MOLA elevation'
        elif button ==  self.dlg.graymola:
                uri = 'http://s3-eu-west-1.amazonaws.com/whereonmars.cartodb.net/mola-gray/%7Bz%7D/%7Bx%7D/%7B-y%7D.png'
                name = 'Mars Shaded Grayscale MOLA Elevation'
        elif button == self.dlg.hillshade:
                uri = 'https://s3.us-east-2.amazonaws.com/opmmarstiles/hillshade-tiles/%7Bz%7D/%7Bx%7D/%7B-y%7D.png'
                name = 'Mars Hillshade'
        elif button == self.dlg.shadedmola:
                uri = 'http://s3-eu-west-1.amazonaws.com/whereonmars.cartodb.net/mola-color/%7Bz%7D/%7Bx%7D/%7B-y%7D.png'
                name = 'Mars Shaded Colour MOLA Elevation'
        elif button == self.dlg.surfacetexture:
                uri = 'http://s3-eu-west-1.amazonaws.com/whereonmars.cartodb.net/celestia_mars-shaded-16k_global/%7Bz%7D/%7Bx%7D/%7B-y%7D.png'
                name = 'Mars Shaded Surface Texture'
        elif button == self.dlg.viking:
                uri = 'http://s3-eu-west-1.amazonaws.com/whereonmars.cartodb.net/viking_mdim21_global/%7Bz%7D/%7Bx%7D/%7B-y%7D.png'
                name = 'Mars VIKING MDIM 2.1'
        elif button == self.dlg.moonbase:
                uri = 'https://cartocdn-gusc.global.ssl.fastly.net/opmbuilder/api/v1/map/named/opm-moon-basemap-v0-1/all/%7Bz%7D/%7Bx%7D/%7By%7D.png'
                name = 'OPM Moon Basemap v0.1'
        elif button == self.dlg.moonhillsh:
            uri = 'https://s3.amazonaws.com/opmbuilder/301_moon/tiles/w/hillshaded-albedo/%7Bz%7D/%7Bx%7D/%7B-y%7D.png'
            name = 'Moon Hillshaded Albedo'
        else:
            iface.messageBar().pushMessage("ERROR", "Something went wrong", level=Qgis.Critical)
        
        # Load XYZ tile #
        rasterLyr = QgsRasterLayer("type=xyz&url=" + uri, name, "wms")
        QgsProject.instance().addMapLayer(rasterLyr)
        iface.messageBar().pushMessage("Loaded", name, level=Qgis.Success, duration=3)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = OPTileLoaderDialog()

            # Connect buttons with the loadtile function
            self.dlg.basemap.clicked.connect(lambda: self.loadtile(self.dlg.basemap))
            self.dlg.colourmola.clicked.connect(lambda: self.loadtile(self.dlg.colourmola))
            self.dlg.graymola.clicked.connect(lambda: self.loadtile(self.dlg.graymola))
            self.dlg.hillshade.clicked.connect(lambda: self.loadtile(self.dlg.hillshade))
            self.dlg.shadedmola.clicked.connect(lambda: self.loadtile(self.dlg.shadedmola))
            self.dlg.surfacetexture.clicked.connect(lambda: self.loadtile(self.dlg.surfacetexture))
            self.dlg.viking.clicked.connect(lambda: self.loadtile(self.dlg.viking))
            self.dlg.moonbase.clicked.connect(lambda: self.loadtile(self.dlg.moonbase))
            self.dlg.moonhillsh.clicked.connect(lambda: self.loadtile(self.dlg.moonhillsh))

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
