import pandas as pd


class DataBinner:
    "Base class for data binning"

    def __init__(self, cross_symbology_handler) -> None:
        self.cross_symbology_handler = cross_symbology_handler
        self.means = {}

    def get_item(self):
        """
        Return aggregated items as AssayBarGraphitem.
        """
        return

    def get_color_means(self) -> dict:
        """
        Return dictionnary of averages per color for config's hole id.
        {hex color(str) :  value(float)}
        """
        return self.means

    def get_all_color_means(self) -> dict:
        """
        Return dictionnary of dictionnaries with averages per color.
        {hole_id(str) : {hex color(str) :  value(float)}}
        """
        column_name = self.cross_symbology_handler.config.column.name
        holes, _, values = self.cross_symbology_handler.config.assay.get_all_values(
            column_name, return_hole_column=True, hole_filter=False
        )

        # get colors
        categories_colors = self.cross_symbology_handler.get_colors_from_values(values)
        categories_colors = [color.name() for color in categories_colors]

        df = pd.DataFrame(
            {"hole": holes, "value": values, "category": categories_colors}
        )
        unique_holes = df["hole"].unique()
        agg = df.groupby(["hole", "category"]).mean()
        result = {}
        for hole in unique_holes:
            result[hole] = agg.loc[hole].to_dict().get("value")

        return result
