from typing import List

import numpy as np
import pyqtgraph as pg
import pyqtgraph.parametertree as ptree
import pyqtgraph.parametertree.parameterTypes as pTypes
from qgis.PyQt.QtGui import QColor, QPen

from openlog.core import pint_utilities
from openlog.datamodel.assay.generic_assay import AssayDefinition, AssayDomainType
from openlog.gui.assay_visualization.assay_plot_widget import AssayPlotWidget
from openlog.gui.pyqtgraph.BoldBoolParameter import BoldBoolParameter


class CrossPlotConfig:
    def __init__(self, config_list: List):
        pass


class CrossPlotConfigList:
    def __init__(self):
        self.list: List[CrossPlotConfig] = []

    def get_crossplot_config_from_assay(self, assay_name: str) -> List[CrossPlotConfig]:
        """
        Return CrossPlotConfig related to an assay or a column.
        """
        result = []
        for config in self.list:
            assay_def = config.assay_def
            columns = assay_def.columns.keys()
            if assay_name in columns or assay_name == assay_def.variable:
                result.append(config)

        return result

    def remove_config(self, config: CrossPlotConfig):
        """
        Remove configuration from list
        If plot is associated to configuration, plot is also deleted

        Args:
            config: (StackedConfiguration) configuration
        """

        if config.plot is not None:
            # Update visibility even if plot is deleted later
            # so we can count number of visible plot if main thread as not process event
            config.plot.setVisible(False)
            config.plot.deleteLater()
        self.list.remove(config)
