from qgis.PyQt.QtGui import QColor, QPen


def serialize_pen_param(config, param_name: str, key_prefix: str) -> dict:

    d = {}
    # get PenParameter instance
    parameter = getattr(config, param_name)
    pen = parameter.get_pen()
    qcolor = pen.color()
    d[key_prefix + "_color"] = qcolor.name()
    d[key_prefix + "_width"] = pen.width()
    d[key_prefix + "_style"] = pen.style()

    return d


def deserialize_pen_param(config, dict, param_name: str, key_prefix: str) -> None:

    parameter = getattr(config, param_name)

    parameter.blockSignals(True)
    pen = QPen()
    qcolor = QColor()
    qcolor.setNamedColor(dict.get(key_prefix + "_color"))
    pen.setColor(qcolor)
    pen.setWidth(dict.get(key_prefix + "_width"))
    pen.setStyle(dict.get(key_prefix + "_style"))
    # update parameters according to QPen
    parameter.init_from_pen(pen)
    parameter.blockSignals(False)
