from openlog.plugins.extensions.heterogenous_plots.classes import (
    is_config_list_valid_for_heterogenous_stack,
    make_plot_widget,
)
from openlog.plugins.hookspecs import HeterogenousPlotsHook, hookimpl

PLUGIN_NAME = "heterogenous_plots"


@hookimpl
def heterogenous_plots_plugin():
    return HeterogenousPlotsHook(
        name=PLUGIN_NAME,
        validator=is_config_list_valid_for_heterogenous_stack,
        widget_factory=make_plot_widget,
    )
