from typing import Any, List

from openlog.gui.assay_visualization.assay_plot_widget import AssayPlotWidget


def make_plot_widget(stacked_config, domain, config_list: List[Any]) -> AssayPlotWidget:
    """
    Instantiate appropriate widget depending configs.
    """
    plot = AssayPlotWidget(domain=domain, collar_stack=True)
    return plot


def is_config_list_valid_for_heterogenous_stack(config_list: List[Any]) -> bool:
    """
    Check if list of AssayColumnVisualizationConfig is valid :
    - only one series type used
    - only valid series type used
    - no plugin assay column is used

    Returns: True if list is valid, False otherwise

    """
    return False
