from qgis.PyQt.QtGui import QBrush, QPen

from openlog.gui.assay_visualization.cross_symbology.cross_symbology_handler import (
    CrossSymbologyHandler,
)


class LineCrossSymbologyHandler(CrossSymbologyHandler):
    def __init__(self, config, icon: str):
        super().__init__(config, icon)
        self.param.setName("Line shading")

    def get_gradient_pen(self) -> QPen:
        """
        Return gradient QPen.
        """
        if self.legend:
            try:
                self.config.plot_widget.removeItem(self.legend)
            except:
                pass

        if not self.param.value():
            return
        self.symbology_widget.altitude = self.config.plot_item.switcher.mode
        gradient = self.symbology_widget.get_gradient()
        if gradient is None:
            return
        gradient_brush = QBrush(gradient)
        grad_pen = QPen()
        grad_pen.setBrush(gradient_brush)
        grad_pen.setCosmetic(True)
        # legend
        self.display_legend()
        return grad_pen
