----------------------------------------------------------------------------
-- xplordb
-- 
-- Copyright (C) 2022  Oslandia / OpenLog
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as published
-- by the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <https://www.gnu.org/licenses/>.
-- 
-- __authors__ = ["davidms"]
-- __contact__ = "geology@oslandia.com"
-- __date__ = "2022/02/02"
-- __license__ = "AGPLv3"
----------------------------------------------------------------------------

--
-- PostgreSQL database dump
--

-- Dumped from database version 13.5 (Ubuntu 13.5-0ubuntu0.21.10.1)
-- Dumped by pg_dump version 13.5 (Ubuntu 13.5-0ubuntu0.21.10.1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Data for Name: sample; Type: TABLE DATA; Schema: surf; Owner: postgres
--

COPY surf.sample (data_set, sample_id, x, y, z, grid_id, line_no, sample_type, channel_id, channel_from_m, channel_to_m, sample_depth_m, sample_weight_kg, date_sampled, company, sampled_by, sampled_by_2, geology_code, geology_logged_by, mesh_size, survey_method, survey_date, surveyed_by, lat, lon, local_grid_east, local_grid_north, local_grid_rl, lease_id, prospect, comment, site_photo, data_source, historic_sample_id, srid, loaded_by, load_date, geom, class) FROM stdin;
Capricorn	6063277	541984.01	7269234.16	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69072	117.41502	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000F6EA417EA65A5D40ED32475B78B038C0000080303AFF35C0	primary
Capricorn	6063278	542016.44	7269252.89	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69055	117.41534	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000005FD974BCAB5A5D40116065366DB038C000008C4FEFFE35C0	primary
Capricorn	6063580	544144.20	7262673.49	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	QTT	\N	-1 + 0.45mm	\N	\N	\N	-24.74991	117.43658	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000E59CD1BD075C5D4020A4466E9FBF38C00000689AE91836C0	primary
Capricorn	3595517	544394.57	7264757.69	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	\N	\N	\N	\N	-24.73108	117.43899	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000670106392F5C5D40A818DA62CDBA38C00000AC946F0B36C0	primary
Capricorn	3595518	544554.79	7264892.27	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72986	117.44057	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D89EE71B495C5D40DE96576D7DBA38C00000D062BF0936C0	primary
Capricorn	3595519	543545.18	7265759.15	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	GO	\N	\N	\N	\N	\N	-24.72206	117.43056	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000033D8CA1AA55B5D4021FF25417EB838C00000B455770A36C0	primary
Capricorn	3595520	543545.18	7265758.05	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	GO	\N	\N	\N	\N	\N	-24.72207	117.43056	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000005DAAEF1AA55B5D406799D1E77EB838C00000BCF6780A36C0	primary
Capricorn	3595521	543545.18	7265758.05	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	GO	\N	\N	\N	\N	\N	-24.72207	117.43056	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000005DAAEF1AA55B5D406799D1E77EB838C00000BCF6780A36C0	primary
Capricorn	3595522	542533.19	7269189.30	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	\N	\N	\N	\N	-24.69111	117.42045	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000315A2675FF5A5D401ECC29EA91B038C000000C615EFC35C0	primary
Capricorn	3595523	542560.47	7269178.15	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.69121	117.42072	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000064E69CE1035B5D40F8F9E27698B038C000008C3D47FC35C0	primary
Capricorn	3595524	542306.93	7268968.54	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	GO	\N	\N	\N	\N	\N	-24.69311	117.41822	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000008D9150ECDA5A5D40D268BAFC14B138C00000F839EEFE35C0	primary
Capricorn	3595525	542276.67	7268999.64	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	GO	\N	\N	\N	\N	\N	-24.69283	117.41792	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000002F74C201D65A5D404B2280A202B138C000000426ECFE35C0	primary
Capricorn	3595526	542962.29	7268261.20	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	\N	\N	\N	\N	-24.69948	117.42472	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000AB21606B455B5D40F26E1972B6B238C000002C3C4DFF35C0	primary
Capricorn	5255253	544153.89	7262225.01	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.75396	117.43669	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000707508B095C5D402CD941DAA8C038C000003C89731B36C0	primary
Capricorn	5255254	544234.15	7262343.23	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.75289	117.43748	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000045C9DC7C165C5D40E570DDBA62C038C0000020D44F1A36C0	primary
Capricorn	5255255	544214.31	7262148.41	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.75465	117.43729	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000099A1CA5F135C5D4012C02E13D6C038C00000F01D8D1B36C0	primary
Capricorn	5255256	544669.32	7264343.79	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.73481	117.44172	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D9616DF35B5C5D40B704E3D5C1BB38C00000980F450C36C0	primary
Capricorn	5255257	544479.59	7264778.46	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.73089	117.43983	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000448B54FC3C5C5D40FE845BEEC0BA38C00000543BD50A36C0	primary
Capricorn	5255258	544454.16	7264733.14	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.7313	117.43958	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000009A1CB6E3385C5D40B48291CDDBBA38C00000D84E3D0B36C0	primary
Capricorn	5255259	544454.16	7264733.14	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.7313	117.43958	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000009A1CB6E3385C5D40B48291CDDBBA38C00000D84E3D0B36C0	primary
Capricorn	5255260	544454.16	7264733.14	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	MDST	\N	\N	\N	\N	\N	-24.7313	117.43958	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000009A1CB6E3385C5D40B48291CDDBBA38C00000D84E3D0B36C0	primary
Capricorn	5255261	544428.89	7264738.76	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	MDST	\N	\N	\N	\N	\N	-24.73125	117.43933	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000A2FECCA345C5D4084A35C86D8BA38C0000090B8590B36C0	primary
Capricorn	5255281	543533.71	7269837.28	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	\N	\N	\N	\N	-24.68523	117.43032	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000013858D2AA15B5D4061A90F8D10AF38C00000B849F0F235C0	primary
Capricorn	5255282	542629.40	7268233.43	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	\N	\N	\N	\N	-24.69974	117.42143	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D1523F840F5B5D4047CEED7DC7B238C00000943E5A0136C0	primary
Capricorn	5255283	544018.75	7266154.06	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	DOL	\N	\N	\N	\N	\N	-24.71848	117.43523	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000006EA7D59DF15B5D40000D8BA193B738C00000641F7E0536C0	primary
Capricorn	5255285	543999.29	7269263.35	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.6904	117.43494	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000A5FB71DCEC5B5D40FA283B5F63B038C0000050919DF335C0	primary
Capricorn	5255286	544098.85	7265263.56	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	5255291	544098.85	7265263.56	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	5255292	543828.82	7264943.30	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72942	117.43339	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000002C48E878D35B5D40B804729960BA38C000002C26930D36C0	primary
Capricorn	5255293	543818.96	7264703.05	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.73159	117.4333	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000FEC99BFFD15B5D40157772D0EEBA38C00000303D050F36C0	primary
Capricorn	5255294	548009.25	7265703.43	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SDST	\N	\N	\N	\N	\N	-24.72243	117.4747	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000005A8FE949785E5D4046EB1C7A96B838C00000D00470F135C0	primary
Capricorn	5255295	546229.28	7264813.70	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.73052	117.45713	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000006239186D585D5D40022A04ACA8BA38C00000546AB10036C0	primary
Capricorn	5255296	546299.30	7264583.15	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SDST	\N	\N	\N	\N	\N	-24.7326	117.45783	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C39C1DE5635D5D40A54AE1FC30BB38C000004C02A10136C0	primary
Capricorn	5255297	546129.57	7264633.54	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	\N	\N	\N	\N	-24.73215	117.45615	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000ADDC15E485D5D40D899FB7F13BB38C00000B4264D0236C0	primary
Capricorn	5255298	546099.33	7264663.54	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.73188	117.45585	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000070496F74435D5D400CEBC0CD01BB38C000000CB14C0236C0	primary
Capricorn	3578049	542426.89	7269161.95	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	BX	\N	\N	\N	\N	\N	-24.69136	117.4194	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000003D966241EE5A5D400E06B14BA2B038C00000686621FD35C0	primary
Capricorn	3578051	542426.89	7269161.95	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	BX	\N	\N	\N	\N	\N	-24.69136	117.4194	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000003D966241EE5A5D400E06B14BA2B038C00000686621FD35C0	primary
Capricorn	3578052	542347.05	7269186.55	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	BX	\N	\N	\N	\N	\N	-24.69114	117.41861	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000000E70D50E15A5D40E31A65E193B038C00000140471FD35C0	primary
Capricorn	3595515	545640.68	7265422.44	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72504	117.45129	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000A87579BEF85C5D40C128AE8941B938C0000008B4830036C0	primary
Capricorn	3595516	545823.18	7265560.25	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72379	117.45309	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000A40C0F3C165D5D40752A6D9DEFB838C000006450AEFE35C0	primary
Capricorn	5255284	544098.85	7265263.56	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	5255287	544098.85	7265263.56	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	5255288	544098.85	7265263.56	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	5255289	544098.85	7265263.56	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	5255290	544098.85	7265263.56	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	\N	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	6063219	543034.08	7266297.78	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	-1 + 0.45mm	\N	\N	\N	-24.71721	117.42549	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000AFE8D09525B5D4056E4696740B738C00000C8A2400A36C0	primary
Capricorn	6063581	544204.37	7262518.27	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.75131	117.43718	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000F224B92115C5D40BBD1AA2FFBBF38C00000A0F4771936C0	primary
Capricorn	6063586	548014.23	7263638.33	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.74108	117.47482	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000BEC93C427A5E5D409CCCF7B95CBD38C0000030B35AFD35C0	primary
Capricorn	6063587	547944.69	7263123.69	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.74573	117.47415	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000598F1A486F5E5D40E4535E778DBE38C0000038D1B90036C0	primary
Capricorn	6063588	544009.17	7263138.97	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.74571	117.43523	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000001AA1339FF15B5D4008331E2F8CBE38C00000F8AFFC1636C0	primary
Capricorn	6063589	544269.03	7264082.65	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73718	117.43777	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000068E8373C1B5C5D40F180B3285DBC38C0000004A40D1036C0	primary
Capricorn	6063590	544663.78	7264193.22	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73617	117.44167	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000001717DD215B5C5D405046AAF61ABC38C00000A4112C0D36C0	primary
Capricorn	6063591	544454.16	7264733.14	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.7313	117.43958	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000009A1CB6E3385C5D40B48291CDDBBA38C00000D84E3D0B36C0	primary
Capricorn	6063678	542073.94	7269530.64	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68804	117.4159	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000EAA063E9B45A5D40DB4563B7C8AF38C00000F05900FD35C0	primary
Capricorn	6063679	542968.20	7269515.72	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68815	117.42474	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000008BA5CCBE455B5D40012380EBCFAF38C000000C9802F835C0	primary
Capricorn	6063680	544096.18	7269193.28	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69103	117.4359	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000DF1C696FC5B5D402B3B6AA98CB038C00000E88078F335C0	primary
Capricorn	6063681	543533.71	7269837.28	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68523	117.43032	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000013858D2AA15B5D4061A90F8D10AF38C00000B849F0F235C0	primary
Capricorn	3578048	542443.00	7269138.65	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	\N	\N	\N	\N	-24.69157	117.41956	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000936147E0F05A5D40A4E8990EB0B038C000003C7E2CFD35C0	primary
Capricorn	6063222	543562.80	7265573.08	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	-1 + 0.45mm	\N	\N	\N	-24.72374	117.43074	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000004469D80DA85B5D40CD97C459ECB838C000001C43710B36C0	primary
Capricorn	6063223	543563.95	7265616.26	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	-1 + 0.45mm	\N	\N	\N	-24.72335	117.43075	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000006266E337A85B5D4034E7A6CAD2B838C00000E0A52F0B36C0	primary
Capricorn	6063224	544402.22	7264935.94	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	-1 + 0.45mm	\N	\N	\N	-24.72947	117.43906	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000386C855E305C5D40242A04DF63BA38C00000DC825C0A36C0	primary
Capricorn	6063227	544523.17	7264808.21	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	-1 + 0.45mm	\N	\N	\N	-24.73062	117.44026	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000007321C407445C5D4008F2683DAFBA38C0000094D3690A36C0	primary
Capricorn	6063228	546003.10	7264616.25	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	-1 + 0.45mm	\N	\N	\N	-24.73231	117.4549	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000FBEF3E3335D5D40580FA9FB1DBB38C00000049E1E0336C0	primary
Capricorn	6063682	542379.29	7268483.34	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69749	117.41895	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000B8B519E2E65A5D4076BE4A0834B238C0000038AA530136C0	primary
Capricorn	6063683	542579.02	7268298.92	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69915	117.42093	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000070BBF652075B5D409EAE77D2A0B238C000004C7B420136C0	primary
Capricorn	6063684	542629.40	7268233.43	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69974	117.42143	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D1523F840F5B5D4047CEED7DC7B238C00000943E5A0136C0	primary
Capricorn	6063685	543299.38	7267043.25	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.71047	117.42809	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000E8BB67A27C5B5D40549628B186B538C00000CC036F0436C0	primary
Capricorn	6063220	543126.14	7266303.03	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	-1 + 0.45mm	\N	\N	\N	-24.71716	117.4264	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000F3B283F2605B5D40383270203DB738C00000FC0AB30936C0	primary
Capricorn	6063686	543228.86	7267133.16	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.70966	117.42739	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000002CD3802A715B5D403F768F9B51B538C000000C5F500436C0	primary
Capricorn	6063687	543799.46	7267813.45	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.7035	117.43301	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000003C12E63DCD5B5D405E88A1E6BDB338C00000D06F23FD35C0	primary
Capricorn	6063688	543839.61	7267713.67	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.7044	117.43341	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000668FD1CBD35B5D40C4D7E3E1F8B338C00000D0D87CFD35C0	primary
Capricorn	6063279	542048.87	7269271.61	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69038	117.41566	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000B529A7FAB05A5D40598B041362B038C000005472A4FE35C0	primary
Capricorn	6063696	543818.96	7264703.05	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73159	117.4333	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000FEC99BFFD15B5D40157772D0EEBA38C00000303D050F36C0	primary
Capricorn	6063697	543628.91	7263763.58	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.74008	117.43145	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000ACE1AFB0B35B5D40C4CE6F361BBD38C000000C9C881536C0	primary
Capricorn	6063698	544999.69	7264243.07	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73571	117.44499	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000037DD1087915C5D40307630D0FCBB38C00000F8EEF90A36C0	primary
Capricorn	6063699	546889.50	7264763.87	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73095	117.46366	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000001DE99469C35D5D407A3DD6D8C4BA38C0000094573BFD35C0	primary
Capricorn	6063701	546889.50	7264763.87	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73095	117.46366	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000001DE99469C35D5D407A3DD6D8C4BA38C0000094573BFD35C0	primary
Capricorn	6063702	545689.41	7264254.10	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73559	117.45181	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000008787B743015D5D40FDDAA8F1F4BB38C000005CE9FE0636C0	primary
Capricorn	6063703	547999.56	7265534.05	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.72396	117.47461	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000005A6D78D0765E5D40FDD440BFFAB838C0000060EE78F235C0	primary
Capricorn	6063704	547819.43	7265503.67	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.72424	117.47283	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000008017A9A6595E5D409DFB03190DB938C0000054D1ABF335C0	primary
Capricorn	6063705	546249.55	7264523.52	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73314	117.45734	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000E01312DE5B5D5D40D521256154BB38C0000068A2410236C0	primary
Capricorn	3578042	543126.14	7266303.03	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	BX	\N	\N	\N	\N	\N	-24.71716	117.4264	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000F3B283F2605B5D40383270203DB738C00000FC0AB30936C0	primary
Capricorn	3578043	543157.49	7266301.82	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	BX	\N	\N	\N	\N	\N	-24.71717	117.42671	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000EB92B906665B5D40A3C1F0C83DB738C00000B443870936C0	primary
Capricorn	3578044	543533.00	7265743.69	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	\N	\N	\N	\N	-24.7222	117.43044	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000BF7EB323A35B5D40632B716D87B838C0000014EF9F0A36C0	primary
Capricorn	3578045	544523.17	7264808.21	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	\N	\N	\N	\N	-24.73062	117.44026	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000007321C407445C5D4008F2683DAFBA38C0000094D3690A36C0	primary
Capricorn	3578046	544472.49	7264771.84	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	\N	\N	\N	\N	-24.73095	117.43976	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000BBAC0D63B5C5D40A47BDFDCC4BA38C00000145BE90A36C0	primary
Capricorn	3578047	542443.00	7269138.65	0.00	AGD84_50	\N	rock	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SHLE	\N	\N	\N	\N	\N	-24.69157	117.41956	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000936147E0F05A5D40A4E8990EB0B038C000003C7E2CFD35C0	primary
Capricorn	6063582	544225.32	7262428.52	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	-1 + 0.45mm	\N	\N	\N	-24.75212	117.43739	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000002C163E03155C5D401D78354430C038C000008062DE1936C0	primary
Capricorn	6063583	544234.15	7262343.23	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	-1 + 0.45mm	\N	\N	\N	-24.75289	117.43748	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000045C9DC7C165C5D40E570DDBA62C038C0000020D44F1A36C0	primary
Capricorn	6063584	544214.31	7262148.41	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	-1 + 0.45mm	\N	\N	\N	-24.75465	117.43729	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000099A1CA5F135C5D4012C02E13D6C038C00000F01D8D1B36C0	primary
Capricorn	6063585	544229.07	7262022.13	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	QTT	\N	-1 + 0.45mm	\N	\N	\N	-24.75579	117.43744	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000AF71DBD4155C5D40509CA9C920C138C0000098A0321C36C0	primary
Capricorn	6063689	544188.85	7267163.36	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.70936	117.43688	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000003206ECA50C5C5D4070099FEF3DB538C00000202AB0FE35C0	primary
Capricorn	6063690	544018.75	7266154.06	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.71848	117.43523	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000006EA7D59DF15B5D40000D8BA193B738C00000641F7E0536C0	primary
Capricorn	6063691	542409.66	7264853.60	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.73027	117.41936	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000006B88639BED5A5D4080DD415098BA38C00000A0DE261636C0	primary
Capricorn	6063692	543049.70	7265463.95	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.72474	117.42567	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D42816FD545B5D40BFF9C9E42DB938C0000010B7FC0E36C0	primary
Capricorn	6063693	543039.33	7265383.15	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.72547	117.42557	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000061A27859535B5D4066FE61BC5DB938C000007C70830F36C0	primary
Capricorn	6063694	544098.85	7265263.56	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.72652	117.43605	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000C45B730DFF5B5D40E4E0ED89A2B938C000003460300A36C0	primary
Capricorn	6063695	543828.82	7264943.30	0.00	AGD84_50	\N	stream	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.72942	117.43339	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000002C48E878D35B5D40B804729960BA38C000002C26930D36C0	primary
Capricorn	6063280	542081.30	7269290.34	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69021	117.41598	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D136D838B65A5D4046ED1CEE56B038C00000549159FE35C0	primary
Capricorn	6063281	542114.74	7269309.06	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.69004	117.41631	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000F491E8A0BB5A5D4008003FCA4BB038C000003C3C0DFE35C0	primary
Capricorn	6063282	542147.17	7269327.78	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68987	117.41663	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000B80C18DFC05A5D405E63D5A640B038C00000F45EC2FD35C0	primary
Capricorn	6063283	542179.60	7269346.51	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.6897	117.41695	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E61000000E44461DC65A5D4071FDE48135B038C00000DC7D77FD35C0	primary
Capricorn	6063284	542211.02	7269365.24	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68953	117.41726	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000042AA9331CB5A5D40F044695D2AB038C000008C142EFD35C0	primary
Capricorn	6063285	542244.46	7269383.96	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68936	117.41759	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000B033A099D05A5D40C1647F391FB038C0000058BFE1FC35C0	primary
Capricorn	6063286	542309.32	7269421.41	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68902	117.41823	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D260F615DB5A5D4019360EF108B038C00000B8004CFC35C0	primary
Capricorn	6063287	542374.18	7269458.86	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68868	117.41887	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000078CB4892E55A5D40A97191A8F2AF38C000000C42B6FB35C0	primary
Capricorn	6063288	542439.04	7269496.31	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68834	117.41951	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000A573970EF05A5D4089170960DCAF38C00000348320FB35C0	primary
Capricorn	6063289	542503.90	7269533.75	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.688	117.42015	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E6100000D1ACE28AFA5A5D40A10BF918C6AF38C0000018C88AFA35C0	primary
Capricorn	6063290	542568.76	7269571.20	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68766	117.42079	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000024D02907055B5D40948659D0AFAF38C000001809F5F935C0	primary
Capricorn	6063291	542634.63	7269608.65	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	\N	\N	-1 + 0.45mm	\N	\N	\N	-24.68732	117.42144	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000095DF4CAD0F5B5D4006AB358799AF38C000002CD25DF935C0	primary
Capricorn	6063221	543003.79	7266313.37	0.00	AGD84_50	\N	soil	\N	\N	\N	\N	\N	\N	Rio Tinto	\N	\N	SLST	\N	-1 + 0.45mm	\N	\N	\N	-24.71707	117.42519	\N	\N	\N	E52/1393	Waldburg	\N	\N	a62436	\N	20350	br	2012-12-03 17:00:00+01	01010000A0E610000012DA711F4D5B5D4064CF873B37B738C000000494550A36C0	primary
\.


--
-- PostgreSQL database dump complete
--

