from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QSplitter, QWidget

from openlog.gui.assay_visualization.assay_plot_widget import AssayDomainType


class DiagramsMaker:
    def __init__(self, container) -> None:
        """
        Generic class containing methods to plot and add diagrams in PlotWidgetContainer.
        Give access to container and main PlotWidget.
        """
        self.container = container
        self.main = container.main
        self.plotItem = container.plotItem
        self.data = None
        # list of displayed widgets
        self.diagram_list = []
        # splitter to contains widgets. To be added to PlotWidgetContainer
        self.splitter = None
        # splitter index in PlotWidgetContainer
        self.index = None

    def display_diagram_list(self):

        for diagram in self.diagram_list:

            self.splitter.addWidget(diagram)

        if self.index is None:
            self.container.addWidget(self.splitter)
            self.index = self.container.indexOf(self.splitter)
        else:
            self.container.insertWidget(self.index, self.splitter)

    def _set_vertical_splitter(self):

        self.splitter = QSplitter(self.container)
        self.splitter.setOrientation(
            Qt.Vertical if self.main.domain == AssayDomainType.DEPTH else Qt.Horizontal
        )
        self.splitter.setChildrenCollapsible(False)

    def clear_diagrams(self):

        self.diagram_list.clear()

        if not self.splitter:
            return

        while self.splitter.count():
            self.splitter.widget(0).deleteLater()
            self.splitter.widget(0).setParent(None)

        self.splitter.deleteLater()
        self.splitter.setParent(None)
        self.splitter = None

    def _get_diagram(self) -> QWidget:
        """
        Create one diagram. Should be called in `set_diagrams` method
        """
        return NotImplementedError

    def set_diagrams(self):
        """
        Create one or multiple diagrams.
        """
        return NotImplementedError

    def update_main_plot(self):
        """
        Slot designed to be connected to a diagram signal, should act on main plot of PlotWidgetContainer
        """
        pass

    def update_diagram(self):
        """
        Slot designed to be connected to main plot signal.
        """
        pass
