----------------------------------------------------------------------------
-- xplordb
-- 
-- Copyright (C) 2022  Oslandia / OpenLog
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as published
-- by the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <https://www.gnu.org/licenses/>.
-- 
-- __authors__ = ["davidms"]
-- __contact__ = "geology@oslandia.com"
-- __date__ = "2022/02/02"
-- __license__ = "AGPLv3"
----------------------------------------------------------------------------

--
-- PostgreSQL database dump
--

-- Dumped from database version 13.5 (Ubuntu 13.5-0ubuntu0.21.10.1)
-- Dumped by pg_dump version 13.5 (Ubuntu 13.5-0ubuntu0.21.10.1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Data for Name: sample; Type: TABLE DATA; Schema: dh; Owner: postgres
--

COPY dh.sample (data_set, sample_id, hole_id, from_m, to_m, weight_total, hole_diameter, sample_type, sample_method, company, date_sampled, sampled_by, comment, historic_sample_id, data_source, loaded_by, load_date, class, geom_trace) FROM stdin;
Capricorn	6074940	RC00WA001	90	95	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002AAEA162D55A5D403031F8D411B138C078F8C0E7FA207B400000000000805640EAD19CFCD45A5D406074DF1712B138C00DF8F070B2DB7A400000000000C05740
Capricorn	6074941	RC00WA001	95	100	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EAD19CFCD45A5D406074DF1712B138C00DF8F070B2DB7A400000000000C05740AAF59796D45A5D4090B7C65A12B138C0A2F720FA69967A400000000000005940
Capricorn	6074942	RC00WA001	100	105	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AAF59796D45A5D4090B7C65A12B138C0A2F720FA69967A4000000000000059406A199330D45A5D40C0FAAD9D12B138C037F7508321517A400000000000405A40
Capricorn	6074982	RC00WA002	135	140	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AF3A9FC1535C5D4086265247ADBA38C0BA681C7C626F79400000000000E06040DF66A0C1535C5D4029C24D47ADBA38C046171D7C621F79400000000000806140
Capricorn	3578289	WA12/10900	12	17	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000030CF2646275B5D40E3B65AD874B738C06EDB27D43B2F7F4000000000000028405BFB2746275B5D409A5256D874B738C086A128D43BDF7E400000000000003140
Capricorn	3578290	WA12/10900	17	21	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000005BFB2746275B5D409A5256D874B738C086A128D43BDF7E4000000000000031407DEB2846275B5D402DCF52D874B738C0004029D43B9F7E400000000000003540
Capricorn	3652836	WA15/12590	45	49	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004A1F7EE2035D5D409E60443173BB38C0D6C742E3A59F7E400000000000804640700F7FE2035D5D4016DD403173BB38C0004043E3A55F7E400000000000804840
Capricorn	3578201	WA15/12625	36	39	\N	\N	in	u	Rio Tinto	2000-06-20 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000000AF44074095D5D4039D1871466BB38C08A1DC30EABAF7E40000000000000424026A84174095D5D40922E851466BB38C00080C30EAB7F7E400000000000804340
Capricorn	3578235	WA13/11200	15	20	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000047651F9A25B5D40E44313831DB938C000E0FD5E3E7F7E400000000000002E4031A252F9A25B5D4096DF0E831DB938C00080FE5E3E2F7E400000000000003440
Capricorn	3578237	WA13/11200	25	30	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000005ECE53F9A25B5D40487B0A831DB938C00020FF5E3EDF7D4000000000000039408CFA54F9A25B5D40F91606831DB938C000C0FF5E3E8F7D400000000000003E40
Capricorn	3578231	WA14/10975	45	50	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000C84A4DF2D45B5D40DB91EC435CBB38C033136527004F7C400000000000804640FB764EF2D45B5D40932DE8435CBB38C000C0652700FF7B400000000000004940
Capricorn	3578229	WA14/11050	55	60	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004A90B3F0DE5B5D4006B5FE6341BB38C0004097F409EF7B400000000000804B407DBCB4F0DE5B5D40BB50FA6341BB38C08CEE97F4099F7B400000000000004E40
Capricorn	3578230	WA14/11050	60	66	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007DBCB4F0DE5B5D40BB50FA6341BB38C08CEE97F4099F7B400000000000004E40BA24B6F0DE5B5D40950BF56341BB38C000C098F4093F7B400000000000805040
Capricorn	3578226	WA14/11125	40	45	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002817ED5FEC5B5D40334D82BB2DBB38C0398E658C146F7D4000000000000044405A43EE5FEC5B5D40E8E87DBB2DBB38C00040668C141F7D400000000000804640
Capricorn	3578227	WA14/11125	45	50	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000005A43EE5FEC5B5D40E8E87DBB2DBB38C00040668C141F7D4000000000008046408C6FEF5FEC5B5D409C8479BB2DBB38C0C7F1668C14CF7C400000000000004940
Capricorn	3578222	WA14/11275	18	21	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000DBE0C9BDFD5B5D4056CF1B8CFEBA38C0008039A8253F7E400000000000003240F994CABDFD5B5D40C12C198CFEBA38C000003AA8250F7E400000000000003540
Capricorn	3578228	WA14/11125	50	54	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000008C6FEF5FEC5B5D409C8479BB2DBB38C0C7F1668C14CF7C400000000000004940B45FF05FEC5B5D402D0176BB2DBB38C00080678C148F7C400000000000004B40
Capricorn	6074943	RC00WA001	105	110	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006A199330D45A5D40C0FAAD9D12B138C037F7508321517A400000000000405A402A3D8ECAD35A5D40F03D95E012B138C0CCF6800CD90B7A400000000000805B40
Capricorn	6074944	RC00WA001	110	115	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002A3D8ECAD35A5D40F03D95E012B138C0CCF6800CD90B7A400000000000805B40E9608964D35A5D4020817C2313B138C061F6B09590C679400000000000C05C40
Capricorn	6074945	RC00WA001	115	120	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000E9608964D35A5D4020817C2313B138C061F6B09590C679400000000000C05C40A98484FED25A5D4050C4636613B138C0F6F5E01E488179400000000000005E40
Capricorn	6074946	RC00WA001	120	125	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000A98484FED25A5D4050C4636613B138C0F6F5E01E488179400000000000005E4069A87F98D25A5D4080074BA913B138C08BF510A8FF3B79400000000000405F40
Capricorn	6074947	RC00WA001	125	130	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000069A87F98D25A5D4080074BA913B138C08BF510A8FF3B79400000000000405F4029CC7A32D25A5D40B04A32EC13B138C020F54031B7F678400000000000406040
Capricorn	6074931	RC00WA001	45	49	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006A6CCDF8D85A5D4080D4D67A0FB138C03CFC101587907D4000000000008046406AEF2FA7D85A5D40DAA35CB00FB138C04D6237E919597D400000000000804840
Capricorn	6074932	RC00WA001	50	55	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	comp_resampled	01050000E0E61000000100000001020000C0020000002A90C892D85A5D40B017BEBD0FB138C0D1FB409E3E4B7D40FEFFFFFFFFFF4840EAB3C32CD85A5D40E05AA50010B138C066FB7027F6057D400200000000804B40
Capricorn	6074933	RC00WA001	55	60	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	comp_resampled	01050000E0E61000000100000001020000C002000000EAB3C32CD85A5D40E05AA50010B138C066FB7027F6057D400200000000804B40AAD7BEC6D75A5D40109E8C4310B138C0FBFAA0B0ADC07C400200000000004E40
Capricorn	3578223	WA14/11175	35	40	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000CFCE4F9EF15B5D401DA03AEF21BB38C0729C7E54192F7D40000000000080414001FB509EF15B5D40D13B36EF21BB38C0394E7F5419DF7C400000000000004440
Capricorn	3578209	WA14/11500	5	10	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000017EB439F215C5D40AFBEB552D1BA38C00020ADCE40BF7F4000000000000014404717459F215C5D405C5AB152D1BA38C000C0ADCE406F7F400000000000002440
Capricorn	3578251	WA13/10975	15	20	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000005AB0FC2B845B5D40FA1C066C49B938C000E0C943260F7E400000000000002E4089DCFD2B845B5D40AFB8016C49B938C0AB6ACA4326BF7D400000000000003440
Capricorn	3578259	WA13/10975	15	20	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	comp_resampled	01050000E0E61000000100000001020000C0020000005AB0FC2B845B5D40FA1C066C49B938C000E0C943260F7E400000000000002E4089DCFD2B845B5D40AFB8016C49B938C0AB6ACA4326BF7D400000000000003440
Capricorn	6074951	RC00WA001	140	145	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000A9137166D15A5D4010D1007214B138C04AF4A043266C7840000000000080614069376C00D15A5D404014E8B414B138C0DFF3D0CCDD2678400000000000206240
Capricorn	6074921	RC00WA001	0	5	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AB2AF98EDC5A5D40D077B5200DB138C0008030A10900804000000000000000006B4EF428DC5A5D4000BB9C630DB138C095FF90CBCABA7F400000000000001440
Capricorn	6074922	RC00WA001	5	10	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006B4EF428DC5A5D4000BB9C630DB138C095FF90CBCABA7F4000000000000014402B72EFC2DB5A5D4030FE83A60DB138C02AFFC05482757F400000000000002440
Capricorn	6074923	RC00WA001	10	15	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002B72EFC2DB5A5D4030FE83A60DB138C02AFFC05482757F400000000000002440EB95EA5CDB5A5D4060416BE90DB138C0BFFEF0DD39307F400000000000002E40
Capricorn	3578283	WA12/10975	2	7	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004FF123772F5B5D40AABBE12D61B738C0F43C297E43DF7F4000000000000000407A1D25772F5B5D406057DD2D61B738C055D5297E438F7F400000000000001C40
Capricorn	3578242	WA13/11125	20	21	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004B0CCB78995B5D4006D9522433B938C08661A1AA353F7E4000000000000034405448CB78995B5D402AF8512433B938C00080A1AA352F7E400000000000003540
Capricorn	3578243	WA13/11050	0	5	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000C2ACD72E8D5B5D40A12902E740B938C0008076A32C4F7F400000000000000000F0D8D82E8D5B5D4056C5FDE640B938C0390E77A32CFF7E400000000000001440
Capricorn	3578210	WA14/11500	10	15	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004717459F215C5D405C5AB152D1BA38C000C0ADCE406F7F4000000000000024407743469F215C5D400AF6AC52D1BA38C00060AECE401F7F400000000000002E40
Capricorn	3578211	WA14/11500	15	20	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007743469F215C5D400AF6AC52D1BA38C00060AECE401F7F400000000000002E40A76F479F215C5D40B791A852D1BA38C00000AFCE40CF7E400000000000003440
Capricorn	3578212	WA14/11500	20	25	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000A76F479F215C5D40B791A852D1BA38C00000AFCE40CF7E400000000000003440D79B489F215C5D40642DA452D1BA38C000A0AFCE407F7E400000000000003940
Capricorn	6074930	RC00WA001	40	45	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AA48D25ED95A5D405091EF370FB138C0A8FCE08BCFD57D4000000000000044406A6CCDF8D85A5D4080D4D67A0FB138C03CFC101587907D400000000000804640
Capricorn	3578252	WA13/10975	20	25	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000089DCFD2B845B5D40AFB8016C49B938C0AB6ACA4326BF7D400000000000003440B808FF2B845B5D406454FD6B49B938C055F5CA43266F7D400000000000003940
Capricorn	3652828	WA12/10300	30	35	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006C53F406D55A5D401D002ACB25B838C034472F18F25E7D400000000000003E40997FF506D55A5D40E19B25CB25B838C012F32F18F20E7D400000000000804140
Capricorn	3652829	WA12/10300	35	39	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000997FF506D55A5D40E19B25CB25B838C012F32F18F20E7D400000000000804140BE6FF606D55A5D407E1822CB25B838C0907C3018F2CE7C400000000000804340
Capricorn	3652831	WA12/10375	25	30	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000003679E65DDE5A5D404008FC8B0DB838C0C247691EFBCE7E40000000000000394063A5E75DDE5A5D4004A4F78B0DB838C0E9E2691EFB7E7E400000000000003E40
Capricorn	3652832	WA12/10375	30	33	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000063A5E75DDE5A5D4004A4F78B0DB838C0E9E2691EFB7E7E400000000000003E407E59E85DDE5A5D407A01F58B0DB838C000406A1EFB4E7E400000000000804040
Capricorn	3652819	WA12/10525	24	29	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000008F10D1DCF15A5D40FB4A8C03DFB738C014FBFE500D4F7E400000000000003840BC3CD2DCF15A5D40BBE68703DFB738C062A7FF500DFF7D400000000000003D40
Capricorn	6074953	RC00WA001	150	153	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000295B679AD05A5D407057CFF714B138C074F3005695E177400000000000C06240693D315DD05A5D40F3B2F31F15B138C000C01D7503B877400000000000206340
Capricorn	6074952	RC00WA001	145	150	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000069376C00D15A5D404014E8B414B138C0DFF3D0CCDD2678400000000000206240295B679AD05A5D407057CFF714B138C073F3005695E177400000000000C06240
Capricorn	6074924	RC00WA001	15	20	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EB95EA5CDB5A5D4060416BE90DB138C0BFFEF0DD39307F400000000000002E40ABB9E5F6DA5A5D409084522C0EB138C054FE2067F1EA7E400000000000003440
Capricorn	6074925	RC00WA001	20	25	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000ABB9E5F6DA5A5D409084522C0EB138C054FE2067F1EA7E4000000000000034406BDDE090DA5A5D40C0C7396F0EB138C0E9FD50F0A8A57E400000000000003940
Capricorn	3578213	WA14/11500	25	30	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000D79B489F215C5D40642DA452D1BA38C000A0AFCE407F7E40000000000000394007C8499F215C5D4011C99F52D1BA38C00040B0CE402F7E400000000000003E40
Capricorn	3578208	WA15/11875	70	75	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006E592434A45C5D4080B7543846BC38C09A19E74D4FAF7C400000000000805140A0852534A45C5D402553503846BC38C000C0E74D4F5F7C400000000000C05240
Capricorn	6074954	RC00WA002	0	5	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000009E917FC1535C5D4059BCC847ADBA38C00000053EB1EF80400000000000000000CEBD80C1535C5D40FC57C447ADBA38C04657053EB1C78040FFFFFFFFFFFF1340
Capricorn	6074955	RC00WA002	5	10	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000CEBD80C1535C5D40FC57C447ADBA38C04657053EB1C780400000000000001440FEE981C1535C5D409FF3BF47ADBA38C08CAE053EB19F80400000000000002440
Capricorn	6074956	RC00WA002	10	15	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000FEE981C1535C5D409FF3BF47ADBA38C08CAE053EB19F804000000000000024402E1683C1535C5D40428FBB47ADBA38C0D205063EB17780400000000000002E40
Capricorn	3652823	WA12/10450	22	27	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000051098036E75A5D40C66B2405F2B738C05515B261044F7E4000000000000036407E358136E75A5D4088072005F2B738C02FBAB26104FF7D400000000000003B40
Capricorn	3652824	WA12/10450	27	33	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007E358136E75A5D4088072005F2B738C02EBAB26104FF7D400000000000003B40B49D8236E75A5D4071C21A05F2B738C00080B361049F7D400000000000804040
Capricorn	3578206	WA15/12325	70	75	\N	\N	in	u	Rio Tinto	2000-06-20 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004B2FA926E15C5D409FA24B40D0BB38C088081CE083DF7C4000000000008051407B5BAA26E15C5D403A3E4740D0BB38C000C01CE0838F7C400000000000C05240
Capricorn	3578204	WA15/12400	20	22	\N	\N	in	u	Rio Tinto	2000-06-20 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000029E011EEED5C5D40D5283F11A1BB38C02FFA796B92CF7E4000000000000034403C5812EEED5C5D4012673D11A1BB38C000407A6B92AF7E400000000000003640
Capricorn	3578236	WA13/11200	20	25	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000031A252F9A25B5D4096DF0E831DB938C00080FE5E3E2F7E4000000000000034405ECE53F9A25B5D40487B0A831DB938C00020FF5E3EDF7D400000000000003940
Capricorn	6074961	RC00WA002	35	40	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EEC687C1535C5D40CDFDA947ADBA38C0D2C50E7C62AF7F4000000000008041401EF388C1535C5D407099A547ADBA38C05D740F7C625F7F400000000000004440
Capricorn	6074962	RC00WA002	40	45	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000001EF388C1535C5D407099A547ADBA38C05D740F7C625F7F4000000000000044404E1F8AC1535C5D401335A147ADBA38C0E822107C620F7F400000000000804640
Capricorn	6074963	RC00WA002	45	50	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004E1F8AC1535C5D401335A147ADBA38C0E822107C620F7F4000000000008046407E4B8BC1535C5D40B6D09C47ADBA38C074D1107C62BF7E400000000000004940
Capricorn	3652820	WA12/10525	29	34	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BC3CD2DCF15A5D40BBE68703DFB738C062A7FF500DFF7D400000000000003D40E868D3DCF15A5D407B828303DFB738C0B15300510DAF7D400000000000004140
Capricorn	3652821	WA12/10525	34	39	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000E868D3DCF15A5D407B828303DFB738C0B15300510DAF7D4000000000000041401595D4DCF15A5D403B1E7F03DFB738C0000001510D5F7D400000000000804340
Capricorn	3652812	WA12/10600	10	15	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000092176159FC5A5D40EB57A3A1CEB738C000009DBF15CF7E400000000000002440BE436259FC5A5D40A8F39EA1CEB738C000A09DBF157F7E400000000000002E40
Capricorn	3652813	WA12/10600	15	20	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BE436259FC5A5D40A8F39EA1CEB738C000A09DBF157F7E400000000000002E40EB6F6359FC5A5D40668F9AA1CEB738C000409EBF152F7E400000000000003440
Capricorn	3652814	WA12/10600	20	25	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EB6F6359FC5A5D40668F9AA1CEB738C000409EBF152F7E400000000000003440189C6459FC5A5D40242B96A1CEB738C000E09EBF15DF7D400000000000003940
Capricorn	3652815	WA12/10600	25	30	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000189C6459FC5A5D40242B96A1CEB738C000E09EBF15DF7D40000000000000394044C86559FC5A5D40E2C691A1CEB738C000809FBF158F7D400000000000003E40
Capricorn	3652808	WA12/10675	10	15	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000096D98D74095B5D40EAEAEA33ADB738C000F09851222F7F400000000000002440C2058F74095B5D40A686E633ADB738C00068995122DF7E400000000000002E40
Capricorn	3652810	WA12/10675	15	20	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000C2058F74095B5D40A686E633ADB738C00068995122DF7E400000000000002E40EE319074095B5D406222E233ADB738C000E09951228F7E400000000000003440
Capricorn	3652811	WA12/10675	20	24	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EE319074095B5D406222E233ADB738C000E09951228F7E40000000000000344011229174095B5D40F99EDE33ADB738C000409A51224F7E400000000000003840
Capricorn	3578297	WA12/10750	7	12	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000059B381F5125B5D401E82E7799DB738C055CD3A192ABF7F400000000000001C4084DF82F5125B5D40D91DE3799DB738C000603B192A6F7F400000000000002840
Capricorn	3578266	WA13/10750	65	70	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BB1A2639645B5D40A00E95FF9BB938C022A2F073077F7B400000000000405040EB462739645B5D405BAA90FF9BB938C01151F173072F7B400000000000805140
Capricorn	3578267	WA13/10750	70	75	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EB462739645B5D405BAA90FF9BB938C01151F173072F7B4000000000008051401B732839645B5D4015468CFF9BB938C00000F27307DF7A400000000000C05240
Capricorn	3578255	WA13/10825	10	15	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000061D256E86C5B5D405B6EF9327DB938C055E5712311CF7D40000000000000244090FE57E86C5B5D40150AF5327DB938C000787223117F7D400000000000002E40
Capricorn	3578256	WA13/10825	15	20	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000090FE57E86C5B5D40150AF5327DB938C000787223117F7D400000000000002E40C02A59E86C5B5D40CEA5F0327DB938C0AB0A7323112F7D400000000000003440
Capricorn	3578257	WA13/10825	20	24	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000C02A59E86C5B5D40CEA5F0327DB938C0AB0A7323112F7D400000000000003440E61A5AE86C5B5D406322ED327DB938C00080732311EF7C400000000000003840
Capricorn	3578234	WA13/11200	10	15	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000D64950F9A25B5D4033A817831DB938C00040FD5E3ECF7E400000000000002440047651F9A25B5D40E44313831DB938C000E0FD5E3E7F7E400000000000002E40
Capricorn	3578298	WA12/10750	12	17	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000084DF82F5125B5D40D91DE3799DB738C000603B192A6F7F400000000000002840B00B84F5125B5D4094B9DE799DB738C0ABF23B192A1F7F400000000000003140
Capricorn	3578299	WA12/10750	17	24	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000B00B84F5125B5D4094B9DE799DB738C0ABF23B192A1F7F400000000000003140EDAF85F5125B5D409A93D8799DB738C000C03C192AAF7E400000000000003840
Capricorn	3578291	WA12/10825	6	11	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BA0F7F711D5B5D40AE20AC668EB738C000800A53326F7F400000000000001840E53B80711D5B5D4066BCA7668EB738C000200B53321F7F400000000000002640
Capricorn	3578292	WA12/10825	11	16	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000E53B80711D5B5D4066BCA7668EB738C000200B53321F7F400000000000002640116881711D5B5D401E58A3668EB738C000C00B5332CF7E400000000000003040
Capricorn	3578293	WA12/10825	16	21	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000116881711D5B5D401E58A3668EB738C000C00B5332CF7E4000000000000030403C9482711D5B5D40D6F39E668EB738C000600C53327F7E400000000000003540
Capricorn	3578294	WA12/10825	21	26	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000003C9482711D5B5D40D6F39E668EB738C000600C53327F7E40000000000000354067C083711D5B5D408F8F9A668EB738C000000D53322F7E400000000000003A40
Capricorn	3578295	WA12/10825	26	31	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000067C083711D5B5D408F8F9A668EB738C000000D53322F7E400000000000003A4093EC84711D5B5D40472B96668EB738C000A00D5332DF7D400000000000003F40
Capricorn	3578260	WA13/10975	20	24	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	comp_resampled	01050000E0E61000000100000001020000C00200000089DCFD2B845B5D40AFB8016C49B938C0AB6ACA4326BF7D400000000000003440AECCFE2B845B5D404035FE6B49B938C09AD9CA43267F7D400000000000003840
Capricorn	3578261	WA13/10975	25	30	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	comp_resampled	01050000E0E61000000100000001020000C002000000B808FF2B845B5D406454FD6B49B938C055F5CA43266F7D400000000000003940E634002C845B5D401AF0F86B49B938C00080CB43261F7D400000000000003E40
Capricorn	6075692	RC00WA001	55	56	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EAB3C32CD85A5D40E05AA50010B138C066FB7027F6057D400200000000804B40AA545C18D85A5D40B6CE060E10B138C0EA947ADC1AF87C400000000000004C40
Capricorn	6074927	RC00WA001	25	30	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006BDDE090DA5A5D40C0C7396F0EB138C0E9FD50F0A8A57E4000000000000039402B01DC2ADA5A5D40F00A21B20EB138C07EFD807960607E400000000000003E40
Capricorn	6074928	RC00WA001	30	35	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002B01DC2ADA5A5D40F00A21B20EB138C07EFD807960607E400000000000003E40EB24D7C4D95A5D40204E08F50EB138C012FDB002181B7E400000000000804140
Capricorn	6074929	RC00WA001	35	40	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EB24D7C4D95A5D40204E08F50EB138C012FDB002181B7E400000000000804140AA48D25ED95A5D405091EF370FB138C0A8FCE08BCFD57D400000000000004440
Capricorn	3578296	WA12/10825	31	36	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000093EC84711D5B5D40472B96668EB738C000A00D5332DF7D400000000000003F40BE1886711D5B5D40FFC691668EB738C000400E53328F7D400000000000004240
Capricorn	3578287	WA12/10900	2	7	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000DA762446275B5D40747F63D874B738C03D4F26D43BCF7F40000000000000004005A32546275B5D402C1B5FD874B738C0551527D43B7F7F400000000000001C40
Capricorn	3578244	WA13/11050	5	10	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000F0D8D82E8D5B5D4056C5FDE640B938C0390E77A32CFF7E4000000000000014401F05DA2E8D5B5D400B61F9E640B938C0729C77A32CAF7E400000000000002440
Capricorn	3578245	WA13/11050	10	15	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000001F05DA2E8D5B5D400B61F9E640B938C0729C77A32CAF7E4000000000000024404D31DB2E8D5B5D40C0FCF4E640B938C0AB2A78A32C5F7E400000000000002E40
Capricorn	3578246	WA13/11050	15	20	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004D31DB2E8D5B5D40C0FCF4E640B938C0AB2A78A32C5F7E400000000000002E407B5DDC2E8D5B5D407598F0E640B938C0E4B878A32C0F7E400000000000003440
Capricorn	3578262	WA13/10900	20	25	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000008E1C722D7A5B5D403EE49BCE59B938C05515981B1EBF7D400000000000003440BD48732D7A5B5D40F47F97CE59B938C0ABCA981B1E6F7D400000000000003940
Capricorn	3652822	WA12/10450	17	22	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000024DD7E36E75A5D4004D02805F2B738C07C70B161049F7E40000000000000314051098036E75A5D40C66B2405F2B738C05515B261044F7E400000000000003640
Capricorn	3578253	WA13/10975	25	30	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000B808FF2B845B5D406454FD6B49B938C055F5CA43266F7D400000000000003940E634002C845B5D401AF0F86B49B938C00080CB43261F7D400000000000003E40
Capricorn	6074957	RC00WA002	15	20	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002E1683C1535C5D40428FBB47ADBA38C0D205063EB17780400000000000002E405E4284C1535C5D40E42AB747ADBA38C0175D063EB14F80400000000000003440
Capricorn	6074958	RC00WA002	20	25	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000005E4284C1535C5D40E42AB747ADBA38C0175D063EB14F804000000000000034408E6E85C1535C5D4087C6B247ADBA38C05DB4063EB12780400000000000003940
Capricorn	6074959	RC00WA002	25	30	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000008E6E85C1535C5D4087C6B247ADBA38C05DB4063EB12780400000000000003940BE9A86C1535C5D402A62AE47ADBA38C046170E7C62FF7F400000000000003E40
Capricorn	3578258	WA13/10975	10	15	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	comp_resampled	01050000E0E61000000100000001020000C0020000002C84FB2B845B5D4044810A6C49B938C05555C943265F7E4000000000000024405AB0FC2B845B5D40FA1C066C49B938C000E0C943260F7E400000000000002E40
Capricorn	6074960	RC00WA002	30	35	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BE9A86C1535C5D402A62AE47ADBA38C046170E7C62FF7F400000000000003E40EEC687C1535C5D40CDFDA947ADBA38C0D2C50E7C62AF7F400000000000804140
Capricorn	3578207	WA15/12100	60	67	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000008B11032BC35C5D409F53E3C013BC38C05823228768EF7C400000000000004E40D0B5042BC35C5D407F2DDDC013BC38C000002387687F7C400000000000C05040
Capricorn	3578247	WA13/11050	20	27	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007B5DDC2E8D5B5D407598F0E640B938C0E4B878A32C0F7E400000000000003440BC01DE2E8D5B5D407372EAE640B938C0008079A32C9F7D400000000000003B40
Capricorn	6074971	RC00WA002	85	90	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000CE8093C1535C5D402A127E47ADBA38C04697157C628F7C400000000000405540FEAC94C1535C5D40CCAD7947ADBA38C0D245167C623F7C400000000000805640
Capricorn	6074972	RC00WA002	90	95	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000FEAC94C1535C5D40CCAD7947ADBA38C0D245167C623F7C4000000000008056402ED995C1535C5D406F497547ADBA38C05DF4167C62EF7B400000000000C05740
Capricorn	6074973	RC00WA002	95	100	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002ED995C1535C5D406F497547ADBA38C05DF4167C62EF7B400000000000C057405E0597C1535C5D4012E57047ADBA38C0E9A2177C629F7B400000000000005940
Capricorn	3652837	WA15/12440	50	55	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000CE0F2902F35C5D40A3E7FA3299BB38C0F8E01F7E960F7E400000000000004940FE3B2A02F35C5D403A83F63299BB38C0AB8A207E96BF7D400000000000804B40
Capricorn	3652838	WA15/12440	55	60	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000FE3B2A02F35C5D403A83F63299BB38C0AB8A207E96BF7D400000000000804B402E682B02F35C5D40D21EF23299BB38C05D34217E966F7D400000000000004E40
Capricorn	3652839	WA15/12440	60	66	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002E682B02F35C5D40D21EF23299BB38C05D34217E966F7D400000000000004E4067D02C02F35C5D4088D9EC3299BB38C00000227E960F7D400000000000805040
Capricorn	3578203	WA15/12475	17	21	\N	\N	in	u	Rio Tinto	2000-06-20 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000DCAC4716F85C5D407716D9829ABB38C0B7AD232099BF7E400000000000003140029D4816F85C5D40F092D5829ABB38C000402420997F7E400000000000003540
Capricorn	3578202	WA15/12550	22	27	\N	\N	in	u	Rio Tinto	2000-06-20 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000F399B471005D5D40A71C808187BB38C05F8231C7A05F7F40000000000000364022C6B571005D5D403EB87B8187BB38C0004032C7A00F7F400000000000003B40
Capricorn	3652833	WA15/12590	30	35	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BD9A7AE2035D5D40DD8D513173BB38C0390541E3A58F7F400000000000003E40ECC67BE2035D5D4073294D3173BB38C06E9B41E3A53F7F400000000000804140
Capricorn	3652834	WA15/12590	35	40	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000ECC67BE2035D5D4073294D3173BB38C06E9B41E3A53F7F4000000000008041401BF37CE2035D5D4009C5483173BB38C0A23142E3A5EF7E400000000000004440
Capricorn	3652835	WA15/12590	40	45	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000001BF37CE2035D5D4009C5483173BB38C0A23142E3A5EF7E4000000000000044404A1F7EE2035D5D409E60443173BB38C0D6C742E3A59F7E400000000000804640
Capricorn	3578205	WA15/12325	65	70	\N	\N	in	u	Rio Tinto	2000-06-20 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000001A03A826E15C5D4004075040D0BB38C011511BE0832F7D4000000000004050404B2FA926E15C5D409FA24B40D0BB38C089081CE083DF7C400000000000805140
Capricorn	6075691	RC00WA001	54	55	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002A132B41D85A5D400AE743F30FB138C0E2616772D1137D400000000000004B40EAB3C32CD85A5D40E05AA50010B138C066FB7027F6057D400200000000804B40
Capricorn	6075693	RC00WA001	56	57	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AA545C18D85A5D40B6CE060E10B138C0EA947ADC1AF87C400000000000004C406AF5F403D85A5D408D42681B10B138C06E2E84913FEA7C400000000000804C40
Capricorn	6075694	RC00WA001	57	58	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006AF5F403D85A5D408D42681B10B138C06E2E84913FEA7C400000000000804C402A968DEFD75A5D4063B6C92810B138C0F3C78D4664DC7C400000000000004D40
Capricorn	6075690	RC00WA001	53	54	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006A729255D85A5D403373E2E50FB138C05EC85DBDAC217D400000000000804A402A132B41D85A5D400AE743F30FB138C0E2616772D1137D400000000000004B40
Capricorn	6075695	RC00WA001	58	59	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002A968DEFD75A5D4063B6C92810B138C0F3C78D4664DC7C400000000000004D40EA3626DBD75A5D403A2A2B3610B138C0776197FB88CE7C400000000000804D40
Capricorn	6075696	RC00WA001	59	60	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EA3626DBD75A5D403A2A2B3610B138C0776197FB88CE7C400000000000804D40AAD7BEC6D75A5D40109E8C4310B138C0FBFAA0B0ADC07C400200000000004E40
Capricorn	6075688	RC00WA001	51	52	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EA30617ED85A5D40868B1FCB0FB138C055954A53633D7D400000000000804940AAD1F969D85A5D405DFF80D80FB138C0DA2E5408882F7D400000000000004A40
Capricorn	6075689	RC00WA001	52	53	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AAD1F969D85A5D405DFF80D80FB138C0DA2E5408882F7D400000000000004A406A729255D85A5D403373E2E50FB138C05EC85DBDAC217D400000000000804A40
Capricorn	6074937	RC00WA001	75	80	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EA42B094D65A5D40A067420C11B138C0BAF9304CD4F07B400000000000C05240AA66AB2ED65A5D40D0AA294F11B138C04FF960D58BAB7B400000000000005440
Capricorn	3578284	WA12/10975	7	12	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007A1D25772F5B5D406057DD2D61B738C055D5297E438F7F400000000000001C40A44926772F5B5D4016F3D82D61B738C0B76D2A7E433F7F400000000000002840
Capricorn	3578285	WA12/10975	12	16	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000A44926772F5B5D4016F3D82D61B738C0B76D2A7E433F7F400000000000002840C63927772F5B5D40A76FD52D61B738C09EE72A7E43FF7E400000000000003040
Capricorn	3578286	WA12/10975	16	21	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000C63927772F5B5D40A76FD52D61B738C09EE72A7E43FF7E400000000000003040F16528772F5B5D405D0BD12D61B738C000802B7E43AF7E400000000000003540
Capricorn	3578279	WA12/11050	2	7	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004D5D580C3E5B5D400CC01CF746B738C0F47CD4C14F2F7F4000000000000000407889590C3E5B5D40BE5B18F746B738C05515D5C14FDF7E400000000000001C40
Capricorn	3578280	WA12/11050	7	12	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007889590C3E5B5D40BE5B18F746B738C05515D5C14FDF7E400000000000001C40A3B55A0C3E5B5D4071F713F746B738C0B7ADD5C14F8F7E400000000000002840
Capricorn	3578281	WA12/11050	12	17	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000A3B55A0C3E5B5D4071F713F746B738C0B7ADD5C14F8F7E400000000000002840CEE15B0C3E5B5D4024930FF746B738C01846D6C14F3F7E400000000000003140
Capricorn	3578282	WA12/11050	17	21	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000CEE15B0C3E5B5D4024930FF746B738C01846D6C14F3F7E400000000000003140F0D15C0C3E5B5D40B30F0CF746B738C000C0D6C14FFF7D400000000000003540
Capricorn	3578278	WA13/10525	64	69	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000ABAA7B9A445B5D40409B731FE2B938C068143DC7EABE7B400000000000005040DCD67C9A445B5D4001376F1FE2B938C000C03DC7EA6E7B400000000000405140
Capricorn	3578274	WA13/10600	54	60	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000CB62B5164F5B5D40FE3470DFC9B938C0BA687271F46E7B400000000000004B4005CBB6164F5B5D40E2EF6ADFC9B938C05D347371F40E7B400000000000004E40
Capricorn	3578277	WA13/10600	60	65	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000005CBB6164F5B5D40E2EF6ADFC9B938C05D347371F40E7B400000000000004E4036F7B7164F5B5D409F8B66DFC9B938C010DE7371F4BE7A400000000000405040
Capricorn	3578268	WA13/10675	46	50	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000B783C8645A5B5D4058647585A4B938C022220C9F00CF7C400000000000004740DE73C9645A5B5D40EFE07185A4B938C0ABAA0C9F008F7C400000000000004940
Capricorn	3578269	WA13/10675	50	55	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000DE73C9645A5B5D40EFE07185A4B938C0ABAA0C9F008F7C4000000000000049400EA0CA645A5B5D40AB7C6D85A4B938C055550D9F003F7C400000000000804B40
Capricorn	3578270	WA13/10675	55	60	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000000EA0CA645A5B5D40AB7C6D85A4B938C055550D9F003F7C400000000000804B403ECCCB645A5B5D4066186985A4B938C000000E9F00EF7B400000000000004E40
Capricorn	3578271	WA13/10675	60	65	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000003ECCCB645A5B5D4066186985A4B938C000000E9F00EF7B400000000000004E406FF8CC645A5B5D4022B46485A4B938C0ABAA0E9F009F7B400000000000405040
Capricorn	3578272	WA13/10675	65	70	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006FF8CC645A5B5D4022B46485A4B938C0ABAA0E9F009F7B4000000000004050409F24CE645A5B5D40DE4F6085A4B938C055550F9F004F7B400000000000805140
Capricorn	3578273	WA13/10675	70	75	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000009F24CE645A5B5D40DE4F6085A4B938C055550F9F004F7B400000000000805140CF50CF645A5B5D409AEB5B85A4B938C00000109F00FF7A400000000000C05240
Capricorn	3578264	WA13/10750	57	60	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006E3A2439645B5D4076159CFF9BB938C03D8AEF7307FF7B400000000000804C408BEE2439645B5D40E67299FF9BB938C033F3EF7307CF7B400000000000004E40
Capricorn	3578265	WA13/10750	60	65	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000008BEE2439645B5D40E67299FF9BB938C033F3EF7307CF7B400000000000004E40BB1A2639645B5D40A00E95FF9BB938C022A2F073077F7B400000000000405040
Capricorn	3652818	WA12/10525	19	24	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000062E4CFDCF15A5D403BAF9003DFB738C0C54EFE500D9F7E4000000000000033408F10D1DCF15A5D40FB4A8C03DFB738C014FBFE500D4F7E400000000000003840
Capricorn	3578263	WA13/10900	25	30	\N	\N	in	u	Rio Tinto	2000-06-23 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BD48732D7A5B5D40F47F97CE59B938C0ABCA981B1E6F7D400000000000003940EC74742D7A5B5D40AB1B93CE59B938C00080991B1E1F7D400000000000003E40
Capricorn	3578248	WA13/10975	5	10	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000FE57FA2B845B5D408EE50E6C49B938C0ABCAC84326AF7E4000000000000014402C84FB2B845B5D4044810A6C49B938C05555C943265F7E400000000000002440
Capricorn	3578249	WA13/10975	10	15	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002C84FB2B845B5D4044810A6C49B938C05555C943265F7E4000000000000024405AB0FC2B845B5D40FA1C066C49B938C000E0C943260F7E400000000000002E40
Capricorn	6074938	RC00WA001	80	85	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AA66AB2ED65A5D40D0AA294F11B138C04FF960D58BAB7B4000000000000054406A8AA6C8D55A5D4000EE109211B138C0E4F8905E43667B400000000000405540
Capricorn	6074939	RC00WA001	85	90	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006A8AA6C8D55A5D4000EE109211B138C0E4F8905E43667B4000000000004055402AAEA162D55A5D403031F8D411B138C078F8C0E7FA207B400000000000805640
Capricorn	6075686	RC00WA001	49	50	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006AEF2FA7D85A5D40DAA35CB00FB138C04D6237E919597D4000000000008048402A90C892D85A5D40B017BEBD0FB138C0D1FB409E3E4B7D40FEFFFFFFFFFF4840
Capricorn	6075687	RC00WA001	50	51	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002A90C892D85A5D40B017BEBD0FB138C0D1FB409E3E4B7D40FEFFFFFFFFFF4840EA30617ED85A5D40868B1FCB0FB138C055954A53633D7D400000000000804940
Capricorn	6074948	RC00WA001	130	135	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000029CC7A32D25A5D40B04A32EC13B138C020F54031B7F678400000000000406040E9EF75CCD15A5D40E08D192F14B138C0B5F470BA6EB178400000000000E06040
Capricorn	6074949	RC00WA001	135	140	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000E9EF75CCD15A5D40E08D192F14B138C0B5F470BA6EB178400000000000E06040A9137166D15A5D4010D1007214B138C04AF4A043266C78400000000000806140
Capricorn	6074985	RC00WA002	150	154	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000003FBFA2C1535C5D406FF94447ADBA38C05D741E7C627F78400000000000C0624065AFA3C1535C5D40F1754147ADBA38C000001F7C623F78400000000000406340
Capricorn	3652841	WA10/11350	70	75	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000DDFC5A2AC35A5D40E321BAECE8B238C09AD9DF6CBA5F7B400000000000805140FF285C2AC35A5D4088BDB5ECE8B238C00080E06CBA0F7B400000000000C05240
Capricorn	6074984	RC00WA002	145	150	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000000F93A1C1535C5D40CC5D4947ADBA38C0D1C51D7C62CF784000000000002062403FBFA2C1535C5D406FF94447ADBA38C05D741E7C627F78400000000000C06240
Capricorn	6074983	RC00WA002	140	145	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000DF66A0C1535C5D4029C24D47ADBA38C046171D7C621F794000000000008061400F93A1C1535C5D40CC5D4947ADBA38C0D1C51D7C62CF78400000000000206240
Capricorn	3652840	WA10/11200	54	59	\N	\N	in	u	Rio Tinto	2000-06-25 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000000211BDAFAE5A5D4068920A3F10B338C04A1D86CEA80F7C400000000000004B40243DBEAFAE5A5D40102E063F10B338C000C086CEA8BF7B400000000000804D40
Capricorn	3652827	WA12/10300	25	30	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000003E27F306D55A5D4059642ECB25B838C0569B2E18F2AE7D4000000000000039406C53F406D55A5D401D002ACB25B838C034472F18F25E7D400000000000003E40
Capricorn	3652816	WA12/10525	9	14	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000098CCDDCF15A5D40BB779903DFB738C027F6FC500D3F7F40000000000000224035B8CEDCF15A5D407B139503DFB738C076A2FD500DEF7E40FEFFFFFFFFFF2B40
Capricorn	3652817	WA12/10525	14	19	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000035B8CEDCF15A5D407B139503DFB738C076A2FD500DEF7E40FEFFFFFFFFFF2B4062E4CFDCF15A5D403BAF9003DFB738C0C54EFE500D9F7E400000000000003340
Capricorn	3578238	WA13/11125	0	5	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000945BC678995B5D40386A642433B938C000009FAA357F7F400000000000000000C287C778995B5D40EC05602433B938C062989FAA352F7F400000000000001440
Capricorn	3578288	WA12/10900	7	12	\N	\N	in	u	Rio Tinto	2000-06-24 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000005A32546275B5D402C1B5FD874B738C0551527D43B7F7F400000000000001C4030CF2646275B5D40E3B65AD874B738C06EDB27D43B2F7F400000000000002840
Capricorn	6075698	RC00WA001	61	62	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006A7857B2D75A5D40E611EE5010B138C07F94AA65D2B27C400000000000804E402A19F09DD75A5D40BD854F5E10B138C0032EB41AF7A47C400000000000004F40
Capricorn	6075699	RC00WA001	62	63	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002A19F09DD75A5D40BD854F5E10B138C0032EB41AF7A47C400000000000004F40EAB98889D75A5D4093F9B06B10B138C088C7BDCF1B977C400000000000804F40
Capricorn	6075700	RC00WA001	63	65	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EAB98889D75A5D4093F9B06B10B138C088C7BDCF1B977C400000000000804F406AFBB960D75A5D4040E1738610B138C090FAD039657B7C400000000000405040
Capricorn	6075697	RC00WA001	60	61	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AAD7BEC6D75A5D40109E8C4310B138C0FBFAA0B0ADC07C400200000000004E406A7857B2D75A5D40E611EE5010B138C07F94AA65D2B27C400000000000804E40
Capricorn	6074935	RC00WA001	65	70	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006AFBB960D75A5D4040E1738610B138C090FAD039657B7C4000000000004050402A1FB5FAD65A5D4070245BC910B138C025FA00C31C367C400000000000805140
Capricorn	6074936	RC00WA001	70	75	\N	\N	in	u	Rio Tinto	2000-10-12 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000002A1FB5FAD65A5D4070245BC910B138C025FA00C31C367C400000000000805140EA42B094D65A5D40A067420C11B138C0BAF9304CD4F07B400000000000C05240
Capricorn	3578239	WA13/11125	5	10	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000C287C778995B5D40EC05602433B938C062989FAA352F7F400000000000001440EFB3C878995B5D409FA15B2433B938C0C330A0AA35DF7E400000000000002440
Capricorn	3578240	WA13/11125	10	15	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EFB3C878995B5D409FA15B2433B938C0C330A0AA35DF7E4000000000000024401DE0C978995B5D40533D572433B938C025C9A0AA358F7E400000000000002E40
Capricorn	3578241	WA13/11125	15	20	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000001DE0C978995B5D40533D572433B938C025C9A0AA358F7E400000000000002E404B0CCB78995B5D4006D9522433B938C08661A1AA353F7E400000000000003440
Capricorn	3578232	WA13/11200	0	5	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007BF14DF9A25B5D40D07020831DB938C00000FC5E3E6F7F400000000000000000A81D4FF9A25B5D40820C1C831DB938C000A0FC5E3E1F7F400000000000001440
Capricorn	3578233	WA13/11200	5	10	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000A81D4FF9A25B5D40820C1C831DB938C000A0FC5E3E1F7F400000000000001440D64950F9A25B5D4033A817831DB938C00040FD5E3ECF7E400000000000002440
Capricorn	6074974	RC00WA002	100	105	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000005E0597C1535C5D4012E57047ADBA38C0E9A2177C629F7B4000000000000059408E3198C1535C5D40B5806C47ADBA38C07451187C624F7B400000000000405A40
Capricorn	6074975	RC00WA002	105	110	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000008E3198C1535C5D40B5806C47ADBA38C07451187C624F7B400000000000405A40BE5D99C1535C5D40581C6847ADBA38C00000197C62FF7A400000000000805B40
Capricorn	6074977	RC00WA002	110	115	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000BE5D99C1535C5D40581C6847ADBA38C00000197C62FF7A400000000000805B40EE899AC1535C5D40FBB76347ADBA38C08CAE197C62AF7A400000000000C05C40
Capricorn	6074978	RC00WA002	115	120	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000EE899AC1535C5D40FBB76347ADBA38C08CAE197C62AF7A400000000000C05C401EB69BC1535C5D409E535F47ADBA38C0175D1A7C625F7A400000000000005E40
Capricorn	6074979	RC00WA002	120	125	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000001EB69BC1535C5D409E535F47ADBA38C0175D1A7C625F7A400000000000005E404EE29CC1535C5D4040EF5A47ADBA38C0A30B1B7C620F7A400000000000405F40
Capricorn	6074980	RC00WA002	125	130	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000004EE29CC1535C5D4040EF5A47ADBA38C0A30B1B7C620F7A400000000000405F407F0E9EC1535C5D40E38A5647ADBA38C02FBA1B7C62BF79400000000000406040
Capricorn	6074981	RC00WA002	130	135	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007F0E9EC1535C5D40E38A5647ADBA38C02FBA1B7C62BF79400000000000406040AF3A9FC1535C5D4086265247ADBA38C0BA681C7C626F79400000000000E06040
Capricorn	6074964	RC00WA002	50	55	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000007E4B8BC1535C5D40B6D09C47ADBA38C074D1107C62BF7E400000000000004940AE778CC1535C5D40586C9847ADBA38C00080117C626F7E40FEFFFFFFFF7F4B40
Capricorn	6074965	RC00WA002	55	60	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AE778CC1535C5D40586C9847ADBA38C00080117C626F7E40FEFFFFFFFF7F4B40DEA38DC1535C5D40FB079447ADBA38C08C2E127C621F7E400000000000004E40
Capricorn	6074966	RC00WA002	60	65	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000DEA38DC1535C5D40FB079447ADBA38C08C2E127C621F7E400000000000004E400ED08EC1535C5D409EA38F47ADBA38C017DD127C62CF7D400000000000405040
Capricorn	6074967	RC00WA002	65	70	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000000ED08EC1535C5D409EA38F47ADBA38C017DD127C62CF7D4000000000004050403EFC8FC1535C5D40413F8B47ADBA38C0A38B137C627F7D400000000000805140
Capricorn	6074968	RC00WA002	70	75	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000003EFC8FC1535C5D40413F8B47ADBA38C0A38B137C627F7D4000000000008051406E2891C1535C5D40E4DA8647ADBA38C02E3A147C622F7D400000000000C05240
Capricorn	6074969	RC00WA002	75	80	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000006E2891C1535C5D40E4DA8647ADBA38C02E3A147C622F7D400000000000C052409E5492C1535C5D4087768247ADBA38C0BAE8147C62DF7C400000000000005440
Capricorn	6074970	RC00WA002	80	85	\N	\N	in	u	Rio Tinto	2000-10-13 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000009E5492C1535C5D4087768247ADBA38C0BAE8147C62DF7C400000000000005440CE8093C1535C5D402A127E47ADBA38C04697157C628F7C400000000000405540
Capricorn	3578224	WA14/11175	40	45	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000001FB509EF15B5D40D13B36EF21BB38C0394E7F5419DF7C4000000000000044403327529EF15B5D4084D731EF21BB38C000008054198F7C400000000000804640
Capricorn	3578221	WA14/11275	13	18	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000AAB4C8BDFD5B5D40A433208CFEBA38C0ABAA38A8258F7E400000000000002A40DBE0C9BDFD5B5D4056CF1B8CFEBA38C0008039A8253F7E400000000000003240
Capricorn	3578217	WA14/11350	5	10	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000C15DB935095C5D40422AFE43E8BA38C0DBB610902FDF7E400000000000001440F289BA35095C5D40F1C5F943E8BA38C0B76D11902F8F7E400000000000002440
Capricorn	3578218	WA14/11350	10	15	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000F289BA35095C5D40F1C5F943E8BA38C0B76D11902F8F7E40000000000000244022B6BB35095C5D40A161F543E8BA38C0922412902F3F7E400000000000002E40
Capricorn	3578219	WA14/11350	15	20	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000022B6BB35095C5D40A161F543E8BA38C0922412902F3F7E400000000000002E4053E2BC35095C5D4051FDF043E8BA38C06EDB12902FEF7D400000000000003440
Capricorn	3578220	WA14/11350	20	21	\N	\N	in	u	Rio Tinto	2000-06-22 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C00200000053E2BC35095C5D4051FDF043E8BA38C06EDB12902FEF7D4000000000000034405D1EBD35095C5D40741CF043E8BA38C0000013902FDF7D400000000000003540
Capricorn	3578214	WA14/11425	5	10	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000A9BAB72B155C5D40981E5EFAD1BA38C018C69DBE39DF7F400000000000001440D9E6B82B155C5D4047BA59FAD1BA38C0318C9EBE398F7F400000000000002440
Capricorn	3578215	WA14/11425	10	15	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C002000000D9E6B82B155C5D4047BA59FAD1BA38C0318C9EBE398F7F4000000000000024400913BA2B155C5D40F65555FAD1BA38C049529FBE393F7F400000000000002E40
Capricorn	3578216	WA14/11425	15	21	\N	\N	in	u	Rio Tinto	2000-06-21 18:00:00+02	\N	\N	\N	a62436	br	2012-12-03 17:00:00+01	primary	01050000E0E61000000100000001020000C0020000000913BA2B155C5D40F65555FAD1BA38C049529FBE393F7F400000000000002E40427BBB2B155C5D40C81050FAD1BA38C00040A0BE39DF7E400000000000003540
\.


--
-- PostgreSQL database dump complete
--

