# -*- coding: utf-8 -*-

"""
/***************************************************************************
 OpenHLZ
                                 A QGIS plugin
 Open-source HLZ Identification Plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-08-13
        copyright            : (C) 2026 by CustomCartographix
        email                : john@customcartographix.com
        version              : 2.0.0
        version date         : 2026-01-31
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This script contains the main provider for the openHLZ processing     *
 *   plugin.                                                               *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'CustomCartographix'
__date__ = '2026-01-31'
__copyright__ = '(C) 2026 by CustomCartographix'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .openhlz_algorithm import (IdentifyHLZsFromLatLng,
                                IdentifyHLZsFromPoint,
                                IdentifyHLZsFromAoi,
                                IdentifyHLZsFromExistingData)
from qgis.PyQt.QtGui import QIcon
from os import path


class OpenHLZProvider(QgsProcessingProvider):

    def __init__(self):
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(IdentifyHLZsFromLatLng())
        self.addAlgorithm(IdentifyHLZsFromPoint())
        self.addAlgorithm(IdentifyHLZsFromAoi())
        self.addAlgorithm(IdentifyHLZsFromExistingData())

    def id(self):
        """
        Returns the unique provider id
        """
        return 'OpenHLZ'

    def name(self):
        """
        Returns the provider name
        """
        return self.tr('OpenHLZ')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(path.dirname(__file__) + "/images/heli_icon.svg")

    def longName(self):
        """
        Returns a longer version of the provider name
        """
        return 'OpenHLZ v1.0.0'
