# -*- coding: utf-8 -*-

"""
/***************************************************************************
 opencage_geocoder
                                 A QGIS plugin
 Geocoding using the OpenCage API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-11
        copyright            : (C) 2023 by opencage
        email                : info@byteroad.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'doublebyte'
__date__ = '2023-01-11'
__copyright__ = '(C) 2023 by opencage'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import QgsProcessingProvider
from .forward import ForwardGeocode
from .reverse import ReverseGeocode

from opencage_geocoder.gui.gui_utils import GuiUtils

# import logging
# logging.basicConfig(filename='/tmp/opencage.log', encoding='utf-8', level=logging.DEBUG)

class OpenCageProvider(QgsProcessingProvider):
    """
    Defines the OpenCage provider.

    As with all Processing provider algorithms, it extends the QgsProcessingProvider
    class.
    """

    def __init__(self):
        super().__init__()
        self.api_key = None
        self.region = None

        # logging.debug("START*****************")

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """     
        self.addAlgorithm(ForwardGeocode())
        self.addAlgorithm(ReverseGeocode())

    def icon(self):
        """
        Returns the provider's icon
        """
        return GuiUtils.get_icon("icon.svg")

    def svgIconPath(self):
        """
        Returns a path to the provider's icon as a SVG file
        """
        return GuiUtils.get_icon_svg("icon.svg")

    def name(self):
        """
        Display name for provider
        """
        return self.tr('OpenCage')

    def versionInfo(self):
        """
        Provider plugin version
        """
        return "0.0.1"

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'opencage'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('OpenCage')

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()

    def set_config(self, api_key, region):
        """
        Sets the api key
        """
        self.api_key = api_key
        self.region = region
        self.refreshAlgorithms()

    def tr(self, string, context=''):
        """
        Translates a string
        """
        if context == '':
            context = 'OpenCage'
        return QCoreApplication.translate(context, string)