# -*- coding: utf-8 -*-

"""
/***************************************************************************
 opencage_geocoder
                                 A QGIS plugin
 Geocoding using the OpenCage API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-11
        copyright            : (C) 2023 by opencage
        email                : info@byteroad.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'doublebyte'
__date__ = '2023-01-11'
__copyright__ = '(C) 2023 by opencage'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication, QVariant, QObject

# import logging
# logging.basicConfig(filename='/tmp/opencage.log', encoding='utf-8', level=logging.DEBUG)

class LocaleHelper(QObject):
    """
    Helper class to setup language and country strings.

    To be shared by forward and reverse geocoding.
    """

    def __init__(self):
        """
        Initialize language and country arrays.
        """

        QObject.__init__(self)
        self.setupLanguages()
        self.setupCountries()


    def parseLanguage(self, lang):
        """
        Given an index, return the language subcode.
        """

        SubCodes= [
                    "native",
                    "af",
                    "am",
                    "ar",
                    "arn",
                    "as",
                    "az",
                    "ba",
                    "be",
                    "bg",
                    "bn",
                    "bo",
                    "br",
                    "bs",
                    "ca",
                    "co",
                    "cs",
                    "cy",
                    "da",
                    "de",
                    "dsb",
                    "dv",
                    "el",
                    "en",
                    "es",
                    "et",
                    "eu",
                    "fa",
                    "fi",
                    "fil",
                    "fo",
                    "fr",
                    "fy",
                    "ga",
                    "gd",
                    "gl",
                    "gsw",
                    "gu",
                    "ha",
                    "he",
                    "hi",
                    "hr",
                    "hsb",
                    "hu",
                    "hy",
                    "id",
                    "ig",
                    "ii",
                    "is",
                    "it",
                    "iu",
                    "ja",
                    "ka",
                    "kk",
                    "kl",
                    "km",
                    "kn",
                    "ko",
                    "kok",
                    "ky",
                    "lb",
                    "lo",
                    "lt",
                    "lv",
                    "mi",
                    "mk",
                    "ml",
                    "mn",
                    "moh",
                    "mr",
                    "ms",
                    "mt",
                    "my",
                    "nb",
                    "ne",
                    "nl",
                    "nn",
                    "no",
                    "st",
                    "oc",
                    "or",
                    "pa",
                    "pl",
                    "prs",
                    "ps",
                    "pt",
                    "quc",
                    "qu",
                    "rm",
                    "ro",
                    "ru",
                    "rw",
                    "sa",
                    "sah",
                    "se",
                    "si",
                    "sk",
                    "sl",
                    "sma",
                    "smj",
                    "smn",
                    "sms",
                    "sq",
                    "sr",
                    "sv",
                    "sw",
                    "syc",
                    "ta",
                    "te",
                    "tg",
                    "th",
                    "tk",
                    "tn",
                    "tr",
                    "tt",
                    "tzm",
                    "ug",
                    "uk",
                    "ur",
                    "uz",
                    "vi",
                    "wo",
                    "xh",
                    "yo",
                    "zh",
                    "zu",
        ]

        return SubCodes[lang]

    def setupLanguages(self):
        """
        Intitialize the language array.
        The indexes on this array, match the ones on the subcode array.
        """

        self.languages = [self.tr('native'),
                            self.tr("Afrikaans"),
                            self.tr("Amharic"),
                            self.tr("Arabic"),
                            self.tr("Mapudungun"),
                            self.tr("Assamese"),
                            self.tr("Azerbaijani"),
                            self.tr("Bashkir"),
                            self.tr("Belarusian"),
                            self.tr("Bulgarian"),
                            self.tr("Bengali"),
                            self.tr("Tibetan"),
                            self.tr("Breton"),
                            self.tr("Bosnian"),
                            self.tr("Catalan"),
                            self.tr("Corsican"),
                            self.tr("Czech"),
                            self.tr("Welsh"),
                            self.tr("Danish"),
                            self.tr("German"),
                            self.tr("Lower Sorbian"),
                            self.tr("Divehi"),
                            self.tr("Greek"),
                            self.tr("English"),
                            self.tr("Spanish"),
                            self.tr("Estonian"),
                            self.tr("Basque"),
                            self.tr("Persian"),
                            self.tr("Finnish"),
                            self.tr("Filipino"),
                            self.tr("Faroese"),
                            self.tr("French"),
                            self.tr("Frisian"),
                            self.tr("Irish"),
                            self.tr("Scottish Gaelic"),
                            self.tr("Galician"),
                            self.tr("Alsatian"),
                            self.tr("Gujarati"),
                            self.tr("Hausa"),
                            self.tr("Hebrew"),
                            self.tr("Hindi"),
                            self.tr("Croatian"),
                            self.tr("Upper Sorbian"),
                            self.tr("Hungarian"),
                            self.tr("Armenian"),
                            self.tr("Indonesian"),
                            self.tr("Igbo"),
                            self.tr("Yi"),
                            self.tr("Icelandic"),
                            self.tr("Italian"),
                            self.tr("Inuktitut"),
                            self.tr("Japanese"),
                            self.tr("Georgian"),
                            self.tr("Kazakh"),
                            self.tr("Greenlandic"),
                            self.tr("Khmer"),
                            self.tr("Kannada"),
                            self.tr("Korean"),
                            self.tr("Konkani"),
                            self.tr("Kyrgyz"),
                            self.tr("Luxembourgish"),
                            self.tr("Lao"),
                            self.tr("Lithuanian"),
                            self.tr("Latvian"),
                            self.tr("Maori"),
                            self.tr("Macedonian"),
                            self.tr("Malayalam"),
                            self.tr("Mongolian"),
                            self.tr("Mohawk"),
                            self.tr("Marathi"),
                            self.tr("Malay"),
                            self.tr("Maltese"),
                            self.tr("Burmese"),
                            self.tr("Norwegian (Bokmål)"),
                            self.tr("Nepali"),
                            self.tr("Dutch"),
                            self.tr("Norwegian (Nynorsk)"),
                            self.tr("Norwegian"),
                            self.tr("Sesotho"),
                            self.tr("Occitan"),
                            self.tr("Odia"),
                            self.tr("Punjabi"),
                            self.tr("Polish"),
                            self.tr("Dari"),
                            self.tr("Pashto"),
                            self.tr("Portuguese"),
                            self.tr("K'iche"),
                            self.tr("Quechua"),
                            self.tr("Romansh"),
                            self.tr("Romanian"),
                            self.tr("Russian"),
                            self.tr("Kinyarwanda"),
                            self.tr("Sanskrit"),
                            self.tr("Yakut"),
                            self.tr("Sami (Northern)"),
                            self.tr("Sinhala"),
                            self.tr("Slovak"),
                            self.tr("Slovenian"),
                            self.tr("Sami (Southern)"),
                            self.tr("Sami (Lule)"),
                            self.tr("Sami (Inari)"),
                            self.tr("Sami (Skolt)"),
                            self.tr("Albanian"),
                            self.tr("Serbian"),
                            self.tr("Swedish"),
                            self.tr("Kiswahili"),
                            self.tr("Syriac"),
                            self.tr("Tamil"),
                            self.tr("Telugu"),
                            self.tr("Tajik"),
                            self.tr("Thai"),
                            self.tr("Turkmen"),
                            self.tr("Tswana"),
                            self.tr("Turkish"),
                            self.tr("Tatar"),
                            self.tr("Tamazight"),
                            self.tr("Uyghur"),
                            self.tr("Ukrainian"),
                            self.tr("Urdu"),
                            self.tr("Uzbek"),
                            self.tr("Vietnamese"),
                            self.tr("Wolof"),
                            self.tr("Xhosa"),
                            self.tr("Yoruba"),
                            self.tr("Chinese"),
                            self.tr("Zulu")
                         ]
        
    def getLanguageStrings(self):
        """
        Build a formated list of languages to be displayed in the UI.
        This includes language and language subcode.
        """

        outputList = []

        for i in range(len(self.languages)):
            # logging.debug('{0} - {1}'.format(self.parseLanguage(i), self.languages[i]))
            outputList.append('{0} - {1}'.format(self.parseLanguage(i), self.languages[i]))

        return outputList
    
    def setupCountries(self):
        """
        Intitialize the country matrix.
        It contains the country code and name [code, name].
        """

        self.countries = [
            [self.tr("AD"), self.tr("Andorra")],
            [self.tr("AE"), self.tr("United Arab Emirates")],
            [self.tr("AF"), self.tr("Afghanistan")],
            [self.tr("AG"), self.tr("Antigua and Barbuda")],
            [self.tr("AI"), self.tr("Anguilla")],
            [self.tr("AL"), self.tr("Albania")],
            [self.tr("AM"), self.tr("Armenia")],
            [self.tr("AO"), self.tr("Angola")],
            [self.tr("AQ"), self.tr("Antarctica")],
            [self.tr("AR"), self.tr("Argentina")],
            [self.tr("AS"), self.tr("American Samoa")],
            [self.tr("AT"), self.tr("Austria")],
            [self.tr("AU"), self.tr("Australia")],
            [self.tr("AW"), self.tr("Aruba")],
            [self.tr("AX"), self.tr("Åland Islands")],
            [self.tr("AZ"), self.tr("Azerbaijan")],
            [self.tr("BA"), self.tr("Bosnia and Herzegovina")],
            [self.tr("BB"), self.tr("Barbados")],
            [self.tr("BD"), self.tr("Bangladesh")],
            [self.tr("BE"), self.tr("Belgium")],
            [self.tr("BF"), self.tr("Burkina Faso")],
            [self.tr("BG"), self.tr("Bulgaria")],
            [self.tr("BH"), self.tr("Bahrain")],
            [self.tr("BI"), self.tr("Burundi")],
            [self.tr("BJ"), self.tr("Benin")],
            [self.tr("BL"), self.tr("Saint Barthélemy")],
            [self.tr("BM"), self.tr("Bermuda")],
            [self.tr("BN"), self.tr("Brunei Darussalam")],
            [self.tr("BO"), self.tr("Bolivia (Plurinational State of)")],
            [self.tr("BQ"), self.tr("Bonaire, Sint Eustatius and Saba")],
            [self.tr("BR"), self.tr("Brazil")],
            [self.tr("BS"), self.tr("Bahamas")],
            [self.tr("BT"), self.tr("Bhutan")],
            [self.tr("BV"), self.tr("Bouvet Island")],
            [self.tr("BW"), self.tr("Botswana")],
            [self.tr("BY"), self.tr("Belarus")],
            [self.tr("BZ"), self.tr("Belize")],
            [self.tr("CA"), self.tr("Canada")],
            [self.tr("CC"), self.tr("Cocos (Keeling) Islands")],
            [self.tr("CD"), self.tr("Congo, Democratic Republic of the")],
            [self.tr("CF"), self.tr("Central African Republic")],
            [self.tr("CG"), self.tr("Congo")],
            [self.tr("CH"), self.tr("Switzerland")],
            [self.tr("CI"), self.tr("Côte d'Ivoire")],
            [self.tr("CK"), self.tr("Cook Islands")],
            [self.tr("CL"), self.tr("Chile")],
            [self.tr("CM"), self.tr("Cameroon")],
            [self.tr("CN"), self.tr("China")],
            [self.tr("CO"), self.tr("Colombia")],
            [self.tr("CR"), self.tr("Costa Rica")],
            [self.tr("CU"), self.tr("Cuba")],
            [self.tr("CV"), self.tr("Cabo Verde")],
            [self.tr("CW"), self.tr("Curaçao")],
            [self.tr("CX"), self.tr("Christmas Island")],
            [self.tr("CY"), self.tr("Cyprus")],
            [self.tr("CZ"), self.tr("Czechia")],
            [self.tr("DE"), self.tr("Germany")],
            [self.tr("DJ"), self.tr("Djibouti")],
            [self.tr("DK"), self.tr("Denmark")],
            [self.tr("DM"), self.tr("Dominica")],
            [self.tr("DO"), self.tr("Dominican Republic")],
            [self.tr("DZ"), self.tr("Algeria")],
            [self.tr("EC"), self.tr("Ecuador")],
            [self.tr("EE"), self.tr("Estonia")],
            [self.tr("EG"), self.tr("Egypt")],
            [self.tr("EH"), self.tr("Western Sahara")],
            [self.tr("ER"), self.tr("Eritrea")],
            [self.tr("ES"), self.tr("Spain")],
            [self.tr("ET"), self.tr("Ethiopia")],
            [self.tr("FI"), self.tr("Finland")],
            [self.tr("FJ"), self.tr("Fiji")],
            [self.tr("FK"), self.tr("Falkland Islands (Malvinas)")],
            [self.tr("FM"), self.tr("Micronesia (Federated States of)")],
            [self.tr("FO"), self.tr("Faroe Islands")],
            [self.tr("FR"), self.tr("France")],
            [self.tr("GA"), self.tr("Gabon")],
            [self.tr("GB"), self.tr("United Kingdom of Great Britain and Northern Ireland")],
            [self.tr("GD"), self.tr("Grenada")],
            [self.tr("GE"), self.tr("Georgia")],
            [self.tr("GF"), self.tr("French Guiana")],
            [self.tr("GG"), self.tr("Guernsey")],
            [self.tr("GH"), self.tr("Ghana")],
            [self.tr("GI"), self.tr("Gibraltar")],
            [self.tr("GL"), self.tr("Greenland")],
            [self.tr("GM"), self.tr("Gambia")],
            [self.tr("GN"), self.tr("Guinea")],
            [self.tr("GP"), self.tr("Guadeloupe")],
            [self.tr("GQ"), self.tr("Equatorial Guinea")],
            [self.tr("GR"), self.tr("Greece")],
            [self.tr("GS"), self.tr("South Georgia and the South Sandwich Islands")],
            [self.tr("GT"), self.tr("Guatemala")],
            [self.tr("GU"), self.tr("Guam")],
            [self.tr("GW"), self.tr("Guinea-Bissau")],
            [self.tr("GY"), self.tr("Guyana")],
            [self.tr("HK"), self.tr("Hong Kong")],
            [self.tr("HM"), self.tr("Heard Island and McDonald Islands")],
            [self.tr("HN"), self.tr("Honduras")],
            [self.tr("HR"), self.tr("Croatia")],
            [self.tr("HT"), self.tr("Haiti")],
            [self.tr("HU"), self.tr("Hungary")],
            [self.tr("ID"), self.tr("Indonesia")],
            [self.tr("IE"), self.tr("Ireland")],
            [self.tr("IL"), self.tr("Israel")],
            [self.tr("IM"), self.tr("Isle of Man")],
            [self.tr("IN"), self.tr("India")],
            [self.tr("IO"), self.tr("British Indian Ocean Territory")],
            [self.tr("IQ"), self.tr("Iraq")],
            [self.tr("IR"), self.tr("Iran (Islamic Republic of)")],
            [self.tr("IS"), self.tr("Iceland")],
            [self.tr("IT"), self.tr("Italy")],
            [self.tr("JE"), self.tr("Jersey")],
            [self.tr("JM"), self.tr("Jamaica")],
            [self.tr("JO"), self.tr("Jordan")],
            [self.tr("JP"), self.tr("Japan")],
            [self.tr("KE"), self.tr("Kenya")],
            [self.tr("KG"), self.tr("Kyrgyzstan")],
            [self.tr("KH"), self.tr("Cambodia")],
            [self.tr("KI"), self.tr("Kiribati")],
            [self.tr("KM"), self.tr("Comoros")],
            [self.tr("KN"), self.tr("Saint Kitts and Nevis")],
            [self.tr("KP"), self.tr("Korea (Democratic People's Republic of)")],
            [self.tr("KR"), self.tr("Korea, Republic of")],
            [self.tr("KW"), self.tr("Kuwait")],
            [self.tr("KY"), self.tr("Cayman Islands")],
            [self.tr("KZ"), self.tr("Kazakhstan")],
            [self.tr("LA"), self.tr("Lao People's Democratic Republic")],
            [self.tr("LB"), self.tr("Lebanon")],
            [self.tr("LC"), self.tr("Saint Lucia")],
            [self.tr("LI"), self.tr("Liechtenstein")],
            [self.tr("LK"), self.tr("Sri Lanka")],
            [self.tr("LR"), self.tr("Liberia")],
            [self.tr("LS"), self.tr("Lesotho")],
            [self.tr("LT"), self.tr("Lithuania")],
            [self.tr("LU"), self.tr("Luxembourg")],
            [self.tr("LV"), self.tr("Latvia")],
            [self.tr("LY"), self.tr("Libya")],
            [self.tr("MA"), self.tr("Morocco")],
            [self.tr("MC"), self.tr("Monaco")],
            [self.tr("MD"), self.tr("Moldova, Republic of")],
            [self.tr("ME"), self.tr("Montenegro")],
            [self.tr("MF"), self.tr("Saint Martin (French part)")],
            [self.tr("MG"), self.tr("Madagascar")],
            [self.tr("MH"), self.tr("Marshall Islands")],
            [self.tr("MK"), self.tr("North Macedonia")],
            [self.tr("ML"), self.tr("Mali")],
            [self.tr("MM"), self.tr("Myanmar")],
            [self.tr("MN"), self.tr("Mongolia")],
            [self.tr("MO"), self.tr("Macao")],
            [self.tr("MP"), self.tr("Northern Mariana Islands")],
            [self.tr("MQ"), self.tr("Martinique")],
            [self.tr("MR"), self.tr("Mauritania")],
            [self.tr("MS"), self.tr("Montserrat")],
            [self.tr("MT"), self.tr("Malta")],
            [self.tr("MU"), self.tr("Mauritius")],
            [self.tr("MV"), self.tr("Maldives")],
            [self.tr("MW"), self.tr("Malawi")],
            [self.tr("MX"), self.tr("Mexico")],
            [self.tr("MY"), self.tr("Malaysia")],
            [self.tr("MZ"), self.tr("Mozambique")],
            [self.tr("nan"), self.tr("Namibia")],
            [self.tr("NC"), self.tr("New Caledonia")],
            [self.tr("NE"), self.tr("Niger")],
            [self.tr("NF"), self.tr("Norfolk Island")],
            [self.tr("NG"), self.tr("Nigeria")],
            [self.tr("NI"), self.tr("Nicaragua")],
            [self.tr("NL"), self.tr("Netherlands, Kingdom of the")],
            [self.tr("NO"), self.tr("Norway")],
            [self.tr("NP"), self.tr("Nepal")],
            [self.tr("NR"), self.tr("Nauru")],
            [self.tr("NU"), self.tr("Niue")],
            [self.tr("NZ"), self.tr("New Zealand")],
            [self.tr("OM"), self.tr("Oman")],
            [self.tr("PA"), self.tr("Panama")],
            [self.tr("PE"), self.tr("Peru")],
            [self.tr("PF"), self.tr("French Polynesia")],
            [self.tr("PG"), self.tr("Papua New Guinea")],
            [self.tr("PH"), self.tr("Philippines")],
            [self.tr("PK"), self.tr("Pakistan")],
            [self.tr("PL"), self.tr("Poland")],
            [self.tr("PM"), self.tr("Saint Pierre and Miquelon")],
            [self.tr("PN"), self.tr("Pitcairn")],
            [self.tr("PR"), self.tr("Puerto Rico")],
            [self.tr("PS"), self.tr("Palestine, State of")],
            [self.tr("PT"), self.tr("Portugal")],
            [self.tr("PW"), self.tr("Palau")],
            [self.tr("PY"), self.tr("Paraguay")],
            [self.tr("QA"), self.tr("Qatar")],
            [self.tr("RE"), self.tr("Réunion")],
            [self.tr("RO"), self.tr("Romania")],
            [self.tr("RS"), self.tr("Serbia")],
            [self.tr("RU"), self.tr("Russian Federation")],
            [self.tr("RW"), self.tr("Rwanda")],
            [self.tr("SA"), self.tr("Saudi Arabia")],
            [self.tr("SB"), self.tr("Solomon Islands")],
            [self.tr("SC"), self.tr("Seychelles")],
            [self.tr("SD"), self.tr("Sudan")],
            [self.tr("SE"), self.tr("Sweden")],
            [self.tr("SG"), self.tr("Singapore")],
            [self.tr("SH"), self.tr("Saint Helena, Ascension and Tristan da Cunha")],
            [self.tr("SI"), self.tr("Slovenia")],
            [self.tr("SJ"), self.tr("Svalbard and Jan Mayen")],
            [self.tr("SK"), self.tr("Slovakia")],
            [self.tr("SL"), self.tr("Sierra Leone")],
            [self.tr("SM"), self.tr("San Marino")],
            [self.tr("SN"), self.tr("Senegal")],
            [self.tr("SO"), self.tr("Somalia")],
            [self.tr("SR"), self.tr("Suriname")],
            [self.tr("SS"), self.tr("South Sudan")],
            [self.tr("ST"), self.tr("Sao Tome and Principe")],
            [self.tr("SV"), self.tr("El Salvador")],
            [self.tr("SX"), self.tr("Sint Maarten (Dutch part)")],
            [self.tr("SY"), self.tr("Syrian Arab Republic")],
            [self.tr("SZ"), self.tr("Eswatini")],
            [self.tr("TC"), self.tr("Turks and Caicos Islands")],
            [self.tr("TD"), self.tr("Chad")],
            [self.tr("TF"), self.tr("French Southern Territories")],
            [self.tr("TG"), self.tr("Togo")],
            [self.tr("TH"), self.tr("Thailand")],
            [self.tr("TJ"), self.tr("Tajikistan")],
            [self.tr("TK"), self.tr("Tokelau")],
            [self.tr("TL"), self.tr("Timor-Leste")],
            [self.tr("TM"), self.tr("Turkmenistan")],
            [self.tr("TN"), self.tr("Tunisia")],
            [self.tr("TO"), self.tr("Tonga")],
            [self.tr("TR"), self.tr("Türkiye")],
            [self.tr("TT"), self.tr("Trinidad and Tobago")],
            [self.tr("TV"), self.tr("Tuvalu")],
            [self.tr("TW"), self.tr("Taiwan, Province of China")],
            [self.tr("TZ"), self.tr("Tanzania, United Republic of")],
            [self.tr("UA"), self.tr("Ukraine")],
            [self.tr("UG"), self.tr("Uganda")],
            [self.tr("UM"), self.tr("United States Minor Outlying Islands")],
            [self.tr("US"), self.tr("United States of America")],
            [self.tr("UY"), self.tr("Uruguay")],
            [self.tr("UZ"), self.tr("Uzbekistan")],
            [self.tr("VA"), self.tr("Holy See")],
            [self.tr("VC"), self.tr("Saint Vincent and the Grenadines")],
            [self.tr("VE"), self.tr("Venezuela (Bolivarian Republic of)")],
            [self.tr("VG"), self.tr("Virgin Islands (British)")],
            [self.tr("VI"), self.tr("Virgin Islands (U.S.)")],
            [self.tr("VN"), self.tr("Viet Nam")],
            [self.tr("VU"), self.tr("Vanuatu")],
            [self.tr("WF"), self.tr("Wallis and Futuna")],
            [self.tr("WS"), self.tr("Samoa")],
            [self.tr("YE"), self.tr("Yemen")],
            [self.tr("YT"), self.tr("Mayotte")],
            [self.tr("ZA"), self.tr("South Africa")],
            [self.tr("ZM"), self.tr("Zambia")],
            [self.tr("ZW"), self.tr("Zimbabwe")]
          ]

    def getCountryStrings(self):
        """
        Build a formated list of countries to be displayed in the UI.
        This includes country code and name.
        """

        outputList = []

        for i in range(len(self.countries)):
            # logging.debug('{0} - {1}'.format(self.parseLanguage(i), self.languages[i]))
            outputList.append('{0} - {1}'.format(self.countries[i][0], self.countries[i][1]))

        return outputList