# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SaveAttributes
                                 A QGIS plugin
 This will save attributes
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-03-06
        git sha              : $Format:%H$
        copyright            : (C) 2020 by test
        email                : test@google.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox
#from qgis.core import QgsProject 

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .open_reblock_dialog import OpenReblockDialog
import os.path
from qgis.core import QgsProject

import sys 
from .qgis_reblock import make_qgis_reblock_layers
from qgis.core import QgsVectorLayer, QgsProject, QgsField, QgsGeometry, QgsFeature, QgsExpression, QgsFeatureRequest

from typing import List 

HELP_MESSAGES = {
    'parcel': "The parcel layer defines the set of all possible paths which may be chosen for reblocking. \nThis includes current streets as well as potential new streets.",
    'building': "The building layer is all polygon building footprints.",
    'road': "[Optional] This layer is all existing roads.\nThese roads will then be assigned weight = 0 when estimating the optimal reblocking path",
    "target_block": "[Optional] This value defaults to 'All' meaning that each and every block will be reblocked. However, the user can select a specific block ID if they wish to only process a single particular block.", 
    'id_col': "Because we reblock each block independently, we need to have an attribute in both the parcel, building, and block geometry that identifies a given block, so we know how to map a given set of buildings to a block. This defaults to 'block_id' because that is used in the original Million Neighborhoods analysis.", 
    'name': "The name of the new reblock layer"
}

TITLES = {
    'parcel': "Parcel Layer Help:",
    'building': "Building Layer Help:",
    'road': "[Optional] Existing Road Layer Help:",
    "target_block": 'Target Block Help:',
    'id_col': 'Block Identifier Column Name Help:',
    'name': "Output Name Help:"    
}

def get_blocks(parcel_layer: QgsVectorLayer, id_col: str) -> List[str]:
    
    block_list = [ft[id_col] for ft in parcel_layer.getFeatures()]
    return block_list

def showdialog(title: str, help_message: str):
   msg = QMessageBox()
   #msg.setIcon(QMessageBox.Information)

   #msg.setText("This is a message box")
   msg.setText(help_message)
   #msg.setInformativeText("This is additional information")
   #msg.setWindowTitle("MessageBox demo")
   msg.setWindowTitle(title)
   #msg.setDetailedText("The details are as follows:")
   #msg.setStandardButtons(QMessageBox.Ok | QMessageBox.Cancel)
   msg.setStandardButtons(QMessageBox.Ok)
   msg.buttonClicked.connect(msgbtn)
    
   retval = msg.exec_()
    
def msgbtn(i):
   print("Button pressed is: {}".format(i.text()))


class OpenReblock:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SaveAttributes_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Open reblock')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('OpenReblock', message)

    # def select_output_file(self):
    #     filename, _filter = QFileDialog.getSaveFileName(self.dlg, 
    #                         "Select  output file ", "", '*.csv')
    #     self.dlg.lineEdit.setText(filename)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/open_reblock/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Perform reblocking'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Open reblock'),
                action)
            self.iface.removeToolBarIcon(action)


    # def help_display(self):
    #     QMessageBox                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             

    def run(self):
        """Run method that performs all the real work"""


        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = OpenReblockDialog()

            parcel_help_fn = lambda : showdialog(TITLES['parcel'], HELP_MESSAGES['parcel'])
            self.dlg.helpButton_parcel.clicked.connect(parcel_help_fn)

            building_help_fn = lambda : showdialog(TITLES['building'], HELP_MESSAGES['building'])
            self.dlg.helpButton_building.clicked.connect(building_help_fn)

            road_help_fn = lambda : showdialog(TITLES['road'], HELP_MESSAGES['road'])
            self.dlg.helpButton_road.clicked.connect(road_help_fn)

            target_block_help_fn = lambda : showdialog(TITLES['target_block'], HELP_MESSAGES['target_block'])
            self.dlg.helpButton_target_block.clicked.connect(target_block_help_fn)
            
            name_help_fn = lambda : showdialog(TITLES['name'], HELP_MESSAGES['name'])
            self.dlg.helpButton_name.clicked.connect(name_help_fn)

            id_col_help_fn = lambda :showdialog(TITLES['id_col'], HELP_MESSAGES['id_col'])
            self.dlg.helpButton_id_col.clicked.connect(id_col_help_fn)
            

        # Populate our combo boxes to choose the input layers
        layers = QgsProject.instance().layerTreeRoot().children()
        layer_names = [layer.name() for layer in layers]
        self.dlg.comboBox_buildings.clear()
        self.dlg.comboBox_buildings.addItems(layer_names)
 
        self.dlg.comboBox_parcels.clear()
        self.dlg.comboBox_parcels.addItems(layer_names)

        self.dlg.comboBox_blocks.clear()
        layer_names_plus_none = ["None"]+layer_names
        layers_plus_none = [None] + layers
        self.dlg.comboBox_blocks.addItems(layer_names_plus_none)

        # Get the output name
        self.dlg.plainTextEdit_outname.clear()

        # Get the output name
        self.dlg.plainTextEdit_target_block.setPlainText('All')

        # Set the id_col
        if self.dlg.plainTextEdit_id_col.toPlainText() != '':
            print('Already set')
        else:
            self.dlg.plainTextEdit_id_col.setPlainText('block_id')

        # show the dialog
        self.dlg.show()

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            print("Running open reblock!!")
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            #filename = self.dlg.lineEdit.text()
            #with open(filename, 'w') as output_file:

                # Get the building layer
            building_index = self.dlg.comboBox_buildings.currentIndex()
            building_layer = layers[building_index].layer()

            # # And the parcel layer
            parcel_index = self.dlg.comboBox_parcels.currentIndex()
            parcel_layer = layers[parcel_index].layer()

            # And the block (i.e. existing roads) layer
            block_index = self.dlg.comboBox_blocks.currentIndex()
            block_layer = layers_plus_none[block_index]
            if block_layer is not None:
                block_layer = block_layer.layer()

            # ID COl
            id_col = self.dlg.plainTextEdit_id_col.toPlainText()

            output_layer_name = self.dlg.plainTextEdit_outname.toPlainText()
            target_block = self.dlg.plainTextEdit_target_block.toPlainText()
            all_blocks = get_blocks(parcel_layer, id_col)
            target_block_list = [target_block] if target_block != 'All' else all_blocks
            #print(output_layer_name)

            make_qgis_reblock_layers(building_layer, parcel_layer, target_block_list,
                                  block_layer, id_col, output_layer_name)

                # # write header
                # line = ",".join(name for name in fieldnames) + "\n"
                # output_file.write(line)
                # #write feature attributes
                # for f in selectedLayer.getFeatures():
                #   line = ','.join(str(f[name]) for name in fieldnames) + "\n"
                #   output_file.write(line)

# layers = QgsProject.instance().layerTreeRoot().children()
# layer_names = [layer.name() for layer in layers]
# building_layer = layers[2].layer()
# parcel_layer = layers[1].layer()
# block_layer = None
# id_col = 'block_id'
# output_layer_name = 'test_out'