"""
Open Geodata Browser - QGIS Plugin

Provides access to satellite imagery from multiple STAC providers
"""

import sys
import os
from pathlib import Path


def setup_dependencies():
    """Setup dependencies - try bundled first, then use dependency installer"""
    plugin_dir = Path(__file__).parent
    
    # Method 1: Try bundled dependencies
    extlibs_path = plugin_dir / 'extlibs'
    if extlibs_path.exists():
        if str(extlibs_path) not in sys.path:
            sys.path.insert(0, str(extlibs_path))
    
    # Method 2: Check if already installed
    try:
        import open_geodata_api
        import pystac_client
        import requests
        return True
    except ImportError:
        pass
    
    # Method 3: Use dependency installer on first run
    # Don't auto-install here - let geodata_browser.py handle it
    return False


def classFactory(iface):
    """Load GeodataBrowser class
    
    Args:
        iface (QgsInterface): A QGIS interface instance.
    """
    from .geodata_browser import GeodataBrowser
    return GeodataBrowser(iface)


# Setup dependencies when plugin loads
setup_dependencies()
