# -*- coding: utf-8 -*-
"""
/***************************************************************************
 opeNoise

 opeNoise allows to compute the noise level generated by road traffic
 at fixed receiver points and buildings.

                             -------------------
        begin                : March 2014
        copyright            : (C) 2014 by Arpa Piemonte
        email                : s.masera@arpa.piemonte.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

from symbols import render

import fTools
import os, imp
import traceback

from datetime import datetime
from ui_ApplyNoiseSymbology import Ui_ApplyNoiseSymbology_window

path = os.path.dirname(fTools.__file__)
ftools_utils = imp.load_source('ftools_utils', os.path.join(path,'tools','ftools_utils.py'))

class Dialog(QDialog,Ui_ApplyNoiseSymbology_window):
   
    def __init__(self, iface):
        QDialog.__init__(self, iface.mainWindow())
        self.iface = iface
        # Set up the user interface from Designer.
        self.setupUi(self)
        
        self.populate_comboBox()
        
        self.progressBar.setValue(0)

        self.update_field_layer()
        
        QObject.connect(self.layer_comboBox, SIGNAL("currentIndexChanged(QString)"), self.update_field_layer)
        
        self.run_buttonBox.button( QDialogButtonBox.Ok )

        
    def populate_comboBox( self ):
        layers = ftools_utils.getLayerNames([QGis.Point, QGis.Line, QGis.Polygon])
        self.layer_comboBox.clear()
        self.layer_comboBox.addItems(layers)

        
    def update_field_layer(self):
        
        if unicode(self.layer_comboBox.currentText()) == "":
            return

        layer = ftools_utils.getVectorLayerByName(unicode(self.layer_comboBox.currentText()))
        layer_fields = ftools_utils.getFieldList(layer)
        
        #self.id_field_comboBox.clear() 
        self.level_comboBox.clear()        
        
        layer_fields_number = ["choose field"]
        
        for f in layer_fields:
            if f.type() == QVariant.Int or f.type() == QVariant.Double:         
                layer_fields_number.append(unicode(f.name()))

        for f_label in layer_fields_number:
            #self.id_field_comboBox.addItem(f_label)
            self.level_comboBox.addItem(f_label)
            

    def controls(self):
        self.run_buttonBox.setEnabled( False )
        if self.layer_comboBox.currentText() == "":
            QMessageBox.information(self, self.tr("opeNoise - Apply Noise Symbology"), self.tr("Please specify the input vector layer."))
            return 0
        
        if self.level_comboBox.currentText() == "choose field":
               message = "Please specify the level field to apply" + "\n" + "the noise sumbology."
               QMessageBox.information(self, self.tr("opeNoise - Apply Noise Symbology"), self.tr(message))
               return 0
            
        return 1

    def accept(self):
        self.run_buttonBox.setEnabled( False )
        
        if self.controls() == 0:
            self.run_buttonBox.setEnabled( True )
            return
        
        self.log_start()  
        layer = ftools_utils.getVectorLayerByName(self.layer_comboBox.currentText())
        field = self.level_comboBox.currentText()
        
        # writes the settings log file
        
        log_settings.write("Input layer:\n" + layer.source() + "\n\n")
        log_settings.write("Field:\n" + str(field) + "\n\n")

        self.time_start = datetime.now()
        
        # Run
        try:    
            self.run(layer,field)
            run = 1
        except:
            error= traceback.format_exc()
            log_errors.write(error)
            run = 0
            
        self.time_end = datetime.now()
        
        if run == 1:
            log_errors.write("No errors." + "\n\n")
            result_string = "Noise symbology assigned with success." + "\n\n" +\
                             "View and rename the settings file to keep it:" + "\n" +\
                             str(log_settings_path_name) + "\n\n" + str(self.duration())
            QMessageBox.information(self, self.tr("opeNoise - Apply Noise Symbology"), self.tr(result_string))
            self.iface.messageBar().pushMessage("opeNoise - Apply Noise Symbology", "Process complete")
        else:
            result_string = "Sorry, process not complete." + "\n\n" +\
                            "View the log file to understand the problem:" + "\n" +\
                            str(log_errors_path_name) + "\n\n" + str(self.duration())
            QMessageBox.information(self, self.tr("opeNoise - Apply Noise Symbology"), self.tr(result_string))
            self.iface.messageBar().pushMessage("opeNoise - Apply Noise Symbology", "Process not complete")

        log_settings.write("\n\n=======================================================\n")
        log_settings.write(result_string)
        self.log_end()

        self.run_buttonBox.setEnabled( True )

        self.iface.mainWindow().statusBar().clearMessage()
        self.iface.mapCanvas().refresh() 
        self.close()  


    def duration(self):
        duration = self.time_end - self.time_start
        duration_h = duration.seconds/3600
        duration_m = (duration.seconds - duration_h*3600)/60
        duration_s = duration.seconds - duration_m*60 - duration_h*3600
        duration_string = "Starting time: " + self.time_start.strftime("%a %d/%b/%Y %H:%M:%S.%f") + "\n" +\
                          "Ending time: " + self.time_end.strftime("%a %d/%b/%Y %H:%M:%S.%f") + "\n"+\
                          "Execution time: " + str(duration_h) + " hours, " + str(duration_m) + \
                          " minutes, " + str(duration_s) + "." + str(duration.microseconds) + " seconds."
        return duration_string
    
    def log_start(self):
        
        # creates 2 log file: settings and errors
        global log_errors, log_settings,log_settings_path_name,log_errors_path_name
        path = os.path.abspath(__file__)
        dir_path = os.path.dirname(path)        
        log_settings_path_name = os.path.join(dir_path,"log_ApplyNoiseSymbology_settings.txt")
        log_errors_path_name = os.path.join(dir_path,"log_ApplyNoiseSymbology_errors.txt")
        log_settings = open(log_settings_path_name,"w")
        log_errors = open(log_errors_path_name,"w")
        log_settings.write("opeNoise - Apply Noise Symbology Settings" + "\n\n")
        log_errors.write("opeNoise - Apply Noise Symbology Errors" + "\n\n")    
        
    def log_end(self):

        log_settings.close()        
        log_errors.close()                
    
    
    def run(self,layer,field):
        
        render(layer,field)
