# -*- coding: utf-8 -*-
"""
/***************************************************************************
 opeNoise

 opeNoise allows to compute the noise level generated by road traffic
 at fixed receiver points and buildings.

                             -------------------
        begin                : March 2014
        copyright            : (C) 2014 by Arpa Piemonte
        email                : s.masera@arpa.piemonte.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.core import  (QgsMapLayerRegistry,
                        QgsGraduatedSymbolRendererV2,
                        QgsSymbolV2,
                        QgsRendererRangeV2)
from symbols import render

import fTools
import os, imp
import traceback

from math import *
from datetime import datetime
from ui_AssignLevelsToBuildings import Ui_AssignLevelsToBuildings_window

path = os.path.dirname(fTools.__file__)
ftools_utils = imp.load_source('ftools_utils', os.path.join(path,'tools','ftools_utils.py'))

class Dialog(QDialog,Ui_AssignLevelsToBuildings_window):
   
    def __init__(self, iface):
        QDialog.__init__(self, iface.mainWindow())
        self.iface = iface
        # Set up the user interface from Designer.
        self.setupUi(self)
        
        self.populate_comboBox()
        
        self.progressBar.setValue(0)

        self.update_field_receiver_points_layer()
        
        QObject.connect(self.receiver_points_layer_comboBox, SIGNAL("currentIndexChanged(QString)"), self.update_field_receiver_points_layer)
        
        self.run_buttonBox.button( QDialogButtonBox.Ok )

        
    def populate_comboBox( self ):
        receiver_points_layers = ftools_utils.getLayerNames([QGis.Point])
        self.receiver_points_layer_comboBox.clear()
        self.receiver_points_layer_comboBox.addItems(receiver_points_layers)
       
        buildings_layers = ftools_utils.getLayerNames([QGis.Polygon])
        self.buildings_layer_comboBox.clear()
        self.buildings_layer_comboBox.addItems(buildings_layers)
        
    def update_field_receiver_points_layer(self):
        
        if unicode(self.receiver_points_layer_comboBox.currentText()) == "":
            return

        receiver_points_layer = ftools_utils.getVectorLayerByName(unicode(self.receiver_points_layer_comboBox.currentText()))
        receiver_points_layer_fields = ftools_utils.getFieldList(receiver_points_layer)
        
        #self.id_field_comboBox.clear() 
        self.level_1_comboBox.clear()        
        self.level_2_comboBox.clear()
        self.level_3_comboBox.clear()
        self.level_4_comboBox.clear()
        self.level_5_comboBox.clear()
        
        receiver_points_layer_fields_number = ["choose field"]
        
        for f in receiver_points_layer_fields:
            if f.type() == QVariant.Int or f.type() == QVariant.Double:         
                receiver_points_layer_fields_number.append(unicode(f.name()))

        for f_label in receiver_points_layer_fields_number:
            #self.id_field_comboBox.addItem(f_label)
            self.level_1_comboBox.addItem(f_label)
            self.level_2_comboBox.addItem(f_label)
            self.level_3_comboBox.addItem(f_label)
            self.level_4_comboBox.addItem(f_label)
            self.level_5_comboBox.addItem(f_label)
            

    def controls(self):
        self.run_buttonBox.setEnabled( False )
        if self.receiver_points_layer_comboBox.currentText() == "":
            QMessageBox.information(self, self.tr("opeNoise - Assign Levels To Buildings"), self.tr("Please specify the receiver points vector layer."))
            return 0
        
        if self.level_1_comboBox.currentText() == "choose field" and self.level_2_comboBox.currentText() == "choose field"\
           and self.level_3_comboBox.currentText() == "choose field" and self.level_4_comboBox.currentText() == "choose field"\
           and self.level_5_comboBox.currentText() == "choose field":
               message = "Please specify at least one level field to assing" + "\n" + "to the buildings layer."
               QMessageBox.information(self, self.tr("opeNoise - Assign Levels To Buildings"), self.tr(message))
               return 0

        if self.buildings_layer_comboBox.currentText() == "":
            QMessageBox.information(self, self.tr("opeNoise - Assign Levels To Buildings"), self.tr("Please specify the buildings vector layer."))
            return 0
            
        return 1

    def populate_receiver_points_fields(self):

        receiver_points_dict = {}

        receiver_points_dict['id_field'] = 'id_bui'

        if self.level_1_comboBox.currentText() == 'choose field':
            receiver_points_dict['level_1'] = 'none'
        else:
            receiver_points_dict['level_1'] = self.level_1_comboBox.currentText()
        
        if self.level_2_comboBox.currentText() == 'choose field':
            receiver_points_dict['level_2'] = 'none'
        else:
            receiver_points_dict['level_2'] = self.level_2_comboBox.currentText()

        if self.level_3_comboBox.currentText() == 'choose field':
            receiver_points_dict['level_3'] = 'none'
        else:
            receiver_points_dict['level_3'] = self.level_3_comboBox.currentText()

        if self.level_4_comboBox.currentText() == 'choose field':
            receiver_points_dict['level_4'] = 'none'
        else:
            receiver_points_dict['level_4'] = self.level_4_comboBox.currentText()

        if self.level_5_comboBox.currentText() == 'choose field':
            receiver_points_dict['level_5'] = 'none'
        else:
            receiver_points_dict['level_5'] = self.level_5_comboBox.currentText()            

        return receiver_points_dict

    def accept(self):
        self.run_buttonBox.setEnabled( False )
        
        if self.controls() == 0:
            self.run_buttonBox.setEnabled( True )
            return
        
        self.log_start()  
        receiver_points_layer = ftools_utils.getVectorLayerByName(self.receiver_points_layer_comboBox.currentText())
        receiver_points_layer_details = self.populate_receiver_points_fields()
        buildings_layer = ftools_utils.getVectorLayerByName(self.buildings_layer_comboBox.currentText())

        
        # writes the settings log file
        
        log_settings.write("Reveicer points layer:\n" + receiver_points_layer.source() + "\n\n")
        log_settings.write("Reveicer points layer:\n" + str(receiver_points_layer_details) + "\n\n")
        log_settings.write("Buildings layer:\n" + buildings_layer.source() + "\n\n")

        self.time_start = datetime.now()
        
        # Run
        try:    
            self.run(receiver_points_layer,receiver_points_layer_details,buildings_layer)
            run = 1
        except:
            error= traceback.format_exc()
            log_errors.write(error)
            run = 0
            
        self.time_end = datetime.now()
        
        if run == 1:
            log_errors.write("No errors." + "\n\n")
            result_string = "Noise levels assigned with success." + "\n\n" +\
                             "View and rename the settings file to keep it:" + "\n" +\
                             str(log_settings_path_name) + "\n\n" + str(self.duration())
            QMessageBox.information(self, self.tr("opeNoise - Assign Levels To Buildings"), self.tr(result_string))
            self.iface.messageBar().pushMessage("opeNoise - Assign Levels To Buildings", "Process complete")
        else:
            result_string = "Sorry, process not complete." + "\n\n" +\
                            "View the log file to understand the problem:" + "\n" +\
                            str(log_errors_path_name) + "\n\n" + str(self.duration())
            QMessageBox.information(self, self.tr("opeNoise - Assign Levels To Buildings"), self.tr(result_string))
            self.iface.messageBar().pushMessage("opeNoise - Assign Levels To Buildings", "Process not complete")

        log_settings.write("\n\n=======================================================\n")
        log_settings.write(result_string)
        self.log_end()

        self.run_buttonBox.setEnabled( True )

        self.iface.mainWindow().statusBar().clearMessage()
        self.iface.mapCanvas().refresh() 
        self.close()  


    def duration(self):
        duration = self.time_end - self.time_start
        duration_h = duration.seconds/3600
        duration_m = (duration.seconds - duration_h*3600)/60
        duration_s = duration.seconds - duration_m*60 - duration_h*3600
        duration_string = "Starting time: " + self.time_start.strftime("%a %d/%b/%Y %H:%M:%S.%f") + "\n" +\
                          "Ending time: " + self.time_end.strftime("%a %d/%b/%Y %H:%M:%S.%f") + "\n"+\
                          "Execution time: " + str(duration_h) + " hours, " + str(duration_m) + \
                          " minutes, " + str(duration_s) + "." + str(duration.microseconds) + " seconds."
        return duration_string
    
    def log_start(self):
        
        # creates 2 log file: settings and errors
        global log_errors, log_settings,log_settings_path_name,log_errors_path_name
        path = os.path.abspath(__file__)
        dir_path = os.path.dirname(path)        
        log_settings_path_name = os.path.join(dir_path,"log_AssignLevelsToBuildings_settings.txt")
        log_errors_path_name = os.path.join(dir_path,"log_AssignLevelsToBuildings_errors.txt")
        log_settings = open(log_settings_path_name,"w")
        log_errors = open(log_errors_path_name,"w")
        log_settings.write("opeNoise - Assign Levels To Buildings Settings" + "\n\n")
        log_errors.write("opeNoise - Assign Levels To Buildings Errors" + "\n\n")    
        
    def log_end(self):

        log_settings.close()        
        log_errors.close()                
    
    
    def run(self,receiver_points_layer,receiver_points_layer_details,buildings_layer):
        
        # gets vector layers, features receiver points        
        receiver_points_feat_total = receiver_points_layer.dataProvider().featureCount()
        receiver_points_feat_all = receiver_points_layer.dataProvider().getFeatures()
        
        # gets fields index from receiver points layer        
        receiver_points_fields_index = {}
        receiver_points_fields_index['id_field'] = receiver_points_layer.fieldNameIndex(str(receiver_points_layer_details['id_field']))
        if receiver_points_layer_details['level_1'] <> 'none':
            level_1_name = receiver_points_layer_details['level_1']
            receiver_points_fields_index['level_1'] = receiver_points_layer.fieldNameIndex(receiver_points_layer_details['level_1'])
        if receiver_points_layer_details['level_2'] <> 'none':
            level_2_name = receiver_points_layer_details['level_2']
            receiver_points_fields_index['level_2'] = receiver_points_layer.fieldNameIndex(receiver_points_layer_details['level_2'])
        if receiver_points_layer_details['level_3'] <> 'none':
            level_3_name = receiver_points_layer_details['level_3']
            receiver_points_fields_index['level_3'] = receiver_points_layer.fieldNameIndex(receiver_points_layer_details['level_3'])
        if receiver_points_layer_details['level_4'] <> 'none':
            level_4_name = receiver_points_layer_details['level_4']
            receiver_points_fields_index['level_4'] = receiver_points_layer.fieldNameIndex(receiver_points_layer_details['level_4'])
        if receiver_points_layer_details['level_5'] <> 'none':
            level_5_name = receiver_points_layer_details['level_5']
            receiver_points_fields_index['level_5'] = receiver_points_layer.fieldNameIndex(receiver_points_layer_details['level_5'])

        # gets fields from buildings layer and initializes the final buildings_levels_fields to populate the buildings layer attribute table
        buildings_fields_index = {}
        buildings_fields_number = int(buildings_layer.dataProvider().fields().count())
        if receiver_points_layer_details['level_1'] <> 'none':            
            buildings_fields_index['level_1'] = buildings_fields_number
            buildings_fields_number = buildings_fields_number + 1
        if receiver_points_layer_details['level_2'] <> 'none':             
            buildings_fields_index['level_2'] = buildings_fields_number
            buildings_fields_number = buildings_fields_number + 1
        if receiver_points_layer_details['level_3'] <> 'none':              
            buildings_fields_index['level_3'] = buildings_fields_number
            buildings_fields_number = buildings_fields_number + 1
        if receiver_points_layer_details['level_4'] <> 'none':              
            buildings_fields_index['level_4'] = buildings_fields_number
            buildings_fields_number = buildings_fields_number + 1
        if receiver_points_layer_details['level_5'] <> 'none':              
            buildings_fields_index['level_5'] = buildings_fields_number
            buildings_fields_number = buildings_fields_number + 1   
              
        receiver_points_feat_number = 0
        
        buildings_levels_fields = {}
        for feat in receiver_points_feat_all:

            receiver_points_feat_number = receiver_points_feat_number + 1
            bar = receiver_points_feat_number/float(receiver_points_feat_total)*100
            self.progressBar.setValue(bar)
            
            feat_levels_fields = {}            
            
            id_edi = feat.attributes()[receiver_points_fields_index['id_field']]

            
            
            if receiver_points_layer_details['level_1'] <> 'none':
                level_1 = feat.attributes()[receiver_points_fields_index['level_1']]
                feat_levels_fields[buildings_fields_index['level_1']] = level_1
            if receiver_points_layer_details['level_2'] <> 'none':
                level_2 = feat.attributes()[receiver_points_fields_index['level_2']]
                feat_levels_fields[buildings_fields_index['level_2']] = level_2
            if receiver_points_layer_details['level_3'] <> 'none':
                level_3 = feat.attributes()[receiver_points_fields_index['level_3']]
                feat_levels_fields[buildings_fields_index['level_3']] = level_3
            if receiver_points_layer_details['level_4'] <> 'none':
                level_4 = feat.attributes()[receiver_points_fields_index['level_4']]
                feat_levels_fields[buildings_fields_index['level_4']] = level_4
            if receiver_points_layer_details['level_5'] <> 'none':
                level_5 = feat.attributes()[receiver_points_fields_index['level_5']]        
                feat_levels_fields[buildings_fields_index['level_5']] = level_5
            
            if buildings_levels_fields.has_key(id_edi) == True:
                if receiver_points_layer_details['level_1'] <> 'none':
                    if (buildings_levels_fields[id_edi][buildings_fields_index['level_1']] < level_1 and level_1 != None) or\
                      buildings_levels_fields[id_edi][buildings_fields_index['level_1']] == None:
                        buildings_levels_fields[id_edi][buildings_fields_index['level_1']] = level_1
                if receiver_points_layer_details['level_2'] <> 'none':
                    if (buildings_levels_fields[id_edi][buildings_fields_index['level_2']] < level_2 and level_2 != None) or\
                      buildings_levels_fields[id_edi][buildings_fields_index['level_2']] == None:
                        buildings_levels_fields[id_edi][buildings_fields_index['level_2']] = level_2
                if receiver_points_layer_details['level_3'] <> 'none':
                    if (buildings_levels_fields[id_edi][buildings_fields_index['level_3']] < level_3 and level_3 != None) or\
                      buildings_levels_fields[id_edi][buildings_fields_index['level_3']] == None:
                        buildings_levels_fields[id_edi][buildings_fields_index['level_3']] = level_3
                if receiver_points_layer_details['level_4'] <> 'none':
                    if (buildings_levels_fields[id_edi][buildings_fields_index['level_4']] < level_4 and level_4 != None) or\
                      buildings_levels_fields[id_edi][buildings_fields_index['level_4']] == None:
                        buildings_levels_fields[id_edi][buildings_fields_index['level_4']] = level_4
                if receiver_points_layer_details['level_5'] <> 'none':
                    if (buildings_levels_fields[id_edi][buildings_fields_index['level_5']] < level_5 and level_5 != None) or\
                      buildings_levels_fields[id_edi][buildings_fields_index['level_5']] == None:
                        buildings_levels_fields[id_edi][buildings_fields_index['level_5']] = level_5
        
            else:

                buildings_levels_fields[id_edi] = feat_levels_fields
        
        # puts the sound level in the buildings attribute table
        new_level_fields = []
        if receiver_points_layer_details['level_1'] <> 'none':
            new_level_fields.append(QgsField(level_1_name, QVariant.Double,len=5,prec=1))
        if receiver_points_layer_details['level_2'] <> 'none':
            new_level_fields.append(QgsField(level_2_name, QVariant.Double,len=5,prec=1))
        if receiver_points_layer_details['level_3'] <> 'none':
            new_level_fields.append(QgsField(level_3_name, QVariant.Double,len=5,prec=1))
        if receiver_points_layer_details['level_4'] <> 'none':
            new_level_fields.append(QgsField(level_4_name, QVariant.Double,len=5,prec=1))
        if receiver_points_layer_details['level_5'] <> 'none':
            new_level_fields.append(QgsField(level_5_name, QVariant.Double,len=5,prec=1))            
        
        buildings_layer.dataProvider().addAttributes( new_level_fields )
        buildings_layer.updateFields()
        buildings_layer.dataProvider().changeAttributeValues(buildings_levels_fields)    
        
        # render with noise colours     
        level_fields_new = ftools_utils.getFieldList(buildings_layer)
        if len(level_fields_new) > 0:
            render(buildings_layer,level_fields_new[len(level_fields_new)-1].name())


        
