#ecosite_lut
#
# Looks up the parameters of an ecosite
#

# This table was derived from the spreadsheet ecosite_lut.ods
ecosite_table={
8:{'EcoName':'Very Shallow, Dry to Fresh: Meadow','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
9:{'EcoName':'Very Shallow, Dry to Fresh: Sparse Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
10:{'EcoName':'Very Shallow, Dry to Fresh: Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
11:{'EcoName':'Very Shallow, Dry to Fresh: Red Pine - White Pine Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
12:{'EcoName':'Very Shallow, Dry to Fresh: Pine - Black Spruce Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
13:{'EcoName':'Very Shallow, Dry to Fresh: Hemlock - White Cedar Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
14:{'EcoName':'Very Shallow, Dry to Fresh: Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
15:{'EcoName':'Very Shallow, Dry to Fresh: Red Pine - White Pine Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
16:{'EcoName':'Very Shallow, Dry to Fresh: Aspen - Birch Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
17:{'EcoName':'Very Shallow, Dry to Fresh: Oak Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
18:{'EcoName':'Very Shallow, Dry to Fresh: Maple Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
19:{'EcoName':'Very Shallow, Dry to Fresh: Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
20:{'EcoName':'Very Shallow, Moist: Meadow','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
21:{'EcoName':'Very Shallow, Moist: Sparse Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
22:{'EcoName':'Very Shallow, Moist: Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
23:{'EcoName':'Very Shallow, Moist: Red Pine - White Pine Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
24:{'EcoName':'Very Shallow, Moist: Pine - Black Spruce Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
25:{'EcoName':'Very Shallow, Moist: Hemlock - Cedar Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
26:{'EcoName':'Very Shallow, Moist: Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
27:{'EcoName':'Very Shallow, Moist: Red Pine - White Pine Mixedwood ','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
28:{'EcoName':'Very Shallow, Moist Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
29:{'EcoName':'Dry, Sandy: Field','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
30:{'EcoName':'Dry, Sandy: Meadow','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
31:{'EcoName':'Dry, Sandy: Sparse Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
32:{'EcoName':'Dry, Sandy: Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
33:{'EcoName':'Dry, Sandy: Red Pine - White Pine Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
34:{'EcoName':'Dry, Sandy: Jack Pine - Black Spruce Dominated','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
35:{'EcoName':'Dry, Sandy: Pine - Black Spruce Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
36:{'EcoName':'Dry, Sandy: Hemlock - Cedar Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
37:{'EcoName':'Dry, Sandy: Spruce - Fir Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
38:{'EcoName':'Dry, Sandy: Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
39:{'EcoName':'Dry, Sandy: Red Pine - White Pine Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
40:{'EcoName':'Dry, Sandy: Aspen - Birch Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
41:{'EcoName':'Dry, Sandy: Oak Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
42:{'EcoName':'Dry, Sandy: Maple Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
43:{'EcoName':'Dry, Sandy: Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
44:{'EcoName':'Dry to Fresh, Coarse: Field','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
45:{'EcoName':'Dry to Fresh, Coarse: Meadow','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
46:{'EcoName':'Dry to Fresh, Coarse: Sparse Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
47:{'EcoName':'Dry to Fresh, Coarse: Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
48:{'EcoName':'Dry to Fresh, Coarse: Red Pine - White Pine Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
49:{'EcoName':'Dry to Fresh, Coarse: Jack Pine - Black Spruce Dominated','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
50:{'EcoName':'Dry to Fresh, Coarse: Pine - Black Spruce Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
51:{'EcoName':'Dry to Fresh, Coarse: Hemlock - Cedar Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
52:{'EcoName':'Dry to Fresh, Coarse: Spruce - Fir Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
53:{'EcoName':'Dry to Fresh, Coarse: Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
54:{'EcoName':'Dry to Fresh, Coarse: Red Pine - White Pine Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
55:{'EcoName':'Dry to Fresh, Coarse: Aspen - Birch Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
56:{'EcoName':'Dry to Fresh, Coarse: Elm - Ash Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
57:{'EcoName':'Dry to Fresh, Coarse: Oak Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
58:{'EcoName':'Dry to Fresh, Coarse: Maple Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
59:{'EcoName':'Dry to Fresh, Coarse: Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
60:{'EcoName':'Moist, Coarse: Field','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
61:{'EcoName':'Moist, Coarse: Meadow','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
62:{'EcoName':'Moist, Coarse: Sparse Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
63:{'EcoName':'Moist, Coarse: Shrub','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
64:{'EcoName':'Moist, Coarse: Red Pine - White Pine Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
65:{'EcoName':'Moist, Coarse: Pine - Black Spruce Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
66:{'EcoName':'Moist, Coarse: Hemlock - Cedar Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
67:{'EcoName':'Moist, Coarse: Spruce - Fir Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
68:{'EcoName':'Moist, Coarse: Conifer','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
69:{'EcoName':'Moist, Coarse: Red Pine - White Pine Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
70:{'EcoName':'Moist, Coarse: Aspen - Birch Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
71:{'EcoName':'Moist, Coarse: Elm - Ash Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
72:{'EcoName':'Moist, Coarse: Oak Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
73:{'EcoName':'Moist, Coarse: Sugar Maple Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
74:{'EcoName':'Moist, Coarse: Red Maple Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
75:{'EcoName':'Moist, Coarse: Maple Hardwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
76:{'EcoName':'Moist, Coarse: Mixedwood','FieldCap':13,'WiltPoint':7,'SoilFert':10,},
77:{'EcoName':'Fresh, Clayey: Field','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
78:{'EcoName':'Fresh, Clayey: Meadow','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
79:{'EcoName':'Fresh, Clayey: Sparse Shrub','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
80:{'EcoName':'Fresh, Clayey: Shrub','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
81:{'EcoName':'Fresh, Clayey: Red Pine - White Pine Conifer','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
82:{'EcoName':'Fresh, Clayey: Jack Pine - Black Spruce Dominated','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
83:{'EcoName':'Fresh, Clayey: Pine - Black Spruce Conifer','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
84:{'EcoName':'Fresh, Clayey: Hemlock - Cedar Conifer','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
85:{'EcoName':'Fresh, Clayey: Spruce - Fir Conifer','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
86:{'EcoName':'Fresh, Clayey: Conifer','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
87:{'EcoName':'Fresh, Clayey: Red Pine - White Pine Mixedwood','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
88:{'EcoName':'Fresh, Clayey: Aspen - Birch Hardwood','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
89:{'EcoName':'Fresh, Clayey: Elm - Ash Hardwood','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
90:{'EcoName':'Fresh, Clayey: Oak Hardwood','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
91:{'EcoName':'Fresh, Clayey: Maple Hardwood','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
92:{'EcoName':'Fresh, Clayey: Mixedwood','FieldCap':45,'WiltPoint':22,'SoilFert':10,},
93:{'EcoName':'Fresh, Silty to Fine Loamy: Field','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
94:{'EcoName':'Fresh, Silty to Fine Loamy: Meadow','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
95:{'EcoName':'Fresh, Silty to Fine Loamy: Sparse Shrub','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
96:{'EcoName':'Fresh, Silty to Fine Loamy: Shrub','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
97:{'EcoName':'Fresh, Silty to Fine Loamy: Red Pine - White Pine Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
98:{'EcoName':'Fresh, Silty to Fine Loamy: Jack Pine - Black Spruce Dominated','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
99:{'EcoName':'Fresh, Silty to Fine Loamy: Pine - Black Spruce Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
100:{'EcoName':'Fresh, Silty to Fine Loamy: Hemlock - Cedar Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
101:{'EcoName':'Fresh, Silty to Fine Loamy: Spruce - Fir Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
102:{'EcoName':'Fresh, Silty to Fine Loamy: Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
103:{'EcoName':'Fresh, Silty to Fine Loamy: Red Pine - White Pine Mixedwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
104:{'EcoName':'Fresh, Silty to Fine Loamy: Aspen - Birch Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
105:{'EcoName':'Fresh, Silty to Fine Loamy: Elm - Ash Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
106:{'EcoName':'Fresh, Silty to Fine Loamy: Oak Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
107:{'EcoName':'Fresh, Silty to Fine Loamy: Maple Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
108:{'EcoName':'Fresh, Silty to Fine Loamy: Mixedwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
109:{'EcoName':'Moist, Fine: Field','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
110:{'EcoName':'Moist, Fine: Meadow','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
111:{'EcoName':'Moist, Fine: Sparse Shrub','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
112:{'EcoName':'Moist, Fine: Shrub','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
113:{'EcoName':'Moist, Fine: White Pine Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
114:{'EcoName':'Moist, Fine: Pine - Black Spruce Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
115:{'EcoName':'Moist, Fine: Hemlock - Cedar Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
116:{'EcoName':'Moist, Fine: Spruce - Fir Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
117:{'EcoName':'Moist, Fine: Conifer','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
118:{'EcoName':'Moist, Fine: White Pine Mixedwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
119:{'EcoName':'Moist, Fine: Aspen - Birch Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
120:{'EcoName':'Moist, Fine: Elm - Ash Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
121:{'EcoName':'Moist, Fine: Oak Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
122:{'EcoName':'Moist, Fine: Sugar Maple Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
123:{'EcoName':'Moist, Fine: Red Maple Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
124:{'EcoName':'Moist, Fine: Maple Hardwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
125:{'EcoName':'Moist, Fine: Mixedwood','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
126:{'EcoName':'Treed Bog','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
127:{'EcoName':'Poor Conifer Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
128:{'EcoName':'Intermediate Conifer Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
129:{'EcoName':'Rich Conifer Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
130:{'EcoName':'Intolerant Hardwood Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
131:{'EcoName':'Maple Hardwood Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
132:{'EcoName':'Oak Hardwood Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
133:{'EcoName':'Hardwood Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
134:{'EcoName':'Mineral Thicket Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
135:{'EcoName':'Organic Thicket Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
136:{'EcoName':'Sparse Treed Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
137:{'EcoName':'Sparse Treed Bog','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
138:{'EcoName':'Open Bog','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
139:{'EcoName':'Poor Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
140:{'EcoName':'Open Moderately Rich Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
141:{'EcoName':'Open Extremely Rich Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
142:{'EcoName':'Mineral Meadow Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
143:{'EcoName':'Rock Meadow Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
144:{'EcoName':'Organic Meadow Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
145:{'EcoName':'Floating Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
146:{'EcoName':'Open Shore Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
147:{'EcoName':'Shrub Shore Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
148:{'EcoName':'Mineral Shallow Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
149:{'EcoName':'Organic Shallow Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
150:{'EcoName':'Open Water Marsh: Floating-leaved','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
151:{'EcoName':'Open Water Marsh: Mineral','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
152:{'EcoName':'Open Water Marsh: Organic','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
153:{'EcoName':'Constructed Water Collections','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
154:{'EcoName':'Active Limnetic Bedrock','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
155:{'EcoName':'Active Limnetic Mineral','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
156:{'EcoName':'Active Limnetic Organic','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
157:{'EcoName':'Active Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
158:{'EcoName':'Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
159:{'EcoName':'Open Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
160:{'EcoName':'Active Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
161:{'EcoName':'Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
162:{'EcoName':'Open Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
163:{'EcoName':'Active Rock Barren','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
164:{'EcoName':'Rock Barren','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
165:{'EcoName':'Open Rock Barren','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
166:{'EcoName':'Active Talus or Historic/Raised Beach','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
167:{'EcoName':'Talus or Historic/Raised Beach','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
168:{'EcoName':'Open Talus or Historic/Raised Beach','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
169:{'EcoName':'Anthropogenic Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
170:{'EcoName':'Active Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
171:{'EcoName':'Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
172:{'EcoName':'Open Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
173:{'EcoName':'Calcareous Active Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
174:{'EcoName':'Calcareous Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
175:{'EcoName':'Calcareous Open Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
176:{'EcoName':'Calcareous Active Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
177:{'EcoName':'Calcareous Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
178:{'EcoName':'Calcareous Open Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
179:{'EcoName':'Calcareous Active Rock Barren','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
180:{'EcoName':'Calcareous Rock Barren','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
181:{'EcoName':'Calcareous Open Rock Barren','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
182:{'EcoName':'Calcareous Active Talus or Historic/Raised Beach','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
183:{'EcoName':'Calcareous Talus or Historic/Raised Beach','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
184:{'EcoName':'Calcareous Open Talus or Historic/Raised Beach','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
185:{'EcoName':'Calcareous Anthropogenic Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
186:{'EcoName':'Calcareous Active Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
187:{'EcoName':'Calcareous Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
188:{'EcoName':'Calcareous Open Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
189:{'EcoName':'Constructed Vertical Surface','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
190:{'EcoName':'Industrial Waste','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
191:{'EcoName':'Active Waste Disposal/Landfill','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
192:{'EcoName':'Waste Disposal/Landfill','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
193:{'EcoName':'Active Coarse Clean Fill','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
194:{'EcoName':'Coarse Clean Fill','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
195:{'EcoName':'Active Fine Clean Fill','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
196:{'EcoName':'Fine Clean Fill','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
197:{'EcoName':'Pavement/Concrete','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
198:{'EcoName':'Compact Graveled Surface','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
199:{'EcoName':'Compact Mineral Surface','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
200:{'EcoName':'Other Materials','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
201:{'EcoName':'Active Coastal Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
202:{'EcoName':'Open Coastal Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
203:{'EcoName':'Coastal Cliff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
204:{'EcoName':'Active Coastal Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
205:{'EcoName':'Open Coastal Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
206:{'EcoName':'Coastal Bedrock Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
207:{'EcoName':'Active Coastal Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
208:{'EcoName':'Open Coastal Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
209:{'EcoName':'Coastal Coarse Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
210:{'EcoName':'Active Coastal Bluff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
211:{'EcoName':'Open Coastal Bluff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
212:{'EcoName':'Coastal Bluff','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
213:{'EcoName':'Active Coastal Mineral Shoreline','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
214:{'EcoName':'Active Coastal Sand Dune','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
215:{'EcoName':'Coastal Mineral Barren','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
216:{'EcoName':'Salt Thicket Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
217:{'EcoName':'Salt Poor Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
218:{'EcoName':'Open Salt Fen','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
219:{'EcoName':'Salt Meadow Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
220:{'EcoName':'Salt Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
221:{'EcoName':'Open Salt Marsh','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
222:{'EcoName':'Mineral Poor Conifer Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
223:{'EcoName':'Mineral Intermediate Conifer Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
224:{'EcoName':'Mineral Rich Conifer Swamp','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
997:{'EcoName':'Commercial / Industrial Unclassified','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
998:{'EcoName':'Utilities Unclassified','FieldCap':30,'WiltPoint':15,'SoilFert':10,},
999:{'EcoName':'Residential Unclassified','FieldCap':30,'WiltPoint':15,'SoilFert':10,},

}


def ecosite_lut(ecosite,parameter='FieldCap,WiltPoint,SoilFert'):
	#print ecosite[1:4]
	e = int(ecosite[1:4])
	
	
	
	return dict( zip (  parameter.split(","),  [  ecosite_table[e][f] for f in parameter.split(",") ] ) )
	
	
if __name__ == '__main__':
	print ecosite_lut('B034TtD n') #sample from data with some pines on it
	
	
