# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OGFlushPluginDialog
                                 A QGIS plugin
 This plugin creates a sewer network from geodata
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-06-17
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Arbeitsgruppe Siedlungshydrologie, Institut für Siedlungs- und Industriewasserwirtschaft, Technische Universität Dresden
        email                : diego.novoa_vazquez@tu-dresden.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'og_flush_dialog_base.ui'))


class OGFlushPluginDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(OGFlushPluginDialog, self).__init__(parent)
        
        self.setupUi(self)
        
        self.checkbox_state_changed(self.mixed_cb.isChecked())
        self.mixed_cb.stateChanged.connect(self.checkbox_state_changed)
        self.checkbox_state_changed2(self.gw_cb.isChecked())
        self.gw_cb.stateChanged.connect(self.checkbox_state_changed2)
        
        self.mixed_cb.setToolTip('Select here to consider a combined sewer system instead of a separate system')
        self.buildbox.setToolTip('Load here the layer with buildings in your study area')
        self.streetbox.setToolTip('Load here the layer with the streets in your study area')
        self.catchbox.setToolTip('Load here the layer with the study area or urban catchment')
        self.outletbox.setToolTip('Load here the layer with the outlet for your sewer network')
        self.dembox.setToolTip('Load here the layer with a digital elevation model')
        self.pipe_depth.setToolTip('Select the minimum depth for your nodes according to local regulations')
        self.dist_thresh.setToolTip('Enter here a distance threshold to consider for the generation of subcatchments')
        self.return_period.setToolTip('Select the return period for sewer network design according to local regulations')
        self.build_min_sl.setToolTip('Select a minimum slope for buildings for generation of subcatchments')
        self.build_max_slope.setToolTip('Select a maximum slope for buildings for generation of subcatchments')
        self.r15_rain.setToolTip('Enter here the relative rain intensity for design of 15 minutes with one year return period')
        self.st_min_slope.setToolTip('Select a minimum slope for streets for generation of subcatchments')
        self.st_max_sl.setToolTip('Select a maximum slope for streets for generation of subcatchments')
        self.tf_min.setToolTip('Enter the minimum flow time for dimensioning with the rationale method')
        self.gw_cb.setToolTip('Check to consider extraneaous ground water infiltration  (only works with combined systems)')
        self.consumption_perc.setToolTip('Percentage of extraneous water as a fraction of dry weather flow')
        self.min_slope_pipe.setToolTip('Select minimum slope for pipes in the network according to local regulations')
        self.popbox.setToolTip('Load here layer (as a point layer) with population in the area')
        self.pop_grow.setToolTip('Enter here the percentage of annual growth of population')
        self.consumption.setToolTip('Enter here the per capita consuption of water per day')
        self.years_growth.setToolTip('Enter here the years used for considering population growth')
        self.meshness_perc.setToolTip('Write down the amount of extra pipes you want for additional support of the system, as percentage of the skipped connections (streets)')
        self.output_name.setToolTip('Select a location for the generated files')
        
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        
        # for child in self.children():
        #     print(child.objectName())
        
        
    def checkbox_state_changed(self, state):
        # state == 2 means the checkbox is checked
        if state == 2:
            # Disable the combobox and spinbox
            self.popbox.setEnabled(True)
            self.pop_grow.setEnabled(True)
            self.pb_pop.setEnabled(True)
            self.consumption.setEnabled(True)
            self.years_growth.setEnabled(True)
            
        else:
            # Enable the combobox and spinbox

            self.popbox.setEnabled(False)
            self.pop_grow.setEnabled(False)
            self.pb_pop.setEnabled(False)
            self.consumption.setEnabled(False)
            self.years_growth.setEnabled(False)
            
    def checkbox_state_changed2(self, state):
        # state == 2 means the checkbox is checked
        if state == 2:
            self.consumption_perc.setEnabled(True)
        else:
            self.consumption_perc.setEnabled(False)
