# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OemcStac
                                 A QGIS plugin
 This plugin provides easy access to OEMC STAC catalog
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-11-07
        git sha              : $Format:%H$
        copyright            : (C) 2023 by OpenGeoHub
        email                : murat.sahin@opengeohub.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .oemc_plugin_dialog import OemcStacDialog
import os.path
import os

from pathlib import Path
import sys
import os 
sys.path.append(str(Path(__file__).parents[0])+'/src') # findable lib path

from .cache import Database

from .threads import CatalogThread, ItemThread, AssetThread, HypertextThread, RegisterDataThread

#importing the QT libs to control ui
from qgis.core import QgsProject, QgsApplication
from qgis.PyQt.QtCore import Qt, QThreadPool

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QListWidget


class OemcStac:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'OemcStac_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&OEMC Plugin')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        ############################################
        # tapping on the project structure to use it
        self.project_tree = QgsProject.instance().layerTreeRoot() # QgsLayerTree()
        # saving the stac names and catalog urls as a variable
        self.main_url = None
        self.oemc_stacs = dict(
            OpenLandMap = "https://s3.eu-central-1.wasabisys.com/stac/openlandmap/catalog.json",
            EcoDataCube = "https://s3.eu-central-1.wasabisys.com/stac/odse/catalog.json"
        )
        self.task_manager = QgsApplication.taskManager()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('OemcStac', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/oemc_plugin/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'OEMC Plugin'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&OEMC Plugin'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = OemcStacDialog()

            # creating some variable to handle the state of the plugin
            
            
            self.thread_pool = QThreadPool().globalInstance()
            self.thread_pool.setMaxThreadCount(int(self.thread_pool.maxThreadCount()/2))

            # defining settings for the ui elements on the start
            self.dlg.listCatalog.view().setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
            # self.dlg.addStrategy.view().setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
            self.dlg.listItems.setSelectionMode(QListWidget.ExtendedSelection)
            self.dlg.listAssets.setSelectionMode(QListWidget.ExtendedSelection)
            # adding the stac names from oemc_stac variable
            self.dlg.listCatalog.addItem("") # extra space for visual concerns
            self.dlg.listCatalog.addItems(list(self.oemc_stacs.keys()))
            self.dlg.addLayers.setEnabled(False)
            self.dlg.clearCache.setEnabled(False)
            self.dlg.searchBox.setEnabled(False)

        # functionalities
        # change on the selection of the catalog will update the
        # listCatalog and fills it with the collection names
        self.dlg.listCatalog.currentIndexChanged.connect(self.catalog_task_handler)
        # based on the selection from collections this will trigered
        # following the selection this will fills the listItems
        # self.dlg.listCollection.itemClicked.connect(self.taskhandler_items)
        self.dlg.listCollection.itemClicked.connect(self.item_task_handler)
        # this will fills the listAssets with unique assets
        self.dlg.listItems.itemClicked.connect(self.asset_task_handler)
        # this will set selected variable for seleceted assets
        self.dlg.listAssets.itemClicked.connect(self.selecting_assets)
        # this will fills the strategies wit predefined add layer strategies
        # self.dlg.addStrategy.addItems(self.strategies)
        # finally some one is going to push the addLayers button

        self.dlg.addLayers.clicked.connect(self.register_dataset)
        self.dlg.clearCache.clicked.connect(self.handle_cache)
        self.dlg.searchBox.textChanged.connect(self.handle_search)
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        # result = self.dlg.exec_()
        # See if OK was pressed
        # if result:
        #     # Do something useful here - delete the line containing pass and
        #     # substitute with your code.
        #     pass

    def _clear_ui(self, params:list) -> None:
        if ('all' in params ) or ('item' in params):
            self.dlg.listItems.clear()

        if ('all' in params ) or ('asset' in params):
            self.dlg.listAssets.clear()

        if ('all' in params ) or ('collection' in params):
            self.dlg.listCollection.clear()

    def handle_cache(self):
        db_file = f"{os.path.dirname(__file__)}/db/{self.dlg.listCatalog.currentText()}.db"
        if os.path.isfile(db_file):
            os.remove(db_file)
        self.dlg.searchBox.clear()
        self.dlg.listCatalog.setCurrentIndex(0)
        self._clear_ui(['all'])
        self.dlg.searchBox.setEnabled(False)

        self.dlg.clearCache.setEnabled(False)

    def handle_search(self, text):
        self._clear_ui(['all'])
        if text == ' ':
            self.dlg.listCollection.addItems(
                self.database.get_all_collection_names()
            )
        else:
            self.dlg.listCollection.addItems(
                self.database.get_collection_by_keyword(text)
            )
        
    def _block_button(self):
        self.dlg.addLayers.setEnabled(False)
    
    def catalog_task_handler(self, _):
        """
        This function manages Catalog information in the UI.
        """
        # clean the ui and diable the add button
        self._clear_ui(['all'])
        self._block_button()

        selected_catalogname = self.dlg.listCatalog.currentText()
        if selected_catalogname != "":
            self.database = Database(selected_catalogname)
            
        # check cache exist or not
        collection_names = [i[0] for i in self.database.get_all_collection_names()]
        if collection_names != []:
            self.dlg.listCollection.addItems(collection_names)
        else:
            catalog_thread = CatalogThread(self.current_url())
            self.task_manager.addTask(catalog_thread)
            catalog_thread.result.connect(self.listing_thread_collection)
        self.dlg.clearCache.setEnabled(True)
        self.dlg.searchBox.clear()
        self.dlg.searchBox.setEnabled(True)

    def listing_thread_collection(self, arg):
        self._clear_ui(['all']) # clean the ui
        # self.database.flush_all() # clean the cache
        self.dlg.listCollection.addItems(list(arg.keys())) # fill the ui
        # create the cache
        for title, id in arg.items():
            self.database.insert_collection(id, title)

    def current_url(self):
        name = self.dlg.listCatalog.currentText()
        if name != "":
            return self.oemc_stacs[name]

    def current_collection_id(self):
        return self.database.get_collection_by_title(self.dlg.listCollection.currentItem().text())

    def current_collection_name(self):
        return self.dlg.listCollection.currentItem().text()
    
    def item_task_handler(self, _):
        # clean the ui and block the button
        self._clear_ui(['item','asset'])
        self._block_button()

        items_cache = self.database.get_item_by_collection_id(self.current_collection_id())
        if items_cache != []:
            self.dlg.listItems.addItems(items_cache)
        else:
            item_thread = ItemThread(self.current_url(), self.current_collection_id())
            self.task_manager.addTask(item_thread)
            item_thread.result.connect(self.listing_thread_items)

    def listing_thread_items(self, args):
        self.dlg.listItems.addItems(args)
        self.database.insert_items(args, self.current_collection_id())

    def current_items(self):
        return [i.text() for i in self.dlg.listItems.selectedItems()]

    def all_items(self):
        return [self.dlg.listItems.item(i).text() for i in range(self.dlg.listItems.count())]
        
    def asset_task_handler(self,_):
        # clean the ui and block the button
        self._clear_ui(['asset'])
        self._block_button()

        asset_cache = self.database.get_asset_by_item_id(self.current_items())
        if asset_cache != []:
            self.dlg.listAssets.addItems(asset_cache)
        else:
            asset_thread = AssetThread(
                self.current_url(),
                self.current_collection_id(),
                self.all_items()
            )
            self.task_manager.addTask(asset_thread)
            asset_thread.result.connect(self.listing_thread_asset)

    def listing_thread_asset(self, args):
        self._clear_ui(['asset'])
        self.dlg.listAssets.addItems(sorted(list(set(args))))
        hypertext_thread = HypertextThread(
            self.current_url(),
            self.current_collection_id(),
            self.all_items(),
            args
        )
        self.task_manager.addTask(hypertext_thread)
        hypertext_thread.result.connect(self.database.insert_assets)


    def current_assets(self):
        return [i.text() for i in self.dlg.listAssets.selectedItems()]

    def selecting_assets(self):
        self.dlg.addLayers.setEnabled(True)

    def register_dataset(self):
        data = self.database.get_data_from_asset(self.current_items(), self.current_assets())
        collection_name = self.current_collection_name()
        collection_tree = QgsProject.instance().layerTreeRoot().findGroup(collection_name)
        if collection_tree is None:
            collection_tree = QgsProject.instance().layerTreeRoot().addGroup(collection_name)
        for i, d in enumerate(data):
            item_tree = collection_tree.findGroup(d[0])
            if item_tree is None:
                item_tree = collection_tree.addGroup(d[0])
            data_registerer = RegisterDataThread(d, item_tree)
            self.thread_pool.start(data_registerer)
            item_tree.setExpanded(False)
            item_tree.setItemVisibilityChecked(False)
        collection_tree.setExpanded(False)
        collection_groups = QgsProject.instance().layerTreeRoot().findGroups()
        if len(collection_groups) == 1:
            collection_groups[0].findGroups()[0].setItemVisibilityChecked(True)
        else:
            collection_index = [i.name() for i in collection_groups].index(self.current_collection_name())
            QgsProject.instance().layerTreeRoot().findGroups()[collection_index].findGroups()[0].setItemVisibilityChecked(True)

# Qt5 documentation
# https://doc.qt.io/qt-5/qtwidgets-module.html